/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.LazyFinalReference;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;
import sun.security.util.SecurityConstants;

public final class ProtectionDomainSupport {
    private final LazyFinalReference<ProtectionDomain> allPermDomain = new LazyFinalReference<ProtectionDomain>(this::createAllPermDomain);
    Supplier<URL> executableURLSupplier;

    public static ProtectionDomain allPermDomain() {
        return ((ProtectionDomainSupport)ImageSingletons.lookup(ProtectionDomainSupport.class)).allPermDomain.get();
    }

    private ProtectionDomain createAllPermDomain() {
        Permissions perms = new Permissions();
        perms.add(SecurityConstants.ALL_PERMISSION);
        URL executableURL = this.executableURLSupplier != null ? this.executableURLSupplier.get() : null;
        CodeSource cs = new CodeSource(executableURL, (Certificate[])null);
        return new ProtectionDomain(cs, perms);
    }

    private static URL createExecutableURL() {
        String executableName = ProcessProperties.getExecutableName();
        if (executableName != null) {
            try {
                return new File(executableName).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void enableCodeSource() {
        ((ProtectionDomainSupport)ImageSingletons.lookup(ProtectionDomainSupport.class)).executableURLSupplier = ProtectionDomainSupport::createExecutableURL;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> UseApplicationCodeSourceLocation = new HostedOptionKey<Object>(null);
    }
}

