/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.util.VMError;
import java.nio.Buffer;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

class BufferAddressTransformer
implements FieldValueTransformer {
    BufferAddressTransformer() {
    }

    public Object transform(Object receiver, Object originalValue) {
        Buffer buffer = (Buffer)receiver;
        long hostedAddress = (Long)originalValue;
        if (buffer.isDirect()) {
            return -2401053092611807099L;
        }
        Object bufferBase = SharedSecrets.getJavaNioAccess().getBufferBase(buffer);
        if (bufferBase == null) {
            VMError.guarantee(hostedAddress == 0L, "When the buffer does not have a backing array, the address must be unused too: buffer %s of %s, address %s", buffer, buffer.getClass(), hostedAddress);
            return hostedAddress;
        }
        VMError.guarantee(bufferBase.getClass().isArray(), "Buffer is not backed by an array: buffer %s of %s, address %s", buffer, buffer.getClass(), hostedAddress);
        long hostedBaseOffset = Unsafe.getUnsafe().arrayBaseOffset(bufferBase.getClass());
        int hostedIndexScale = Unsafe.getUnsafe().arrayIndexScale(bufferBase.getClass());
        ObjectLayout layout = (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class);
        JavaKind kind = JavaKind.fromJavaClass(bufferBase.getClass().getComponentType());
        long runtimeBaseOffset = layout.getArrayBaseOffset(kind);
        int runtimeIndexScale = layout.getArrayIndexScale(kind);
        VMError.guarantee(hostedIndexScale == runtimeIndexScale, "Currently the hosted and runtime array index scale is always the same, so we do not need to transform");
        VMError.guarantee(hostedAddress >= hostedBaseOffset, "invalid address: %s, %s", hostedAddress, hostedBaseOffset);
        return hostedAddress - hostedBaseOffset + runtimeBaseOffset;
    }
}

