/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.interpreter.InterpreterFrameSourceInfo;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class BacktraceVisitor
extends JavaStackFrameVisitor {
    private int index = 0;
    private int numFrames = 0;
    private final int limit = BacktraceVisitor.computeNativeLimit();
    private static final int INITIAL_TRACE_SIZE = 80;
    private long[] trace = new long[80];
    public static final int NATIVE_FRAME_LIMIT_MARGIN = 10;

    BacktraceVisitor() {
    }

    @Fold
    static int entriesPerSourceReference() {
        return BacktraceVisitor.useCompressedReferences() ? 2 : 3;
    }

    private static int computeNativeLimit() {
        int maxJavaStackTraceDepth = SubstrateOptions.maxJavaStackTraceDepth();
        if (maxJavaStackTraceDepth <= 0) {
            return Integer.MAX_VALUE;
        }
        int maxJavaStackTraceDepthExtended = maxJavaStackTraceDepth + 10;
        return maxJavaStackTraceDepthExtended > maxJavaStackTraceDepth ? maxJavaStackTraceDepthExtended : Integer.MAX_VALUE;
    }

    @Override
    public boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo) {
        if (!InterpreterSupport.isEnabled() && CodeInfoTable.isInAOTImageCode(ip)) {
            this.visitAOTFrame(ip);
        } else {
            CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip);
            assert (queryResult != null);
            for (FrameInfoQueryResult frameInfo = queryResult.getFrameInfo(); frameInfo != null; frameInfo = frameInfo.getCaller()) {
                if (this.dispatchPossiblyInterpretedFrame(frameInfo, sp)) continue;
                return false;
            }
        }
        return this.numFrames != this.limit;
    }

    @Override
    protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
        for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
            FrameInfoQueryResult frameInfo = frame.getFrameInfo();
            if (this.dispatchPossiblyInterpretedFrame(frameInfo, originalSP)) continue;
            return false;
        }
        return this.numFrames != this.limit;
    }

    private void visitAOTFrame(CodePointer ip) {
        long rawValue = ip.rawValue();
        VMError.guarantee(rawValue != 0L, "Unexpected code pointer: 0");
        if (BacktraceVisitor.isSourceReference(rawValue)) {
            throw VMError.shouldNotReachHere("Not a code pointer: 0x" + Long.toHexString(rawValue));
        }
        this.ensureSize(this.index + 1);
        this.trace[this.index++] = rawValue;
        ++this.numFrames;
    }

    @Override
    public boolean visitFrame(FrameSourceInfo frameSourceInfo) {
        if (!StackTraceUtils.shouldShowFrame(frameSourceInfo)) {
            return true;
        }
        if (this.index == 0 && Throwable.class.isAssignableFrom(frameSourceInfo.getSourceClass())) {
            return true;
        }
        int sourceLineNumber = frameSourceInfo.getSourceLineNumber();
        Class<?> sourceClass = frameSourceInfo.getSourceClass();
        String sourceMethodName = frameSourceInfo.getSourceMethodName();
        if (!(frameSourceInfo instanceof InterpreterFrameSourceInfo)) {
            VMError.guarantee(Heap.getHeap().isInImageHeap(sourceClass), "Source class must be in the image heap");
            VMError.guarantee(Heap.getHeap().isInImageHeap(sourceMethodName), "Source method name string must be in the image heap");
        }
        this.ensureSize(this.index + BacktraceVisitor.entriesPerSourceReference());
        BacktraceVisitor.writeSourceReference(this.trace, this.index, sourceLineNumber, sourceClass, sourceMethodName);
        this.index += BacktraceVisitor.entriesPerSourceReference();
        ++this.numFrames;
        return this.numFrames != this.limit;
    }

    public static boolean isSourceReference(long entry) {
        return entry < 0L;
    }

    public static long encodeLineNumber(int lineNumber) {
        return 0xFFFFFFFF00000000L | (long)lineNumber;
    }

    public static int decodeLineNumber(long entry) {
        return (int)entry;
    }

    static void writeSourceReference(long[] backtrace, int pos, int sourceLineNumber, Class<?> sourceClass, String sourceMethodName) {
        long encodedLineNumber = BacktraceVisitor.encodeLineNumber(sourceLineNumber);
        if (!BacktraceVisitor.isSourceReference(encodedLineNumber)) {
            throw VMError.shouldNotReachHere("Encoded line number looks like a code pointer: " + encodedLineNumber);
        }
        backtrace[pos] = encodedLineNumber;
        if (BacktraceVisitor.useCompressedReferences()) {
            long sourceClassOop = BacktraceVisitor.assertNonZero(ReferenceAccess.singleton().getCompressedRepresentation(sourceClass).rawValue());
            long sourceMethodNameOop = BacktraceVisitor.assertNonZero(ReferenceAccess.singleton().getCompressedRepresentation(sourceMethodName).rawValue());
            VMError.guarantee((0xFFFFFFFF00000000L & sourceClassOop) == 0L, "Compressed source class reference with high bits");
            VMError.guarantee((0xFFFFFFFF00000000L & sourceMethodNameOop) == 0L, "Compressed source methode name reference with high bits");
            backtrace[pos + 1] = sourceClassOop << 32 | sourceMethodNameOop;
        } else {
            backtrace[pos + 1] = BacktraceVisitor.assertNonZero(Word.objectToUntrackedPointer(sourceClass).rawValue());
            backtrace[pos + 2] = BacktraceVisitor.assertNonZero(Word.objectToUntrackedPointer((Object)sourceMethodName).rawValue());
        }
    }

    static int readSourceLineNumber(long[] backtrace, int pos) {
        return BacktraceVisitor.decodeLineNumber(backtrace[pos]);
    }

    static Class<?> readSourceClass(long[] backtrace, int pos) {
        if (BacktraceVisitor.useCompressedReferences()) {
            UnsignedWord ref = Word.unsigned((long)backtrace[pos + 1]).unsignedShiftRight(32);
            return (Class)ReferenceAccess.singleton().uncompressReference(ref);
        }
        Word sourceClassPtr = (Word)Word.pointer((long)backtrace[pos + 1]);
        return (Class)sourceClassPtr.toObject(Class.class, true);
    }

    static String readSourceMethodName(long[] backtrace, int pos) {
        if (BacktraceVisitor.useCompressedReferences()) {
            UnsignedWord ref = Word.unsigned((long)backtrace[pos + 1]).and(Word.unsigned((long)0xFFFFFFFFL));
            return (String)ReferenceAccess.singleton().uncompressReference(ref);
        }
        Word sourceMethodNamePtr = (Word)Word.pointer((long)backtrace[pos + 2]);
        return (String)sourceMethodNamePtr.toObject(String.class, true);
    }

    @Fold
    static boolean useCompressedReferences() {
        return ConfigurationValues.getObjectLayout().getReferenceSize() == 4;
    }

    private static long assertNonZero(long rawValue) {
        VMError.guarantee(rawValue != 0L, "Must not write 0 values to backtrace");
        return rawValue;
    }

    private void ensureSize(int minLength) {
        if (minLength > this.trace.length) {
            this.trace = Arrays.copyOf(this.trace, BacktraceVisitor.saturatedMultiply(this.trace.length, 2));
        }
    }

    static int saturatedMultiply(int a, int b) {
        long r = (long)a * (long)b;
        if ((long)((int)r) != r) {
            return Integer.MAX_VALUE;
        }
        return (int)r;
    }

    long[] getArray() {
        VMError.guarantee(this.trace != null, "Already acquired");
        VMError.guarantee(this.index == this.trace.length || this.trace[this.index] == 0L, "Unterminated trace?");
        long[] tmp = this.trace;
        this.trace = null;
        return tmp;
    }
}

