/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.registry.AOTClassRegistry;
import com.oracle.svm.core.hub.registry.AbstractClassRegistry;
import com.oracle.svm.core.hub.registry.AbstractRuntimeClassRegistry;
import com.oracle.svm.core.hub.registry.BootClassRegistry;
import com.oracle.svm.core.hub.registry.UserDefinedClassRegistry;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.espresso.classfile.JavaVersion;
import com.oracle.svm.espresso.classfile.ParsingContext;
import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.ModifiedUTF8;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.NameSymbols;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Utf8Symbols;
import com.oracle.svm.espresso.classfile.perf.TimerCollection;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.internal.loader.BootLoader;
import jdk.internal.misc.PreviewFeatures;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.impl.ClassLoadingSupport;

@AutomaticallyRegisteredImageSingleton
public final class ClassRegistries
implements ParsingContext {
    public final TimerCollection timers = TimerCollection.create((boolean)false);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final ConcurrentHashMap<ClassLoader, AbstractClassRegistry> buildTimeRegistries;
    private final Utf8Symbols utf8;
    private final NameSymbols names;
    private final TypeSymbols types;
    private final AbstractClassRegistry bootRegistry;
    private final EconomicMap<String, String> bootPackageToModule;
    final ParsingContext.Logger logger = new ParsingContext.Logger(this){

        public void log(String message) {
            Log.log().string("Warning: ").string(message).newline();
        }

        public void log(Supplier<String> messageSupplier) {
            Log.log().string("Warning: ").string(messageSupplier.get()).newline();
        }

        public void log(String message, Throwable throwable) {
            Log.log().string("Warning: ").string(message).newline();
            Log.log().exception(throwable);
        }
    };

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ClassRegistries() {
        this.bootRegistry = RuntimeClassLoading.isSupported() ? new BootClassRegistry() : new AOTClassRegistry(null);
        ParserSymbols.ensureInitialized();
        int initialSymbolTableCapacity = 4096;
        Symbols symbols = Symbols.fromExisting((Set)ParserSymbols.SYMBOLS.freeze(), (int)initialSymbolTableCapacity, (int)0);
        this.utf8 = new Utf8Symbols(symbols);
        this.names = new NameSymbols(symbols);
        this.types = new TypeSymbols(symbols);
        this.buildTimeRegistries = new ConcurrentHashMap();
        this.bootPackageToModule = ClassRegistries.computeBootPackageToModuleMap();
    }

    private static EconomicMap<String, String> computeBootPackageToModuleMap() {
        Field moduleField = ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.NamedPackage"), (String)"module");
        EconomicMap bootPackageToModule = EconomicMap.create();
        BootLoader.packages().forEach(p -> {
            try {
                bootPackageToModule.put((Object)p.getName(), (Object)((Module)moduleField.get(p)).getName());
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        });
        return bootPackageToModule;
    }

    @Fold
    static ClassRegistries singleton() {
        return (ClassRegistries)ImageSingletons.lookup(ClassRegistries.class);
    }

    static String getBootModuleForPackage(String pkg) {
        return (String)ClassRegistries.singleton().bootPackageToModule.get((Object)pkg);
    }

    public static String[] getSystemPackageNames() {
        String[] result = new String[ClassRegistries.singleton().bootPackageToModule.size()];
        MapCursor cursor = ClassRegistries.singleton().bootPackageToModule.getEntries();
        int i = 0;
        while (cursor.advance()) {
            result[i++] = (String)cursor.getKey();
        }
        assert (i == result.length);
        return result;
    }

    TypeSymbols getTypes() {
        return this.types;
    }

    public static Class<?> findBootstrapClass(String name) {
        try {
            return ClassRegistries.singleton().resolve(name, null);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("The boot class loader shouldn't throw ClassNotFoundException", e);
        }
    }

    public static Class<?> findLoadedClass(String name, ClassLoader loader) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && RuntimeClassLoading.followReflectionConfiguration() && !ClassForNameSupport.isRegisteredClass(name)) {
            MissingReflectionRegistrationUtils.reportClassAccess(name);
            return null;
        }
        ByteSequence typeBytes = ByteSequence.createTypeFromName((String)name);
        Symbol type = ClassRegistries.singleton().getTypes().lookupValidType(typeBytes);
        Class<?> result = null;
        if (type != null) {
            result = ClassRegistries.singleton().getRegistry(loader).findLoadedClass((Symbol<Type>)type);
        }
        return result;
    }

    public static ParsingContext getParsingContext() {
        assert (RuntimeClassLoading.isSupported());
        return ClassRegistries.singleton();
    }

    public static Class<?> forName(String name, ClassLoader loader) throws ClassNotFoundException {
        return ClassRegistries.singleton().resolveOrThrowException(name, loader);
    }

    private Class<?> resolveOrThrowException(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = this.resolve(name, loader);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> resolve(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> elementalResult;
        int arrayDimensions;
        if (RuntimeClassLoading.followReflectionConfiguration()) {
            Throwable savedException;
            if (MissingRegistrationUtils.throwMissingRegistrationErrors() && !ClassForNameSupport.isRegisteredClass(name)) {
                MissingReflectionRegistrationUtils.reportClassAccess(name);
                if (loader == null) {
                    return null;
                }
                throw new ClassNotFoundException(name);
            }
            if (!RuntimeClassLoading.isSupported() && (savedException = ClassForNameSupport.getSavedException(name)) != null) {
                if (savedException instanceof Error) {
                    Error error = (Error)savedException;
                    throw error;
                }
                if (savedException instanceof ClassNotFoundException) {
                    ClassNotFoundException cnfe = (ClassNotFoundException)savedException;
                    throw cnfe;
                }
                throw VMError.shouldNotReachHere("Unexpected exception type", savedException);
            }
        }
        for (arrayDimensions = 0; arrayDimensions < name.length() && name.charAt(arrayDimensions) == '['; ++arrayDimensions) {
        }
        if (arrayDimensions == name.length()) {
            throw new ClassNotFoundException(name);
        }
        if (arrayDimensions > 0) {
            ClassLoadingSupport classLoadingSupport = (ClassLoadingSupport)ImageSingletons.lookup(ClassLoadingSupport.class);
            classLoadingSupport.startIgnoreReflectionConfigurationScope();
            try {
                elementalResult = this.resolveElementalType(name, arrayDimensions, loader);
            }
            finally {
                classLoadingSupport.endIgnoreReflectionConfigurationScope();
            }
        } else {
            elementalResult = this.resolveInstanceType(name, loader);
        }
        if (elementalResult == null) {
            if (loader == null) {
                return null;
            }
            throw new ClassNotFoundException(name);
        }
        if (arrayDimensions > 0) {
            Class<?> result = ClassRegistries.getArrayClass(name, elementalResult, arrayDimensions);
            if (result == null && loader != null) {
                throw new ClassNotFoundException(name);
            }
            return result;
        }
        return elementalResult;
    }

    private Class<?> resolveElementalType(String fullName, int arrayDimensions, ClassLoader loader) throws ClassNotFoundException {
        if (fullName.length() == arrayDimensions + 1) {
            return switch (fullName.charAt(arrayDimensions)) {
                case 'Z' -> Boolean.TYPE;
                case 'B' -> Byte.TYPE;
                case 'C' -> Character.TYPE;
                case 'S' -> Short.TYPE;
                case 'I' -> Integer.TYPE;
                case 'F' -> Float.TYPE;
                case 'J' -> Long.TYPE;
                case 'D' -> Double.TYPE;
                default -> null;
            };
        }
        assert (fullName.length() > arrayDimensions);
        ByteSequence elementalType = ByteSequence.createReplacingDot((String)fullName, (int)arrayDimensions);
        return this.resolveInstanceType(loader, elementalType);
    }

    private Class<?> resolveInstanceType(String name, ClassLoader loader) throws ClassNotFoundException {
        ByteSequence elementalType = ByteSequence.createTypeFromName((String)name);
        return this.resolveInstanceType(loader, elementalType);
    }

    private Class<?> resolveInstanceType(ClassLoader loader, ByteSequence elementalType) throws ClassNotFoundException {
        Symbol type = this.getTypes().getOrCreateValidType(elementalType);
        if (type == null) {
            return null;
        }
        return this.getRegistry(loader).loadClass((Symbol<Type>)type);
    }

    private static Class<?> getArrayClass(String name, Class<?> elementalResult, int arrayDimensions) {
        DynamicHub hub = SubstrateUtil.cast(elementalResult, DynamicHub.class);
        int remainingDims = arrayDimensions;
        while (remainingDims > 0) {
            if (hub.getArrayHub() == null) {
                if (RuntimeClassLoading.isSupported()) {
                    RuntimeClassLoading.getOrCreateArrayHub(hub);
                } else {
                    if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                        MissingReflectionRegistrationUtils.reportClassAccess(name);
                    }
                    return null;
                }
            }
            --remainingDims;
            hub = hub.getArrayHub();
        }
        return SubstrateUtil.cast(hub, Class.class);
    }

    public static Class<?> defineClass(ClassLoader loader, String name, byte[] b, int off, int len, RuntimeClassLoading.ClassDefinitionInfo info) {
        assert (RuntimeClassLoading.isSupported());
        if (RuntimeClassLoading.followReflectionConfiguration() && MissingRegistrationUtils.throwMissingRegistrationErrors() && !ClassForNameSupport.isRegisteredClass(name)) {
            MissingReflectionRegistrationUtils.reportClassAccess(name);
            throw ClassRegistries.sneakyThrow(new ClassNotFoundException(name));
        }
        ByteSequence typeBytes = ByteSequence.createTypeFromName((String)name);
        Symbol type = ClassRegistries.singleton().getTypes().getOrCreateValidType(typeBytes);
        if (type == null) {
            throw new NoClassDefFoundError(name);
        }
        AbstractRuntimeClassRegistry registry = (AbstractRuntimeClassRegistry)ClassRegistries.singleton().getRegistry(loader);
        return registry.defineClass((Symbol<Type>)type, b, off, len, info);
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
        throw ex;
    }

    public static String loaderNameAndId(ClassLoader loader) {
        if (loader == null) {
            return "bootstrap";
        }
        return SubstrateUtil.cast(loader, Target_java_lang_ClassLoader.class).nameAndId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractClassRegistry getRegistry(ClassLoader loader) {
        if (loader == null) {
            return this.bootRegistry;
        }
        Target_java_lang_ClassLoader svmLoader = SubstrateUtil.cast(loader, Target_java_lang_ClassLoader.class);
        AbstractClassRegistry registry = svmLoader.classRegistry;
        if (registry == null) {
            ClassLoader classLoader = loader;
            synchronized (classLoader) {
                registry = svmLoader.classRegistry;
                if (registry == null) {
                    registry = RuntimeClassLoading.isSupported() ? new UserDefinedClassRegistry(loader) : new AOTClassRegistry(loader);
                    svmLoader.classRegistry = registry;
                }
            }
        }
        return registry;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void addAOTClass(ClassLoader loader, Class<?> cls) {
        ClassRegistries.singleton().getBuildTimeRegistry(loader).addAOTType(cls);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private AbstractClassRegistry getBuildTimeRegistry(ClassLoader loader) {
        if (loader == null) {
            return this.bootRegistry;
        }
        return this.buildTimeRegistries.computeIfAbsent(loader, l -> {
            AbstractClassRegistry newRegistry = RuntimeClassLoading.isSupported() ? new UserDefinedClassRegistry((ClassLoader)l) : new AOTClassRegistry((ClassLoader)l);
            return newRegistry;
        });
    }

    public JavaVersion getJavaVersion() {
        return JavaVersion.HOST_VERSION;
    }

    public boolean isStrictJavaCompliance() {
        return false;
    }

    public TimerCollection getTimers() {
        return this.timers;
    }

    public boolean isPreviewEnabled() {
        return PreviewFeatures.isEnabled();
    }

    public ParsingContext.Logger getLogger() {
        return this.logger;
    }

    public Symbol<Name> getOrCreateName(ByteSequence byteSequence) {
        return ClassRegistries.singleton().names.getOrCreate(byteSequence);
    }

    public Symbol<Type> getOrCreateTypeFromName(ByteSequence byteSequence) {
        return ClassRegistries.singleton().getTypes().getOrCreateValidType(TypeSymbols.nameToType((ByteSequence)byteSequence));
    }

    public Symbol<? extends ModifiedUTF8> getOrCreateUtf8(ByteSequence byteSequence) {
        return ClassRegistries.singleton().utf8.getOrCreateValidUtf8(byteSequence, true);
    }

    public static class ClassRegistryComputer
    implements FieldValueTransformer {
        public Object transform(Object receiver, Object originalValue) {
            assert (receiver != null);
            return ClassRegistries.singleton().getBuildTimeRegistry((ClassLoader)receiver);
        }
    }
}

