/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.calc.UnsignedMath;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class LayoutEncoding {
    private static final int NEUTRAL_VALUE = 0;
    private static final int PRIMITIVE_VALUE = 1;
    private static final int INTERFACE_VALUE = 2;
    private static final int ABSTRACT_VALUE = 3;
    private static final int LAST_SPECIAL_VALUE = 3;
    private static final int ARRAY_INDEX_SHIFT_SHIFT = 0;
    private static final int ARRAY_INDEX_SHIFT_MASK = 255;
    private static final int ARRAY_BASE_SHIFT = 8;
    private static final int ARRAY_BASE_MASK = 4095;
    private static final int ARRAY_TAG_BITS = 3;
    private static final int ARRAY_TAG_SHIFT = 29;
    private static final int ARRAY_TAG_IDENTITY_BIT = 4;
    private static final int ARRAY_TAG_PRIMITIVE_BIT = 2;
    private static final int ARRAY_TAG_PURE_BIT = 1;
    private static final int ARRAY_TAG_PRIMITIVE_VALUE = 7;
    private static final int ARRAY_TAG_HYBRID_PRIMITIVE_VALUE = 6;
    private static final int ARRAY_TAG_OBJECT_VALUE = 5;
    private static final int ARRAY_TAG_HYBRID_OBJECT_VALUE = 4;

    public static int forPrimitive() {
        return 1;
    }

    public static int forInterface() {
        return 2;
    }

    public static int forAbstract() {
        return 3;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void guaranteeEncoding(ResolvedJavaType type, boolean expected, boolean actual, String description) {
        if (actual != expected) {
            throw VMError.shouldNotReachHere(description + ": expected to be " + expected + ". This error is caused by an incorrect compact encoding of a type (a class, array or a primitive). The error occurred with the following type, but also could be caused by characteristics of the overall type hierarchy: " + String.valueOf(type) + ". Please report this problem and the conditions in which it occurs and include any noteworthy characteristics of the type hierarchy and architecture of the application and the libraries and frameworks it uses.");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forPureInstance(ResolvedJavaType type, int size) {
        LayoutEncoding.guaranteeEncoding(type, true, size > 3, "Instance type size must be above special values for encoding: " + size);
        int encoding = size;
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.isPureInstance(encoding), "Instance type encoding denotes an instance");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isArray(encoding) || LayoutEncoding.isArrayLike(encoding), "Instance type encoding denotes an array-like object");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isHybrid(encoding), "Instance type encoding denotes a hybrid");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isObjectArray(encoding) || LayoutEncoding.isArrayLikeWithObjectElements(encoding), "Instance type encoding denotes an object array");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isPrimitiveArray(encoding) || LayoutEncoding.isArrayLikeWithPrimitiveElements(encoding), "Instance type encoding denotes a primitive array");
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.getPureInstanceAllocationSize(encoding).equal(Word.unsigned((int)size)), "Instance type encoding size matches type size");
        return encoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forArray(ResolvedJavaType type, boolean objectElements, int arrayBaseOffset, int arrayIndexShift) {
        return LayoutEncoding.forArrayLike(type, false, objectElements, arrayBaseOffset, arrayIndexShift);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forHybrid(ResolvedJavaType type, boolean objectElements, int arrayBaseOffset, int arrayIndexShift) {
        return LayoutEncoding.forArrayLike(type, true, objectElements, arrayBaseOffset, arrayIndexShift);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forDynamicHub(ResolvedJavaType type, int vtableOffset, int vtableIndexShift) {
        return LayoutEncoding.forArrayLike(type, true, false, vtableOffset, vtableIndexShift);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int forArrayLike(ResolvedJavaType type, boolean isHybrid, boolean objectElements, int arrayBaseOffset, int arrayIndexShift) {
        assert (isHybrid != type.isArray());
        int tag = isHybrid ? (objectElements ? 4 : 6) : (objectElements ? 5 : 7);
        int encoding = tag << 29 | arrayBaseOffset << 8 | arrayIndexShift << 0;
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.isArrayLike(encoding), "Array-like object encoding denotes an array-like object");
        LayoutEncoding.guaranteeEncoding(type, !isHybrid, LayoutEncoding.isArray(encoding), "Encoding denotes an array");
        LayoutEncoding.guaranteeEncoding(type, isHybrid, LayoutEncoding.isHybrid(encoding), "Encoding denotes a hybrid");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isPureInstance(encoding), "Array-like object encoding denotes an instance type");
        LayoutEncoding.guaranteeEncoding(type, objectElements, LayoutEncoding.isArrayLikeWithObjectElements(encoding), "Encoding denotes an array-like object with object elements");
        LayoutEncoding.guaranteeEncoding(type, !objectElements, LayoutEncoding.isArrayLikeWithPrimitiveElements(encoding), "Encoding denotes an array-like object with primitive elements");
        LayoutEncoding.guaranteeEncoding(type, !isHybrid && objectElements, LayoutEncoding.isObjectArray(encoding), "Encoding denotes an object array");
        LayoutEncoding.guaranteeEncoding(type, !isHybrid && !objectElements, LayoutEncoding.isPrimitiveArray(encoding), "Encoding denotes a primitive array");
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.getArrayBaseOffset(encoding).equal(Word.unsigned((int)arrayBaseOffset)), "Encoding denotes a base offset of " + arrayBaseOffset + " (actual value: " + String.valueOf(LayoutEncoding.getArrayBaseOffset(encoding)) + ")");
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.getArrayIndexShift(encoding) == arrayIndexShift, "Encoding denotes an index shift of " + arrayIndexShift + " (actual value: " + LayoutEncoding.getArrayIndexShift(encoding) + ")");
        return encoding;
    }

    public static boolean isPrimitive(int encoding) {
        return encoding == 1;
    }

    public static boolean isInterface(int encoding) {
        return encoding == 2;
    }

    public static boolean isAbstract(int encoding) {
        return encoding == 3;
    }

    public static boolean isSpecial(int encoding) {
        return encoding >= 0 && encoding <= 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPureInstance(int encoding) {
        return encoding > 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getPureInstanceAllocationSize(int encoding) {
        return Word.unsigned((int)encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getPureInstanceSize(DynamicHub hub, boolean withOptionalIdHashField) {
        int afterIdHashField;
        UnsignedWord size = LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding());
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (withOptionalIdHashField && ol.isIdentityHashFieldOptional() && size.belowThan(afterIdHashField = hub.getIdentityHashOffset() + 4)) {
            size = Word.unsigned((int)ol.alignUp(afterIdHashField));
        }
        return size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArray(int encoding) {
        int mask = -1610612736;
        return (encoding & mask) == mask;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArrayLike(int encoding) {
        return encoding < 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isHybrid(int encoding) {
        int setBits = Integer.MIN_VALUE;
        int mask = setBits | 0x20000000;
        return (encoding & mask) == setBits;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPrimitiveArray(int encoding) {
        return UnsignedMath.aboveOrEqual((int)encoding, (int)-536870912);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isObjectArray(int encoding) {
        return encoding >>> 29 == 5;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArrayLikeWithPrimitiveElements(int encoding) {
        return UnsignedMath.aboveOrEqual((int)encoding, (int)-1073741824);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArrayLikeWithObjectElements(int encoding) {
        return encoding <= -1073741825;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayBaseOffsetAsInt(int encoding) {
        return encoding >> 8 & 0xFFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayBaseOffset(int encoding) {
        return Word.unsigned((int)LayoutEncoding.getArrayBaseOffsetAsInt(encoding));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayIndexShift(int encoding) {
        return encoding >> 0 & 0xFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayIndexScale(int encoding) {
        return 1 << LayoutEncoding.getArrayIndexShift(encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayElementOffset(int encoding, int index) {
        return LayoutEncoding.getArrayBaseOffset(encoding).add(Word.unsigned((int)index).shiftLeft(LayoutEncoding.getArrayIndexShift(encoding)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayAllocationSize(int encoding, int length) {
        return LayoutEncoding.getArraySize(encoding, length, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArraySize(int encoding, int length, boolean withOptionalIdHashField) {
        long unalignedSize = LayoutEncoding.getArrayElementOffset(encoding, length).rawValue();
        long totalSize = ConfigurationValues.getObjectLayout().computeArrayTotalSize(unalignedSize, withOptionalIdHashField);
        return Word.unsigned((long)totalSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getIdentityHashOffset(Object obj) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ol.isIdentityHashFieldInObjectHeader()) {
            return ol.getObjectHeaderIdentityHashOffset();
        }
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        int encoding = hub.getLayoutEncoding();
        if (ol.isIdentityHashFieldOptional() && LayoutEncoding.isArrayLike(encoding)) {
            long unalignedSize = LayoutEncoding.getArrayElementOffset(encoding, ArrayLengthNode.arrayLength((Object)obj)).rawValue();
            return (int)ol.getArrayIdentityHashOffset(unalignedSize);
        }
        return hub.getIdentityHashOffset();
    }

    @Uninterruptible(reason="Prevent a GC moving the object or interfering with its identity hash state.", callerMustBe=true)
    public static UnsignedWord getSizeFromObject(Object obj) {
        boolean withOptionalIdHashField = ConfigurationValues.getObjectLayout().isIdentityHashFieldOptional() && LayoutEncoding.hasOptionalIdentityHashField(obj);
        return LayoutEncoding.getSizeFromObjectInline(obj, withOptionalIdHashField);
    }

    public static UnsignedWord getSizeFromObjectAddOptionalIdHashField(Object obj) {
        return LayoutEncoding.getSizeFromObjectInline(obj, true);
    }

    @Uninterruptible(reason="Caller is aware the value can be stale, but required by callee.")
    public static UnsignedWord getMomentarySizeFromObject(Object obj) {
        return LayoutEncoding.getSizeFromObject(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getSizeFromObjectInGC(Object obj) {
        return LayoutEncoding.getSizeFromObjectInlineInGC(obj);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getSizeFromObjectInlineInGC(Object obj) {
        return LayoutEncoding.getSizeFromObjectInlineInGC(obj, false);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getSizeFromObjectInlineInGC(Object obj, boolean addOptionalIdHashField) {
        boolean withOptionalIdHashField = addOptionalIdHashField || ConfigurationValues.getObjectLayout().isIdentityHashFieldOptional() && LayoutEncoding.hasOptionalIdentityHashField(obj);
        return LayoutEncoding.getSizeFromObjectInline(obj, withOptionalIdHashField);
    }

    @AlwaysInline(value="GC performance")
    public static UnsignedWord getSizeFromObjectWithoutOptionalIdHashFieldInGC(Object obj) {
        return LayoutEncoding.getSizeFromObjectInline(obj, false);
    }

    @AlwaysInline(value="Actual inlining decided by callers.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getSizeFromObjectInline(Object obj, boolean withOptionalIdHashField) {
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        int encoding = hub.getLayoutEncoding();
        if (LayoutEncoding.isArrayLike(encoding)) {
            return LayoutEncoding.getArraySize(encoding, ArrayLengthNode.arrayLength((Object)obj), withOptionalIdHashField);
        }
        return LayoutEncoding.getPureInstanceSize(hub, withOptionalIdHashField);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean hasOptionalIdentityHashField(Object obj) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromPointer((Pointer)Word.objectToUntrackedPointer((Object)obj));
        return oh.hasOptionalIdentityHashField(header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getObjectEndInGC(Object obj) {
        return LayoutEncoding.getObjectEndInlineInGC(obj);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getObjectEndInlineInGC(Object obj) {
        UnsignedWord size = LayoutEncoding.getSizeFromObjectInlineInGC(obj, false);
        return Word.objectToUntrackedPointer((Object)obj).add(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getImageHeapObjectEnd(Object obj) {
        UnsignedWord size = LayoutEncoding.getSizeFromObjectInline(obj, true);
        return Word.objectToUntrackedPointer((Object)obj).add(size);
    }

    public static boolean isArray(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isArray(encoding);
    }

    public static boolean isArrayLike(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isArrayLike(encoding);
    }
}

