/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.NeverInlineTrivial;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.TrackDynamicAccessEnabled;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.graal.meta.DynamicHubOffsets;
import com.oracle.svm.core.graal.nodes.SubstrateNewDynamicHubNode;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.ConstantPoolProvider;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.hub.HubType;
import com.oracle.svm.core.hub.Hybrid;
import com.oracle.svm.core.hub.LayeredReflectionMetadataSingleton;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.hub.ReferenceType;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.Target_java_lang_Class_AnnotationData;
import com.oracle.svm.core.hub.Target_java_lang_Class_EnclosingMethodInfo;
import com.oracle.svm.core.hub.Target_java_lang_Class_ReflectionData;
import com.oracle.svm.core.hub.Target_java_lang_PublicMethods_MethodList;
import com.oracle.svm.core.hub.Target_jdk_internal_reflect_ReflectionFactory;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.ProtectionDomainSupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_ConstantPool;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.LazyFinalReference;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.java.FinalFieldBarrierNode;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.CallerSensitiveAdapter;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.ReflectionFactory;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ClassRepository;

@Substitute
@TargetClass(value=Class.class)
@SuppressFBWarnings(value={"Se"}, justification="DynamicHub must implement Serializable for compatibility with java.lang.Class, not because of actual serialization")
public final class DynamicHub
implements AnnotatedElement,
Type,
GenericDeclaration,
Serializable,
TypeDescriptor.OfField<DynamicHub>,
Constable {
    @Substitute
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    static final Object NO_CLASS_LOADER = new Object();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Class<?> hostedJavaClass;
    private String name;
    private final byte hubType;
    private final byte referenceType;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int layoutEncoding;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int typeID;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeCheckStart;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeCheckRange;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeCheckSlot;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short[] closedTypeWorldTypeCheckSlots;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeIDDepth;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short numClassTypes;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short numInterfaceTypes;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int[] openTypeWorldTypeCheckSlots;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private char monitorOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private char identityHashOffset;
    private final short flags;
    private static final int IS_PRIMITIVE_FLAG_BIT = 0;
    private static final int IS_INTERFACE_FLAG_BIT = 1;
    private static final int IS_HIDDEN_FLAG_BIT = 2;
    private static final int IS_RECORD_FLAG_BIT = 3;
    private static final int ASSERTION_STATUS_FLAG_BIT = 4;
    private static final int HAS_DEFAULT_METHODS_FLAG_BIT = 5;
    private static final int DECLARES_DEFAULT_METHODS_FLAG_BIT = 6;
    private static final int IS_SEALED_FLAG_BIT = 7;
    private static final int IS_VM_INTERNAL_FLAG_BIT = 8;
    private static final int IS_LAMBDA_FORM_HIDDEN_BIT = 9;
    private static final int IS_LINKED_BIT = 10;
    private static final int IS_PROXY_CLASS_BIT = 11;
    private static final int ADDITIONAL_FLAGS_INSTANTIATED_BIT = 0;
    @Substitute
    private final DynamicHub componentType;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int referenceMapIndex;
    private final byte layerId;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private WordBase[] vtable;
    private final DynamicHubCompanion companion;
    @Substitute
    @InjectAccessors(value=ClassLoaderAccessors.class)
    private ClassLoader classLoader;
    @Substitute
    @InjectAccessors(value=ReflectionDataAccessors.class)
    private SoftReference<Target_java_lang_Class_ReflectionData<?>> reflectionData;
    @Substitute
    @InjectAccessors(value=ClassRedefinedCountAccessors.class)
    private int classRedefinedCount;
    @Substitute
    @InjectAccessors(value=AnnotationDataAccessors.class)
    private Target_java_lang_Class_AnnotationData annotationData;
    @Substitute
    @InjectAccessors(value=AnnotationTypeAccessors.class)
    private AnnotationType annotationType;
    @Substitute
    private static final long serialVersionUID = 3206093459760846163L;
    @Substitute
    @InjectAccessors(value=CachedConstructorAccessors.class)
    private Constructor<?> cachedConstructor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicHub(Class<?> hostedJavaClass, String name, byte hubType, ReferenceType referenceType, DynamicHub superType, DynamicHub componentHub, String sourceFileName, int modifiers, short flags, ClassLoader classLoader, Class<?> nestHost, String simpleBinaryName, Object declaringClass, String signature, int layerId) {
        this.hostedJavaClass = hostedJavaClass;
        this.name = name;
        this.hubType = hubType;
        this.referenceType = referenceType.getValue();
        this.componentType = componentHub;
        assert (layerId < 127);
        this.layerId = NumUtil.safeToByte((long)layerId);
        this.flags = flags;
        Object loader = PredefinedClassesSupport.isPredefined(hostedJavaClass) ? NO_CLASS_LOADER : classLoader;
        this.companion = DynamicHubCompanion.createHosted(hostedJavaClass.getModule(), superType, sourceFileName, modifiers, loader, nestHost, simpleBinaryName, declaringClass, signature);
    }

    @NeverInline(value="Fields of DynamicHub are immutable. Immutable reads could float above ANY_LOCATION writes.")
    public static DynamicHub allocate(String name, DynamicHub superHub, Object interfacesEncoding, DynamicHub componentHub, String sourceFileName, int modifiers, short flags, ClassLoader classLoader, Class<?> nestHost, String simpleBinaryName, Object declaringClass, String signature) {
        VMError.guarantee(RuntimeClassLoading.isSupported());
        ReferenceType referenceType = ReferenceType.computeReferenceType(DynamicHub.toClass(superHub));
        byte hubType = 0;
        if (referenceType != ReferenceType.None) {
            hubType = 1;
        }
        Module module = null;
        ResolvedJavaType interpreterType = null;
        DynamicHubCompanion companion = DynamicHubCompanion.createAtRuntime(module, superHub, sourceFileName, modifiers, classLoader, nestHost, simpleBinaryName, declaringClass, signature, interpreterType);
        companion.canUnsafeAllocate = true;
        int vTableEntries = 256;
        companion.classInitializationInfo = new ClassInitializationInfo(false);
        int layoutEncoding = 64;
        char monitorOffset = '\u0000';
        char identityHashOffset = '\u0000';
        int typeID = 0;
        short typeIDDepth = 0;
        short numClassTypes = 2;
        short numInterfacesTypes = 0;
        int[] openTypeWorldTypeCheckSlots = new int[numClassTypes + numInterfacesTypes * 2];
        companion.interfacesEncoding = interfacesEncoding;
        companion.enumConstantsReference = null;
        int referenceMapIndex = DynamicHub.fromClass(Object.class).referenceMapIndex;
        companion.hubMetadata = null;
        companion.reflectionMetadata = null;
        DynamicHub hub = SubstrateNewDynamicHubNode.allocate(DynamicHub.class, vTableEntries);
        DynamicHubOffsets dynamicHubOffsets = DynamicHubOffsets.singleton();
        DynamicHubOffsets.writeObject(hub, dynamicHubOffsets.getNameOffset(), name);
        DynamicHubOffsets.writeByte(hub, dynamicHubOffsets.getHubTypeOffset(), hubType);
        DynamicHubOffsets.writeByte(hub, dynamicHubOffsets.getReferenceTypeOffset(), referenceType.getValue());
        DynamicHubOffsets.writeInt(hub, dynamicHubOffsets.getLayoutEncodingOffset(), layoutEncoding);
        DynamicHubOffsets.writeInt(hub, dynamicHubOffsets.getTypeIDOffset(), typeID);
        DynamicHubOffsets.writeShort(hub, dynamicHubOffsets.getTypeIDDepthOffset(), typeIDDepth);
        DynamicHubOffsets.writeShort(hub, dynamicHubOffsets.getNumClassTypesOffset(), numClassTypes);
        DynamicHubOffsets.writeShort(hub, dynamicHubOffsets.getNumInterfaceTypesOffset(), numInterfacesTypes);
        DynamicHubOffsets.writeObject(hub, dynamicHubOffsets.getOpenTypeWorldTypeCheckSlotsOffset(), openTypeWorldTypeCheckSlots);
        DynamicHubOffsets.writeChar(hub, dynamicHubOffsets.getMonitorOffsetOffset(), monitorOffset);
        DynamicHubOffsets.writeChar(hub, dynamicHubOffsets.getIdentityHashOffsetOffset(), identityHashOffset);
        DynamicHubOffsets.writeShort(hub, dynamicHubOffsets.getFlagsOffset(), flags);
        DynamicHubOffsets.writeObject(hub, dynamicHubOffsets.getComponentTypeOffset(), componentHub);
        DynamicHubOffsets.writeInt(hub, dynamicHubOffsets.getReferenceMapIndexOffset(), referenceMapIndex);
        DynamicHubOffsets.writeByte(hub, dynamicHubOffsets.getLayerIdOffset(), NumUtil.safeToByte((long)127L));
        DynamicHubOffsets.writeObject(hub, dynamicHubOffsets.getCompanionOffset(), companion);
        FinalFieldBarrierNode.finalFieldBarrier((Object)hub);
        return hub;
    }

    public static short makeFlags(boolean isPrimitive, boolean isInterface, boolean isHidden, boolean isRecord, boolean assertionStatus, boolean hasDefaultMethods, boolean declaresDefaultMethods, boolean isSealed, boolean isVMInternal, boolean isLambdaFormHidden, boolean isLinked, boolean isProxyClass) {
        return NumUtil.safeToUShort((int)(DynamicHub.makeFlag(0, isPrimitive) | DynamicHub.makeFlag(1, isInterface) | DynamicHub.makeFlag(2, isHidden) | DynamicHub.makeFlag(3, isRecord) | DynamicHub.makeFlag(4, assertionStatus) | DynamicHub.makeFlag(5, hasDefaultMethods) | DynamicHub.makeFlag(6, declaresDefaultMethods) | DynamicHub.makeFlag(7, isSealed) | DynamicHub.makeFlag(8, isVMInternal) | DynamicHub.makeFlag(9, isLambdaFormHidden) | DynamicHub.makeFlag(10, isLinked) | DynamicHub.makeFlag(11, isProxyClass)));
    }

    private static int makeFlag(int flagBit, boolean value) {
        int flagMask = 1 << flagBit;
        return value ? flagMask : 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isFlagSet(byte flags, int flagBit) {
        int flagMask = 1 << flagBit;
        return (flags & flagMask) != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isFlagSet(short flags, int flagBit) {
        int flagMask = 1 << flagBit;
        return (flags & flagMask) != 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setClassInitializationInfo(ClassInitializationInfo classInitializationInfo) {
        assert (this.companion.classInitializationInfo == null);
        assert (classInitializationInfo != null);
        this.companion.classInitializationInfo = classInitializationInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setSharedData(int layoutEncoding, int monitorOffset, int identityHashOffset, long referenceMapIndex, boolean isInstantiated) {
        VMError.guarantee(monitorOffset == -1 || monitorOffset == (char)monitorOffset, "Class %s has an invalid monitor field offset. Most likely, its objects are larger than supported.", this.name);
        VMError.guarantee(identityHashOffset == -1 || identityHashOffset == (char)identityHashOffset, "Class %s has an invalid identity hash code field offset. Most likely, its objects are larger than supported.", this.name);
        this.layoutEncoding = layoutEncoding;
        this.monitorOffset = monitorOffset == -1 ? (char)'\u0000' : (char)monitorOffset;
        char c = this.identityHashOffset = identityHashOffset == -1 ? (char)'\u0000' : (char)identityHashOffset;
        if ((long)((int)referenceMapIndex) != referenceMapIndex) {
            throw VMError.shouldNotReachHere("Reference map index not within integer range, need to switch field from int to long");
        }
        this.referenceMapIndex = (int)referenceMapIndex;
        assert (this.companion.additionalFlags == 0);
        this.companion.additionalFlags = NumUtil.safeToUByte((int)DynamicHub.makeFlag(0, isInstantiated));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setClosedTypeWorldData(WordBase[] vtable, int typeID, short typeCheckStart, short typeCheckRange, short typeCheckSlot, short[] typeCheckSlots) {
        assert (this.vtable == null) : "Initialization must be called only once";
        this.typeID = typeID;
        this.typeCheckStart = typeCheckStart;
        this.typeCheckRange = typeCheckRange;
        this.typeCheckSlot = typeCheckSlot;
        this.closedTypeWorldTypeCheckSlots = typeCheckSlots;
        this.vtable = vtable;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setOpenTypeWorldData(WordBase[] vtable, int typeID, int typeCheckDepth, int numClassTypes, int numInterfaceTypes, int[] typeCheckSlots) {
        assert (this.vtable == null) : "Initialization must be called only once";
        this.typeID = typeID;
        this.typeIDDepth = NumUtil.safeToShortAE((long)typeCheckDepth);
        this.numClassTypes = NumUtil.safeToShortAE((long)numClassTypes);
        this.numInterfaceTypes = NumUtil.safeToShortAE((long)numInterfaceTypes);
        this.openTypeWorldTypeCheckSlots = typeCheckSlots;
        this.vtable = vtable;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setArrayHub(DynamicHub arrayHub) {
        assert ((this.companion.arrayHub == null || this.companion.arrayHub == arrayHub) && arrayHub != null);
        assert (arrayHub.getComponentHub() == this);
        this.companion.arrayHub = arrayHub;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setInterfacesEncoding(Object interfacesEncoding) {
        assert (this.companion.interfacesEncoding == null);
        this.companion.interfacesEncoding = interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getInterfacesEncoding() {
        return this.companion.interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean shouldInitEnumConstants() {
        return this.companion.enumConstantsReference == null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initEnumConstants(Enum<?>[] enumConstants) {
        assert (this.companion.enumConstantsReference == null);
        this.companion.enumConstantsReference = enumConstants;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initEnumConstantsAtRuntime(Class<?> enumClass) {
        assert (this.companion.enumConstantsReference == null);
        try {
            Method values = ReflectionUtil.lookupMethod(enumClass, (String)"values", (Class[])new Class[0]);
            this.companion.enumConstantsReference = new LazyFinalReference<Object>(() -> DynamicHub.initEnumConstantsAtRuntime(values));
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            this.companion.enumConstantsReference = null;
        }
        catch (NoClassDefFoundError e) {
            String message = e.getMessage();
            this.companion.enumConstantsReference = new LazyFinalReference<Object>(() -> DynamicHub.throwNoClassDefFoundErrorAtRuntime(message));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getSignature() {
        return this.companion.signature;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setHubMetadata(int enclosingMethodInfoIndex, int annotationsIndex, int typeAnnotationsIndex, int classesEncodingIndex, int permittedSubclassesEncodingIndex, int nestMembersEncodingIndex, int signersEncodingIndex) {
        assert (this.companion.hubMetadata == null);
        this.companion.hubMetadata = new DynamicHubMetadata(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesEncodingIndex, nestMembersEncodingIndex, signersEncodingIndex);
    }

    private DynamicHubMetadata hubMetadata() {
        return this.companion.hubMetadata;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setReflectionMetadata(int fieldsEncodingIndex, int methodsEncodingIndex, int constructorsEncodingIndex, int recordComponentsEncodingIndex, int classFlags) {
        assert (this.companion.reflectionMetadata == null);
        ReflectionMetadata reflectionMetadata = new ReflectionMetadata(fieldsEncodingIndex, methodsEncodingIndex, constructorsEncodingIndex, recordComponentsEncodingIndex, classFlags);
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            LayeredReflectionMetadataSingleton.currentLayer().setReflectionMetadata(this, reflectionMetadata);
        } else {
            this.companion.reflectionMetadata = reflectionMetadata;
        }
    }

    private ReflectionMetadata reflectionMetadata() {
        assert (!ImageLayerBuildingSupport.buildingImageLayer()) : "The non-layered reflection metadata should never be accessed in a layered context";
        return this.companion.reflectionMetadata;
    }

    private void checkClassFlag(int mask, String methodName) {
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceReflectionType(DynamicHub.toClass(this));
        }
        if (!(!MissingRegistrationUtils.throwMissingRegistrationErrors() || this.isClassFlagSet(mask) && this.getConditions().satisfied())) {
            MissingReflectionRegistrationUtils.reportClassQuery(DynamicHub.toClass(this), methodName);
        }
    }

    private boolean isClassFlagSet(int mask) {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            for (LayeredReflectionMetadataSingleton reflectionMetadata : LayeredReflectionMetadataSingleton.singletons()) {
                if (!DynamicHub.isClassFlagSet(mask, reflectionMetadata.getReflectionMetadata(this))) continue;
                return true;
            }
            return false;
        }
        return DynamicHub.isClassFlagSet(mask, this.reflectionMetadata());
    }

    private static boolean isClassFlagSet(int mask, ReflectionMetadata reflectionMetadata) {
        return reflectionMetadata != null && (reflectionMetadata.classFlags & mask) != 0;
    }

    private static Object initEnumConstantsAtRuntime(Method values) {
        try {
            return values.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static Object throwNoClassDefFoundErrorAtRuntime(String message) {
        throw new NoClassDefFoundError(message);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMetaType(SharedType metaType) {
        assert (this.companion.metaType == null);
        this.companion.metaType = metaType;
    }

    public boolean hasDefaultMethods() {
        return DynamicHub.isFlagSet(this.flags, 5);
    }

    public boolean declaresDefaultMethods() {
        return DynamicHub.isFlagSet(this.flags, 6);
    }

    public ClassInitializationInfo getClassInitializationInfo() {
        return this.companion.classInitializationInfo;
    }

    public boolean isInitialized() {
        return this.companion.classInitializationInfo.isInitialized();
    }

    public void ensureInitialized() {
        EnsureClassInitializedNode.ensureClassInitialized(DynamicHub.toClass(this));
    }

    public SharedType getMetaType() {
        return this.companion.metaType;
    }

    public ResolvedJavaType getInterpreterType() {
        return this.companion.interpreterType;
    }

    public void setInterpreterType(ResolvedJavaType interpreterType) {
        this.companion.interpreterType = interpreterType;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceFileName() {
        return this.companion.sourceFileName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getLayoutEncoding() {
        return this.layoutEncoding;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getTypeID() {
        return this.typeID;
    }

    public short getTypeCheckSlot() {
        return this.typeCheckSlot;
    }

    public short getTypeCheckStart() {
        return this.typeCheckStart;
    }

    public short getTypeCheckRange() {
        return this.typeCheckRange;
    }

    public int getTypeIDDepth() {
        return this.typeIDDepth;
    }

    public int getNumClassTypes() {
        return this.numClassTypes;
    }

    public int getNumInterfaceTypes() {
        return this.numInterfaceTypes;
    }

    public int[] getOpenTypeWorldTypeCheckSlots() {
        return this.openTypeWorldTypeCheckSlots;
    }

    public int getMonitorOffset() {
        return this.monitorOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getIdentityHashOffset() {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ol.isIdentityHashFieldInObjectHeader()) {
            return ol.getObjectHeaderIdentityHashOffset();
        }
        char result = this.identityHashOffset;
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((result > '\u0000' ? 1 : 0) != 0, (String)"must have an identity hash field");
        } else assert (result > '\u0000') : "must have an identity hash field";
        return result;
    }

    public DynamicHub getSuperHub() {
        return this.companion.superHub;
    }

    public DynamicHub getComponentHub() {
        return this.componentType;
    }

    public DynamicHub getArrayHub() {
        return this.companion.arrayHub;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getReferenceMapIndex() {
        return this.referenceMapIndex;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getLayerId() {
        return this.layerId;
    }

    public boolean isInstantiated() {
        return DynamicHub.isFlagSet(this.companion.additionalFlags, 0);
    }

    public boolean canUnsafeInstantiateAsInstanceFastPath() {
        return this.canUnsafeAllocate();
    }

    public boolean canUnsafeInstantiateAsInstanceSlowPath() {
        if (ClassForNameSupport.canUnsafeInstantiateAsInstance(this)) {
            this.setCanUnsafeAllocate();
            return true;
        }
        return false;
    }

    public boolean canUnsafeAllocate() {
        return this.companion.canUnsafeAllocate;
    }

    public void setCanUnsafeAllocate() {
        this.companion.canUnsafeAllocate = true;
    }

    public boolean isProxyClass() {
        return DynamicHub.isFlagSet(this.flags, 11);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DynamicHub fromClass(Class<?> clazz) {
        return SubstrateUtil.cast(clazz, DynamicHub.class);
    }

    public DynamicHubCompanion getCompanion() {
        return this.companion;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Class<?> toClass(DynamicHub hub) {
        return SubstrateUtil.cast(hub, Class.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Class<?> getHostedJavaClass() {
        return this.hostedJavaClass;
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getHubType() {
        return this.hubType;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInstanceClass() {
        return HubType.isInstance(this.hubType);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isPodInstanceClass() {
        return HubType.isPodInstance(this.hubType);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isReferenceInstanceClass() {
        return HubType.isReferenceInstance(this.hubType);
    }

    @Override
    @Substitute
    public boolean isArray() {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    public boolean hubIsArray() {
        return HubType.isArray(this.hubType);
    }

    @Substitute
    public boolean isInterface() {
        return DynamicHub.isFlagSet(this.flags, 1);
    }

    @Override
    @Substitute
    public boolean isPrimitive() {
        return DynamicHub.isFlagSet(this.flags, 0);
    }

    @Substitute
    public int getModifiers() {
        return this.companion.modifiers;
    }

    public int getClassAccessFlags() {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            int classAccessFlags = 0;
            for (LayeredReflectionMetadataSingleton reflectionMetadata : LayeredReflectionMetadataSingleton.singletons()) {
                classAccessFlags |= this.getClassAccessFlags(reflectionMetadata.getReflectionMetadata(this));
            }
            return classAccessFlags;
        }
        return this.getClassAccessFlags(this.reflectionMetadata());
    }

    private int getClassAccessFlags(ReflectionMetadata reflectionMetadata) {
        return reflectionMetadata != null ? reflectionMetadata.classFlags & 0x1FFF : this.companion.modifiers;
    }

    @Substitute
    private DynamicHub getComponentType() {
        return this.componentType;
    }

    @Substitute
    private DynamicHub getSuperclass() {
        return this.companion.superHub;
    }

    @Substitute
    private boolean isInstance(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private Object cast(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private boolean isAssignableFrom(Class<?> cls) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private boolean isAnnotation() {
        return this.isInterface() && this.getInterfaces().length == 1 && DynamicHub.toClass(this.getInterfaces()[0]) == Annotation.class;
    }

    @Substitute
    private boolean isEnum() {
        return DynamicHub.toClass(this.getSuperclass()) == Enum.class;
    }

    @KeepOriginal
    private native Object[] getEnumConstants();

    @Substitute
    public Object[] getEnumConstantsShared() {
        Object enumConstantsReference = this.companion.enumConstantsReference;
        if (enumConstantsReference instanceof LazyFinalReference) {
            return (Object[])((LazyFinalReference)enumConstantsReference).get();
        }
        return (Object[])enumConstantsReference;
    }

    @KeepOriginal
    public native URL getResource(String var1);

    @Substitute
    public InputStream getResourceAsStream(String resourceName) {
        String resolvedName = this.resolveName(resourceName);
        return Resources.createInputStream(this.companion.module, resolvedName);
    }

    @KeepOriginal
    private native String resolveName(String var1);

    @KeepOriginal
    private native boolean isOpenToCaller(String var1, Class<?> var2);

    @Substitute
    public ClassLoader getClassLoader() {
        Object loader = this.companion.classLoader;
        VMError.guarantee(loader != NO_CLASS_LOADER);
        return (ClassLoader)loader;
    }

    @KeepOriginal
    private native ClassLoader getClassLoader0();

    public boolean isLoaded() {
        return this.companion.classLoader != NO_CLASS_LOADER;
    }

    void setClassLoaderAtRuntime(ClassLoader loader) {
        VMError.guarantee(this.companion.classLoader == NO_CLASS_LOADER && loader != NO_CLASS_LOADER);
        this.companion.classLoader = loader;
    }

    @KeepOriginal
    private native String getSimpleName();

    @KeepOriginal
    private native String getSimpleName0();

    @KeepOriginal
    private native String getCanonicalName();

    @KeepOriginal
    private native String getCanonicalName0();

    @Override
    @KeepOriginal
    public native String getTypeName();

    @KeepOriginal
    private native String getSimpleBinaryName();

    @KeepOriginal
    private native <U> Class<? extends U> asSubclass(Class<U> var1);

    @KeepOriginal
    private native boolean isAnonymousClass();

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isHidden() {
        return DynamicHub.isFlagSet(this.flags, 2);
    }

    @Substitute
    public boolean isRecord() {
        return DynamicHub.isFlagSet(this.flags, 3);
    }

    @Substitute
    public boolean isSealed() {
        return DynamicHub.isFlagSet(this.flags, 7);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isVMInternal() {
        return DynamicHub.isFlagSet(this.flags, 8);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isLambdaFormHidden() {
        return DynamicHub.isFlagSet(this.flags, 9);
    }

    public boolean isLinked() {
        return DynamicHub.isFlagSet(this.flags, 10);
    }

    public boolean isRegisteredForSerialization() {
        return SerializationSupport.isRegisteredForSerialization(this);
    }

    @KeepOriginal
    private native boolean isLocalClass();

    @KeepOriginal
    private native boolean isMemberClass();

    @KeepOriginal
    private native boolean isLocalOrAnonymousClass();

    @KeepOriginal
    private native Class<?> getEnclosingClass();

    @KeepOriginal
    private native Class<?> getDeclaringClass();

    @Substitute
    private Class<?> getDeclaringClass0() {
        Object declaringClass = this.companion.declaringClass;
        if (declaringClass == null) {
            return null;
        }
        if (declaringClass instanceof Class) {
            PredefinedClassesSupport.throwIfUnresolvable((Class)declaringClass, this.getClassLoader0());
            return (Class)declaringClass;
        }
        if (declaringClass instanceof LinkageError) {
            throw (LinkageError)declaringClass;
        }
        throw VMError.shouldNotReachHereUnexpectedInput(declaringClass);
    }

    @KeepOriginal
    public native DynamicHub[] getInterfaces();

    @KeepOriginal
    private native DynamicHub[] getInterfaces(boolean var1);

    @KeepOriginal
    public native Object newInstance() throws Throwable;

    @Override
    @KeepOriginal
    public native <T extends Annotation> T getAnnotation(Class<T> var1);

    @Override
    @Substitute
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    @KeepOriginal
    public native Annotation[] getAnnotations();

    @Override
    @Substitute
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        DynamicHub superClass;
        Annotation[] result = this.getDeclaredAnnotationsByType(annotationClass);
        if (result.length == 0 && AnnotationAccess.isAnnotationPresent(annotationClass, Inherited.class) && (superClass = this.getSuperclass()) != null) {
            result = superClass.getAnnotationsByType(annotationClass);
        }
        return result;
    }

    @Override
    @KeepOriginal
    public native Annotation[] getDeclaredAnnotations();

    @KeepOriginal
    public native <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> var1);

    @Override
    @KeepOriginal
    public native <T extends Annotation> T getDeclaredAnnotation(Class<T> var1);

    @Substitute
    private Field[] getFields() {
        this.checkClassFlag(65536, "getFields");
        return DynamicHub.copyFields(this.privateGetPublicFields());
    }

    private RuntimeConditionSet getConditions() {
        return ClassForNameSupport.getConditionFor(DynamicHub.toClass(this));
    }

    @Substitute
    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        this.checkClassFlag(262144, "getMethods");
        return DynamicHub.copyMethods(this.privateGetPublicMethods());
    }

    @Substitute
    private Constructor<?>[] getConstructors() {
        this.checkClassFlag(0x100000, "getConstructors");
        return DynamicHub.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    @Substitute
    public Field getField(String fieldName) throws NoSuchFieldException, SecurityException {
        Objects.requireNonNull(fieldName);
        Field field = this.getField0(fieldName);
        this.checkField(fieldName, field, true);
        return DynamicHub.getReflectionFactory().copyField(field);
    }

    private void checkField(String fieldName, Field field, boolean publicOnly) throws NoSuchFieldException {
        boolean throwMissingErrors = MissingRegistrationUtils.throwMissingRegistrationErrors();
        Class<?> clazz = DynamicHub.toClass(this);
        if (MetadataTracer.enabled()) {
            this.traceFieldLookup(fieldName, field, publicOnly);
        }
        if (field == null) {
            if (throwMissingErrors && !this.allElementsRegistered(publicOnly, 131072, 65536)) {
                MissingReflectionRegistrationUtils.reportFieldQuery(clazz, fieldName);
            }
            throw new NoSuchFieldException(fieldName);
        }
        RuntimeMetadataDecoder decoder = (RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class);
        int fieldModifiers = field.getModifiers();
        boolean negative = decoder.isNegative(fieldModifiers);
        boolean hiding = decoder.isHiding(fieldModifiers);
        if (throwMissingErrors && hiding) {
            MissingReflectionRegistrationUtils.reportFieldQuery(clazz, fieldName);
        }
        if (negative || hiding) {
            throw new NoSuchFieldException(fieldName);
        }
    }

    private void traceFieldLookup(String fieldName, Field field, boolean publicOnly) {
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration;
        ConfigurationMemberInfo.ConfigurationMemberDeclaration configurationMemberDeclaration = declaration = publicOnly ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT : ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED;
        if (field != null) {
            MetadataTracer.singleton().traceReflectionType(field.getDeclaringClass());
            MetadataTracer.singleton().traceReflectionType(DynamicHub.toClass(this));
        } else {
            MetadataTracer.singleton().traceFieldAccess(DynamicHub.toClass(this), fieldName, declaration);
        }
    }

    @Substitute
    private Method getMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Objects.requireNonNull(methodName);
        Method method = this.getMethod0(methodName, parameterTypes);
        this.checkMethod(methodName, parameterTypes, method, true);
        return DynamicHub.getReflectionFactory().copyMethod(method);
    }

    private void checkMethod(String methodName, Class<?>[] parameterTypes, Method method, boolean publicOnly) throws NoSuchMethodException {
        if (!this.checkMethodExists(methodName, parameterTypes, method, publicOnly)) {
            throw new NoSuchMethodException(this.methodToString(methodName, parameterTypes));
        }
    }

    private boolean checkMethodExists(String methodName, Class<?>[] parameterTypes, Method method, boolean publicOnly) {
        if ("<init>".equals(methodName)) {
            return false;
        }
        return this.checkExecutableExists(methodName, parameterTypes, method, publicOnly);
    }

    private void checkConstructor(Class<?>[] parameterTypes, Constructor<?> constructor, boolean publicOnly) throws NoSuchMethodException {
        if (!this.checkExecutableExists("<init>", parameterTypes, constructor, publicOnly)) {
            throw new NoSuchMethodException(this.methodToString("<init>", parameterTypes));
        }
    }

    private boolean checkExecutableExists(String methodName, Class<?>[] parameterTypes, Executable method, boolean publicOnly) {
        boolean throwMissingErrors = MissingRegistrationUtils.throwMissingRegistrationErrors();
        Class<?> clazz = DynamicHub.toClass(this);
        if (MetadataTracer.enabled()) {
            this.traceMethodLookup(methodName, parameterTypes, method, publicOnly);
        }
        if (method == null) {
            int allPublicFlag;
            boolean isConstructor = methodName.equals("<init>");
            int allDeclaredFlag = isConstructor ? 0x200000 : 524288;
            int n = allPublicFlag = isConstructor ? 0x100000 : 262144;
            if (!(!throwMissingErrors || this.allElementsRegistered(publicOnly, allDeclaredFlag, allPublicFlag) || isConstructor && this.isInterface())) {
                MissingReflectionRegistrationUtils.reportMethodQuery(clazz, methodName, parameterTypes);
            }
            return false;
        }
        RuntimeMetadataDecoder decoder = (RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class);
        int methodModifiers = method.getModifiers();
        boolean negative = decoder.isNegative(methodModifiers);
        boolean hiding = decoder.isHiding(methodModifiers);
        if (throwMissingErrors && hiding) {
            MissingReflectionRegistrationUtils.reportMethodQuery(clazz, methodName, parameterTypes);
        }
        return !negative && !hiding;
    }

    private void traceMethodLookup(String methodName, Class<?>[] parameterTypes, Executable method, boolean publicOnly) {
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration;
        ConfigurationMemberInfo.ConfigurationMemberDeclaration configurationMemberDeclaration = declaration = publicOnly ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT : ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED;
        if (method != null) {
            MetadataTracer.singleton().traceReflectionType(method.getDeclaringClass());
            MetadataTracer.singleton().traceReflectionType(DynamicHub.toClass(this));
        } else {
            MetadataTracer.singleton().traceMethodAccess(DynamicHub.toClass(this), methodName, SignatureUtil.toInternalSignature((Class[])parameterTypes), declaration);
        }
    }

    private boolean allElementsRegistered(boolean publicOnly, int allDeclaredElementsFlag, int allPublicElementsFlag) {
        return this.isClassFlagSet(allDeclaredElementsFlag) || publicOnly && this.isClassFlagSet(allPublicElementsFlag);
    }

    @KeepOriginal
    private native Constructor<?> getConstructor(Class<?> ... var1);

    @Substitute
    public Class<?>[] getDeclaredClasses() throws SecurityException {
        this.checkClassFlag(0x800000, "getDeclaredClasses");
        return this.getDeclaredClasses0();
    }

    @Substitute
    public Class<?>[] getClasses() {
        this.checkClassFlag(0x400000, "getClasses");
        return AccessController.doPrivileged(() -> {
            ArrayList list = new ArrayList();
            for (DynamicHub currentClass = this; currentClass != null; currentClass = currentClass.getSuperHub()) {
                for (Class<?> m : currentClass.getDeclaredClasses0()) {
                    if (!Modifier.isPublic(m.getModifiers())) continue;
                    list.add(m);
                }
            }
            return list.toArray(new Class[0]);
        });
    }

    @Substitute
    private Field[] getDeclaredFields() {
        this.checkClassFlag(131072, "getDeclaredFields");
        return DynamicHub.copyFields(this.privateGetDeclaredFields(false));
    }

    @Substitute
    @CallerSensitive
    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkClassFlag(524288, "getDeclaredMethods");
        return DynamicHub.copyMethods(this.privateGetDeclaredMethods(false));
    }

    @Substitute
    private Constructor<?>[] getDeclaredConstructors() {
        this.checkClassFlag(0x200000, "getDeclaredConstructors");
        return DynamicHub.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    @Substitute
    public Field getDeclaredField(String fieldName) throws NoSuchFieldException, SecurityException {
        Objects.requireNonNull(fieldName);
        Field field = DynamicHub.searchFields(this.privateGetDeclaredFields(false), fieldName);
        this.checkField(fieldName, field, false);
        return DynamicHub.getReflectionFactory().copyField(field);
    }

    @Substitute
    @CallerSensitive
    public Method getDeclaredMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Objects.requireNonNull(methodName);
        Method method = DynamicHub.searchMethods(this.privateGetDeclaredMethods(false), methodName, parameterTypes);
        this.checkMethod(methodName, parameterTypes, method, false);
        return DynamicHub.getReflectionFactory().copyMethod(method);
    }

    @KeepOriginal
    private native Constructor<?> getDeclaredConstructor(Class<?> ... var1);

    @KeepOriginal
    private native Constructor<?>[] privateGetDeclaredConstructors(boolean var1);

    @KeepOriginal
    private native Field[] privateGetDeclaredFields(boolean var1);

    @KeepOriginal
    private native Method[] privateGetDeclaredMethods(boolean var1);

    @KeepOriginal
    private native Field[] privateGetPublicFields();

    @KeepOriginal
    native Method[] privateGetPublicMethods();

    @KeepOriginal
    private native RecordComponent[] getRecordComponents();

    @Substitute
    private RecordComponent[] getRecordComponents0() {
        this.checkClassFlag(0x1000000, "getRecordComponents");
        int layerNum = 0;
        int recordComponentsEncodingIndex = -1;
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            for (LayeredReflectionMetadataSingleton singleton : LayeredReflectionMetadataSingleton.singletons()) {
                ++layerNum;
                ReflectionMetadata reflectionMetadata = singleton.getReflectionMetadata(this);
                if (reflectionMetadata == null || reflectionMetadata.recordComponentsEncodingIndex == -1) continue;
                recordComponentsEncodingIndex = reflectionMetadata.recordComponentsEncodingIndex;
                break;
            }
        } else {
            ReflectionMetadata reflectionMetadata = this.reflectionMetadata();
            if (reflectionMetadata != null) {
                recordComponentsEncodingIndex = reflectionMetadata.recordComponentsEncodingIndex;
            }
        }
        if (recordComponentsEncodingIndex == -1) {
            throw VMError.unsupportedFeature("Record components not available for record class " + this.getTypeName() + ". All record component accessor methods of this record class must be included in the reflection configuration at image build time, then this method can be called.");
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseRecordComponents(this, recordComponentsEncodingIndex, layerNum);
    }

    @KeepOriginal
    private native Class<?>[] getPermittedSubclasses();

    @Substitute
    private static ReflectionFactory getReflectionFactory() {
        return Target_jdk_internal_reflect_ReflectionFactory.getReflectionFactory();
    }

    @KeepOriginal
    private static native Field searchFields(Field[] var0, String var1);

    @KeepOriginal
    private static native Method searchMethods(Method[] var0, String var1, Class<?>[] var2);

    @Substitute
    private Constructor<?> getConstructor0(Class<?>[] parameterTypes, int which) throws NoSuchMethodException {
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        Constructor<?>[] constructors = this.privateGetDeclaredConstructors(which == 0);
        Constructor<?> candidate = null;
        for (Constructor<?> constructor : constructors) {
            if (!DynamicHub.arrayContentsEq(parameterTypes, fact.getExecutableSharedParameterTypes(constructor))) continue;
            candidate = constructor;
        }
        this.checkConstructor(parameterTypes, candidate, which == 0);
        return candidate;
    }

    @KeepOriginal
    private static native boolean arrayContentsEq(Object[] var0, Object[] var1);

    @Substitute
    private static Field[] copyFields(Field[] original) {
        Field[] arg = DynamicHub.filterFields(original);
        Field[] out = new Field[arg.length];
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyField(arg[i]);
        }
        return out;
    }

    @Substitute
    private static Method[] copyMethods(Method[] original) {
        Method[] arg = DynamicHub.filterMethods(original);
        Method[] out = new Method[arg.length];
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyMethod(arg[i]);
        }
        return out;
    }

    @Substitute
    private static Constructor<?>[] copyConstructors(Constructor<?>[] original) {
        Constructor<?>[] arg = DynamicHub.filterConstructors(original);
        Constructor[] out = new Constructor[arg.length];
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyConstructor(arg[i]);
        }
        return out;
    }

    @Override
    @KeepOriginal
    public native TypeVariable<?>[] getTypeParameters();

    @KeepOriginal
    public native Type[] getGenericInterfaces();

    @KeepOriginal
    public native Type getGenericSuperclass();

    @KeepOriginal
    public native AnnotatedType getAnnotatedSuperclass();

    @KeepOriginal
    public native AnnotatedType[] getAnnotatedInterfaces();

    @KeepOriginal
    private native Method getEnclosingMethod();

    @KeepOriginal
    private native Constructor<?> getEnclosingConstructor();

    @Substitute
    @NeverInlineTrivial(reason="Used in dynamic access call usage analysis: DynamicAccessDetectionPhase", onlyWith={TrackDynamicAccessEnabled.class})
    @CallerSensitive
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static Class<?> forName(String className) throws Throwable {
        return DynamicHub.forName(className, Reflection.getCallerClass());
    }

    @KeepOriginal
    @CallerSensitive
    @TargetElement(name="forName", onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    private static native Class<?> forNameOriginal(String var0) throws ClassNotFoundException;

    @Substitute
    @NeverInlineTrivial(reason="Used in dynamic access call usage analysis: DynamicAccessDetectionPhase", onlyWith={TrackDynamicAccessEnabled.class})
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    @CallerSensitiveAdapter
    private static Class<?> forName(String className, Class<?> caller) throws Throwable {
        return DynamicHub.forName(className, true, caller == null ? ClassLoader.getSystemClassLoader() : caller.getClassLoader(), caller);
    }

    @KeepOriginal
    @TargetElement(name="forName", onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    @CallerSensitiveAdapter
    private static native Class<?> forNameOriginal(String var0, Class<?> var1) throws ClassNotFoundException;

    @Substitute
    @NeverInlineTrivial(reason="Used in dynamic access call usage analysis: DynamicAccessDetectionPhase", onlyWith={TrackDynamicAccessEnabled.class})
    @CallerSensitive
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static Class<?> forName(Module module, String className) throws Throwable {
        return DynamicHub.forName(module, className, Reflection.getCallerClass());
    }

    @KeepOriginal
    @CallerSensitive
    @TargetElement(name="forName", onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    private static native Class<?> forNameOriginal(Module var0, String var1);

    @CallerSensitiveAdapter
    private static Class<?> forName(Module module, String className, Class<?> caller) throws Throwable {
        try {
            return DynamicHub.forName(className, false, caller.getClassLoader(), caller);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Substitute
    @NeverInlineTrivial(reason="Used in dynamic access call usage analysis: DynamicAccessDetectionPhase", onlyWith={TrackDynamicAccessEnabled.class})
    @CallerSensitive
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws Throwable {
        return DynamicHub.forName(name, initialize, loader, Reflection.getCallerClass());
    }

    @KeepOriginal
    @CallerSensitive
    @TargetElement(name="forName", onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    private static native Class<?> forNameOriginal(String var0, boolean var1, ClassLoader var2);

    @CallerSensitiveAdapter
    private static Class<?> forName(String name, boolean initialize, ClassLoader loader, Class<?> caller) throws Throwable {
        Class<?> result;
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            result = ClassForNameSupport.forName(name, loader);
        }
        catch (ClassNotFoundException e) {
            if (loader != null && PredefinedClassesSupport.hasBytecodeClasses()) {
                result = loader.loadClass(name);
            }
            throw e;
        }
        if (initialize) {
            DynamicHub.fromClass(result).ensureInitialized();
        }
        return result;
    }

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/Class.c#L97-L144"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L803-L821"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L3303-L3312")})
    @CallerSensitiveAdapter
    private static Class<?> forName0(String name, boolean initialize, ClassLoader loader, Class<?> caller) throws ClassNotFoundException {
        if (name.contains("/")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = ClassRegistries.forName(name, loader);
        if (initialize) {
            DynamicHub.fromClass(result).ensureInitialized();
        }
        return result;
    }

    @KeepOriginal
    public static native Class<?> forPrimitiveName(String var0);

    @KeepOriginal
    private native Package getPackage();

    @Substitute
    public String getPackageName() {
        if (SubstrateUtil.HOSTED) {
            return this.computePackageName();
        }
        if (this.companion.packageName == null) {
            this.companion.packageName = this.computePackageName();
        }
        return this.companion.packageName;
    }

    private boolean isHybrid() {
        if (SubstrateUtil.HOSTED) {
            return AnnotationAccess.isAnnotationPresent(this.hostedJavaClass, Hybrid.class);
        }
        return LayoutEncoding.isHybrid(this.getLayoutEncoding());
    }

    String computePackageName() {
        String cn;
        int dot;
        String pn = null;
        DynamicHub me = this;
        if (!this.isHybrid()) {
            while (me.hubIsArray()) {
                me = me.getComponentType();
            }
        }
        pn = me.isPrimitive() ? "java.lang" : ((dot = (cn = me.getName()).lastIndexOf(46)) != -1 ? cn.substring(0, dot).intern() : "");
        return pn;
    }

    @Substitute
    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    @KeepOriginal
    public native String toGenericString();

    @KeepOriginal
    private native void addSealingInfo(int var1, StringBuilder var2);

    @KeepOriginal
    private native boolean hasSealedAncestor(Class<?> var1);

    @KeepOriginal
    public native boolean isSynthetic();

    @Substitute
    public Object[] getSigners() {
        if (this.isPrimitive()) {
            return null;
        }
        this.checkClassFlag(0x8000000, "getSigners");
        if (this.hubMetadata() == null || this.hubMetadata().signersEncodingIndex == -1) {
            return null;
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseObjects(this.hubMetadata().signersEncodingIndex, this);
    }

    @Substitute
    public ProtectionDomain getProtectionDomain() {
        if (this.companion.protectionDomain == null) {
            this.companion.protectionDomain = ProtectionDomainSupport.allPermDomain();
        }
        return this.companion.protectionDomain;
    }

    void setProtectionDomainAtRuntime(ProtectionDomain protectionDomain) {
        VMError.guarantee(this.companion.protectionDomain == null && protectionDomain != null);
        this.companion.protectionDomain = protectionDomain;
    }

    @Substitute
    public boolean desiredAssertionStatus() {
        return DynamicHub.isFlagSet(this.flags, 4);
    }

    @Substitute
    public Module getModule() {
        return this.companion.module;
    }

    @Substitute
    public String methodToString(String nameArg, Class<?>[] argTypes) {
        return DynamicHub.describeMethod(this.getName() + "." + nameArg + "(", argTypes, ")");
    }

    private static String describeMethod(String prefix, Class<?>[] argTypes, String suffix) {
        StringJoiner sj = new StringJoiner(", ", prefix, suffix);
        if (argTypes != null) {
            for (Class<?> c : argTypes) {
                sj.add(c == null ? "null" : c.getName());
            }
        }
        return sj.toString();
    }

    @KeepOriginal
    private native <T> Target_java_lang_Class_ReflectionData<T> reflectionData();

    @KeepOriginal
    private native boolean isTopLevelClass();

    @Substitute
    private String getSimpleBinaryName0() {
        return this.companion.simpleBinaryName;
    }

    @Substitute
    List<Method> getDeclaredPublicMethods(String methodName, Class<?> ... parameterTypes) {
        Method[] methods = this.privateGetDeclaredMethods(true);
        ReflectionFactory factory = DynamicHub.getReflectionFactory();
        ArrayList<Method> result = new ArrayList<Method>();
        boolean matchedAnyRegistered = false;
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || !Arrays.equals(factory.getExecutableSharedParameterTypes(method), parameterTypes)) continue;
            matchedAnyRegistered = true;
            if (!this.checkMethodExists(methodName, parameterTypes, method, true)) continue;
            result.add(factory.copyMethod(method));
        }
        if (!matchedAnyRegistered) {
            this.checkMethodExists(methodName, parameterTypes, null, true);
        }
        return result;
    }

    @Substitute
    public Class<?> getNestHost() {
        return this.companion.nestHost;
    }

    @Substitute
    public boolean isNestmateOf(Class<?> c) {
        return this.companion.nestHost == DynamicHub.fromClass(c).companion.nestHost;
    }

    @KeepOriginal
    public native Class<?>[] getNestMembers();

    @Override
    @Substitute
    public DynamicHub componentType() {
        return this.componentType;
    }

    @Override
    @Substitute
    public DynamicHub arrayType() {
        if (DynamicHub.toClass(this) == Void.TYPE) {
            throw new UnsupportedOperationException(new IllegalArgumentException());
        }
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceReflectionArrayType(DynamicHub.toClass(this));
        }
        if (this.companion.arrayHub == null || MissingRegistrationUtils.throwMissingRegistrationErrors() && !ClassForNameSupport.isRegisteredClass(ClassNameSupport.getArrayReflectionName((String)this.getName()))) {
            MissingReflectionRegistrationUtils.reportClassAccess(this.getTypeName() + "[]");
        }
        return this.companion.arrayHub;
    }

    @KeepOriginal
    private native Class<?> elementType();

    @Override
    @KeepOriginal
    public native String descriptorString();

    @Override
    @KeepOriginal
    public native Optional<? extends ConstantDesc> describeConstable();

    @KeepOriginal
    private static native String typeVarBounds(TypeVariable<?> var0);

    @Delete
    private static native void registerNatives();

    @Delete
    static native Class<?> getPrimitiveClass(String var0);

    @Substitute
    private Object[] getEnclosingMethod0() {
        if (this.hubMetadata() == null || this.hubMetadata().enclosingMethodInfoIndex == -1) {
            return null;
        }
        Object[] enclosingMethod = ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseEnclosingMethod(this.hubMetadata().enclosingMethodInfoIndex, this);
        if (enclosingMethod != null) {
            PredefinedClassesSupport.throwIfUnresolvable((Class)enclosingMethod[0], this.getClassLoader0());
        }
        return enclosingMethod;
    }

    @Substitute
    private DynamicHub[] getInterfaces0() {
        Object interfacesEncoding = this.companion.interfacesEncoding;
        if (interfacesEncoding == null) {
            return new DynamicHub[0];
        }
        if (interfacesEncoding instanceof DynamicHub) {
            return new DynamicHub[]{(DynamicHub)interfacesEncoding};
        }
        return (DynamicHub[])interfacesEncoding;
    }

    @Substitute
    private void setSigners(Object[] signers) {
        throw VMError.unsupportedFeature("Class metadata cannot be changed at run time");
    }

    @Delete
    private native ProtectionDomain getProtectionDomain0();

    @Substitute
    private String getGenericSignature0() {
        return this.companion.signature;
    }

    @Substitute
    byte[] getRawAnnotations() {
        if (this.hubMetadata() == null || this.hubMetadata().annotationsIndex == -1) {
            return null;
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseByteArray(this.hubMetadata().annotationsIndex, this);
    }

    @Substitute
    byte[] getRawTypeAnnotations() {
        if (this.hubMetadata() == null || this.hubMetadata().typeAnnotationsIndex == -1) {
            return null;
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseByteArray(this.hubMetadata().typeAnnotationsIndex, this);
    }

    @Substitute
    Target_jdk_internal_reflect_ConstantPool getConstantPool() {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            return ConstantPoolProvider.singletons()[this.layerId].getConstantPool();
        }
        return null;
    }

    @Substitute
    private Field[] getDeclaredFields0(boolean publicOnly) {
        return (Field[])this.getElements((reflectionMetadata, layerNum) -> this.getDeclaredFields0(publicOnly, (ReflectionMetadata)reflectionMetadata, (int)layerNum), Field[]::new);
    }

    private Field[] getDeclaredFields0(boolean publicOnly, ReflectionMetadata reflectionMetadata, int layerNum) {
        if (reflectionMetadata == null || reflectionMetadata.fieldsEncodingIndex == -1) {
            return new Field[0];
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseFields(this, reflectionMetadata.fieldsEncodingIndex, publicOnly, layerNum);
    }

    @Substitute
    private Method[] getDeclaredMethods0(boolean publicOnly) {
        return (Method[])this.getElements((reflectionMetadata, layerNum) -> this.getDeclaredMethods0(publicOnly, (ReflectionMetadata)reflectionMetadata, (int)layerNum), Method[]::new);
    }

    private Method[] getDeclaredMethods0(boolean publicOnly, ReflectionMetadata reflectionMetadata, int layerNum) {
        if (reflectionMetadata == null || reflectionMetadata.methodsEncodingIndex == -1) {
            return new Method[0];
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseMethods(this, reflectionMetadata.methodsEncodingIndex, publicOnly, layerNum);
    }

    @Substitute
    private Constructor<?>[] getDeclaredConstructors0(boolean publicOnly) {
        return (Constructor[])this.getElements((reflectionMetadata, layerNum) -> this.getDeclaredConstructors0(publicOnly, (ReflectionMetadata)reflectionMetadata, (int)layerNum), Constructor[]::new);
    }

    private Constructor<?>[] getDeclaredConstructors0(boolean publicOnly, ReflectionMetadata reflectionMetadata, int layerNum) {
        if (reflectionMetadata == null || reflectionMetadata.constructorsEncodingIndex == -1) {
            return new Constructor[0];
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseConstructors(this, reflectionMetadata.constructorsEncodingIndex, publicOnly, layerNum);
    }

    @Substitute
    private Class<?>[] getDeclaredClasses0() {
        Class<?>[] declaredClasses;
        if (this.hubMetadata() == null || this.hubMetadata().classesEncodingIndex == -1) {
            return new Class[0];
        }
        for (Class<?> clazz : declaredClasses = ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseClasses(this.hubMetadata().classesEncodingIndex, this)) {
            PredefinedClassesSupport.throwIfUnresolvable(clazz, this.getClassLoader0());
        }
        return declaredClasses;
    }

    @Delete
    private static native boolean desiredAssertionStatus0(Class<?> var0);

    @Delete
    private native Class<?> getNestHost0();

    @Substitute
    private Class<?>[] getNestMembers0() {
        Class<?>[] nestMembers;
        this.checkClassFlag(0x4000000, "getNestMembers");
        if (this.hubMetadata() == null || this.hubMetadata().nestMembersEncodingIndex == -1) {
            return new Class[]{DynamicHub.toClass(this)};
        }
        for (Class<?> clazz : nestMembers = ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseClasses(this.hubMetadata().nestMembersEncodingIndex, this)) {
            PredefinedClassesSupport.throwIfUnresolvable(clazz, this.getClassLoader0());
        }
        return nestMembers;
    }

    @Delete
    private native String initClassName();

    @KeepOriginal
    private static native Class<?> toClass(Type var0);

    @Substitute
    private ClassRepository getGenericInfo() {
        if (this.companion.genericInfo == null) {
            this.companion.genericInfo = this.computeGenericInfo();
        }
        return this.companion.genericInfo != ClassRepository.NONE ? this.companion.genericInfo : null;
    }

    ClassRepository computeGenericInfo() {
        String genericSignature = this.getGenericSignature0();
        if (genericSignature == null) {
            return ClassRepository.NONE;
        }
        return ClassRepository.make(genericSignature, this.getFactory());
    }

    @KeepOriginal
    private native Target_java_lang_Class_EnclosingMethodInfo getEnclosingMethodInfo();

    @KeepOriginal
    private native boolean hasEnclosingMethodInfo();

    @KeepOriginal
    private native <T> Target_java_lang_Class_ReflectionData<T> newReflectionData(SoftReference<Target_java_lang_Class_ReflectionData<T>> var1, int var2);

    @KeepOriginal
    private native Target_java_lang_Class_AnnotationData annotationData();

    @KeepOriginal
    private native Target_java_lang_Class_AnnotationData createAnnotationData(int var1);

    @Substitute
    private Class<?>[] getPermittedSubclasses0() {
        Class<?>[] permittedSubclasses;
        if (!this.isSealed()) {
            return null;
        }
        this.checkClassFlag(0x2000000, "getPermittedSubclasses");
        if (this.hubMetadata() == null || this.hubMetadata().permittedSubclassesEncodingIndex == -1) {
            return new Class[0];
        }
        for (Class<?> clazz : permittedSubclasses = ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseClasses(this.hubMetadata().permittedSubclassesEncodingIndex, this)) {
            PredefinedClassesSupport.throwIfUnresolvable(clazz, this.getClassLoader0());
        }
        return permittedSubclasses;
    }

    @KeepOriginal
    private native GenericsFactory getFactory();

    @KeepOriginal
    native Method findMethod(boolean var1, String var2, Class<?> ... var3);

    @KeepOriginal
    private native Method getMethod0(String var1, Class<?>[] var2);

    @KeepOriginal
    private static native void addAll(Collection<Field> var0, Field[] var1);

    @KeepOriginal
    private native Target_java_lang_PublicMethods_MethodList getMethodsRecursive(String var1, Class<?>[] var2, boolean var3, boolean var4);

    @KeepOriginal
    private native Field getField0(String var1);

    @KeepOriginal
    native AnnotationType getAnnotationType();

    @KeepOriginal
    static native byte[] getExecutableTypeAnnotationBytes(Executable var0);

    @KeepOriginal
    private native boolean isDirectSubType(Class<?> var1);

    @KeepOriginal
    native boolean casAnnotationType(AnnotationType var1, AnnotationType var2);

    private static Field[] filterFields(Field ... fields) {
        ArrayList<Field> filtered = new ArrayList<Field>();
        RuntimeMetadataDecoder decoder = (RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class);
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (decoder.isHiding(modifiers) || decoder.isNegative(modifiers)) continue;
            filtered.add(field);
        }
        return filtered.toArray(new Field[0]);
    }

    private static Method[] filterMethods(Method ... methods) {
        ArrayList<Method> filtered = new ArrayList<Method>();
        RuntimeMetadataDecoder decoder = (RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class);
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (decoder.isHiding(modifiers) || decoder.isNegative(modifiers)) continue;
            filtered.add(method);
        }
        return filtered.toArray(new Method[0]);
    }

    private static Constructor<?>[] filterConstructors(Constructor<?> ... constructors) {
        ArrayList filtered = new ArrayList();
        RuntimeMetadataDecoder decoder = (RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class);
        for (Constructor<?> constructor : constructors) {
            if (decoder.isNegative(constructor.getModifiers())) continue;
            filtered.add(constructor);
        }
        return filtered.toArray(new Constructor[0]);
    }

    public void setJrfEventConfiguration(Object configuration) {
        this.companion.jfrEventConfiguration = configuration;
    }

    public Object getJfrEventConfiguration() {
        return this.companion.jfrEventConfiguration;
    }

    public boolean isReached() {
        return this.companion.classInitializationInfo.isTypeReached(this);
    }

    public boolean isRuntimeLoaded() {
        return RuntimeClassLoading.isSupported() && this.getLayerId() == 127;
    }

    public RuntimeMetadataDecoder.FieldDescriptor[] getReachableFields() {
        return (RuntimeMetadataDecoder.FieldDescriptor[])this.getElements(this::getReachableFields, RuntimeMetadataDecoder.FieldDescriptor[]::new);
    }

    private RuntimeMetadataDecoder.FieldDescriptor[] getReachableFields(ReflectionMetadata reflectionMetadata, int layerNum) {
        if (reflectionMetadata == null || reflectionMetadata.fieldsEncodingIndex == -1) {
            return new RuntimeMetadataDecoder.FieldDescriptor[0];
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseReachableFields(this, reflectionMetadata.fieldsEncodingIndex, layerNum);
    }

    public RuntimeMetadataDecoder.MethodDescriptor[] getReachableMethods() {
        return (RuntimeMetadataDecoder.MethodDescriptor[])this.getElements(this::getReachableMethods, RuntimeMetadataDecoder.MethodDescriptor[]::new);
    }

    private RuntimeMetadataDecoder.MethodDescriptor[] getReachableMethods(ReflectionMetadata reflectionMetadata, int layerNum) {
        if (reflectionMetadata == null || reflectionMetadata.methodsEncodingIndex == -1) {
            return new RuntimeMetadataDecoder.MethodDescriptor[0];
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseReachableMethods(this, reflectionMetadata.methodsEncodingIndex, layerNum);
    }

    public RuntimeMetadataDecoder.ConstructorDescriptor[] getReachableConstructors() {
        return (RuntimeMetadataDecoder.ConstructorDescriptor[])this.getElements(this::getReachableConstructors, RuntimeMetadataDecoder.ConstructorDescriptor[]::new);
    }

    private RuntimeMetadataDecoder.ConstructorDescriptor[] getReachableConstructors(ReflectionMetadata reflectionMetadata, int layerNum) {
        if (reflectionMetadata == null || reflectionMetadata.constructorsEncodingIndex == -1) {
            return new RuntimeMetadataDecoder.ConstructorDescriptor[0];
        }
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseReachableConstructors(this, reflectionMetadata.constructorsEncodingIndex, layerNum);
    }

    private <T> T[] getElements(BiFunction<ReflectionMetadata, Integer, T[]> elementsAccessor, IntFunction<T[]> generator) {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            ArrayList elements = new ArrayList();
            LayeredReflectionMetadataSingleton[] layeredReflectionMetadata = LayeredReflectionMetadataSingleton.singletons();
            for (int layerNum = 0; layerNum < layeredReflectionMetadata.length; ++layerNum) {
                Collections.addAll(elements, elementsAccessor.apply(layeredReflectionMetadata[layerNum].getReflectionMetadata(this), layerNum));
            }
            return elements.toArray(generator);
        }
        return elementsAccessor.apply(this.reflectionMetadata(), 0);
    }

    static final class DynamicHubMetadata {
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int enclosingMethodInfoIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int annotationsIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int typeAnnotationsIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int classesEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int permittedSubclassesEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int nestMembersEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int signersEncodingIndex;

        private DynamicHubMetadata(int enclosingMethodInfoIndex, int annotationsIndex, int typeAnnotationsIndex, int classesEncodingIndex, int permittedSubclassesEncodingIndex, int nestMembersEncodingIndex, int signersEncodingIndex) {
            this.enclosingMethodInfoIndex = enclosingMethodInfoIndex;
            this.annotationsIndex = annotationsIndex;
            this.typeAnnotationsIndex = typeAnnotationsIndex;
            this.classesEncodingIndex = classesEncodingIndex;
            this.permittedSubclassesEncodingIndex = permittedSubclassesEncodingIndex;
            this.nestMembersEncodingIndex = nestMembersEncodingIndex;
            this.signersEncodingIndex = signersEncodingIndex;
        }
    }

    static final class ReflectionMetadata {
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int fieldsEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int methodsEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int constructorsEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int recordComponentsEncodingIndex;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.CompileQueueFinished.class)
        final int classFlags;

        private ReflectionMetadata(int fieldsEncodingIndex, int methodsEncodingIndex, int constructorsEncodingIndex, int recordComponentsEncodingIndex, int classFlags) {
            this.fieldsEncodingIndex = fieldsEncodingIndex;
            this.methodsEncodingIndex = methodsEncodingIndex;
            this.constructorsEncodingIndex = constructorsEncodingIndex;
            this.recordComponentsEncodingIndex = recordComponentsEncodingIndex;
            this.classFlags = classFlags;
        }
    }

    private static final class CachedConstructorAccessors {
        private CachedConstructorAccessors() {
        }

        private static Constructor<?> getCachedConstructor(DynamicHub that) {
            that.ensureInitialized();
            return that.companion.cachedConstructor;
        }

        private static void setCachedConstructor(DynamicHub that, Constructor<?> value) {
            that.companion.cachedConstructor = value;
        }
    }

    private static final class AnnotationTypeAccessors {
        private AnnotationTypeAccessors() {
        }

        private static AnnotationType getAnnotationType(DynamicHub that) {
            return that.companion.annotationType;
        }
    }

    private static final class AnnotationDataAccessors {
        private AnnotationDataAccessors() {
        }

        private static Target_java_lang_Class_AnnotationData getAnnotationData(DynamicHub that) {
            return that.companion.annotationData;
        }
    }

    private static final class ClassLoaderAccessors {
        private ClassLoaderAccessors() {
        }

        private static ClassLoader getClassLoader(DynamicHub that) {
            return that.getClassLoader();
        }
    }

    private static final class ClassRedefinedCountAccessors {
        private ClassRedefinedCountAccessors() {
        }

        private static int getClassRedefinedCount(DynamicHub that) {
            return 0;
        }
    }

    private static final class ReflectionDataAccessors {
        private ReflectionDataAccessors() {
        }

        private static SoftReference<Target_java_lang_Class_ReflectionData<?>> getReflectionData(DynamicHub that) {
            return that.companion.reflectionData;
        }
    }
}

