/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.nodes.NewPodInstanceNode;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class PodReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void walkOffsetsFromPointer(Pointer baseAddress, int layoutEncoding, ObjectReferenceVisitor visitor, Object obj) {
        int nrefs;
        int gap;
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        UnsignedWord refOffset = LayoutEncoding.getArrayBaseOffset(layoutEncoding);
        UnsignedWord mapOffset = PodReferenceMapDecoder.getReferenceMapOffset(obj, layoutEncoding);
        do {
            mapOffset = mapOffset.subtract(2);
            gap = UninterruptibleUtils.Byte.toUnsignedInt(baseAddress.readByte((WordBase)mapOffset));
            nrefs = UninterruptibleUtils.Byte.toUnsignedInt(baseAddress.readByte((WordBase)mapOffset.add(1)));
            Pointer firstObjRef = baseAddress.add(refOffset);
            PodReferenceMapDecoder.callVisitor(firstObjRef, visitor, obj, nrefs);
            refOffset = refOffset.add(referenceSize * (nrefs + gap));
        } while (gap != 0 || nrefs == 255);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static void callVisitor(Pointer firstObjRef, ObjectReferenceVisitor visitor, Object obj, int count) {
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        visitor.visitObjectReferences(firstObjRef, true, referenceSize, obj, count);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean hasEmptyReferenceMap(Object obj) {
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        int layoutEncoding = hub.getLayoutEncoding();
        UnsignedWord mapOffset = PodReferenceMapDecoder.getReferenceMapOffset(obj, layoutEncoding);
        mapOffset = mapOffset.subtract(2);
        int gap = UninterruptibleUtils.Byte.toUnsignedInt(ObjectAccess.readByte((Object)obj, (WordBase)mapOffset));
        int nrefs = UninterruptibleUtils.Byte.toUnsignedInt(ObjectAccess.readByte((Object)obj, (WordBase)mapOffset.add(1)));
        return gap == 0 && nrefs != 255;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getReferenceMapOffset(Object obj, int layoutEncoding) {
        return LayoutEncoding.getArrayElementOffset(layoutEncoding, ArrayLengthNode.arrayLength((Object)obj));
    }

    public static Object clone(Object original, DynamicHub hub, int layoutEncoding) {
        Class nonNullHub = (Class)GraalDirectives.guardingNonNull(DynamicHub.toClass(hub));
        int length = ArrayLengthNode.arrayLength((Object)original);
        byte[] referenceMap = PodReferenceMapDecoder.extractReferenceMap(original, layoutEncoding, length);
        Object result = NewPodInstanceNode.newPodInstance(null, nonNullHub, length, referenceMap);
        PodReferenceMapDecoder.copyArray(original, result, layoutEncoding, length);
        return result;
    }

    private static byte[] extractReferenceMap(Object obj, int layoutEncoding, int length) {
        int nrefs;
        int gap;
        UnsignedWord mapEndOffset;
        UnsignedWord mapOffset = mapEndOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, length);
        do {
            mapOffset = mapOffset.subtract(2);
            gap = Byte.toUnsignedInt(BarrieredAccess.readByte((Object)obj, (WordBase)mapOffset));
            nrefs = Byte.toUnsignedInt(BarrieredAccess.readByte((Object)obj, (WordBase)mapOffset.add(1)));
        } while (gap != 0 || nrefs == 255);
        int refMapLength = UnsignedUtils.safeToInt(mapEndOffset.subtract(mapOffset));
        byte[] refMap = new byte[refMapLength];
        for (int i = 0; i < refMapLength; ++i) {
            refMap[i] = BarrieredAccess.readByte((Object)obj, (WordBase)mapOffset.add(i));
        }
        return refMap;
    }

    private static void copyArray(Object original, Object copy, int layoutEncoding, int length) {
        UnsignedWord nrefs;
        UnsignedWord gap;
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        UnsignedWord refOffset = LayoutEncoding.getArrayBaseOffset(layoutEncoding);
        UnsignedWord mapOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, length);
        do {
            mapOffset = mapOffset.subtract(2);
            gap = Word.unsigned((int)Byte.toUnsignedInt(BarrieredAccess.readByte((Object)copy, (WordBase)mapOffset)));
            nrefs = Word.unsigned((int)Byte.toUnsignedInt(BarrieredAccess.readByte((Object)copy, (WordBase)mapOffset.add(1))));
            JavaMemoryUtil.copyReferencesForward(original, refOffset, copy, refOffset, nrefs);
            UnsignedWord primOffset = refOffset.add(nrefs.multiply(referenceSize));
            UnsignedWord primBytes = gap.multiply(referenceSize);
            JavaMemoryUtil.copyForward(original, primOffset, copy, primOffset, primBytes);
            refOffset = primOffset.add(primBytes);
        } while (gap.notEqual(0) || nrefs.equal(255));
        UnsignedWord primBytes = mapOffset.subtract(refOffset);
        JavaMemoryUtil.copyForward(original, refOffset, copy, refOffset, primBytes);
    }

    private PodReferenceMapDecoder() {
    }
}

