/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.dump.HeapDumping;
import com.oracle.svm.core.jdk.JDKUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;

public class OutOfMemoryUtil {
    private static final OutOfMemoryError OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Garbage-collected heap size exceeded. Consider increasing the maximum Java heap size, for example with '-Xmx'.");

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Can't allocate when out of memory.")
    public static OutOfMemoryError heapSizeExceeded() {
        return OutOfMemoryUtil.reportOutOfMemoryError(OUT_OF_MEMORY_ERROR);
    }

    @Uninterruptible(reason="Not uninterruptible but it doesn't matter for the callers.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Can't allocate while out of memory.")
    public static OutOfMemoryError reportOutOfMemoryError(OutOfMemoryError error) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            OutOfMemoryUtil.reportOutOfMemoryError0(error);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
        throw error;
    }

    @Uninterruptible(reason="Not uninterruptible but it doesn't matter for the callers.", calleeMustBe=false)
    private static void reportOutOfMemoryError0(OutOfMemoryError error) {
        if (VMOperation.isGCInProgress()) {
            return;
        }
        if (VMInspectionOptions.hasHeapDumpSupport() && SubstrateOptions.HeapDumpOnOutOfMemoryError.getValue().booleanValue()) {
            HeapDumping.singleton().dumpHeapOnOutOfMemoryError();
        }
        if (SubstrateGCOptions.ExitOnOutOfMemoryError.getValue().booleanValue()) {
            if (LibC.isSupported()) {
                Log.log().string("Terminating due to java.lang.OutOfMemoryError: ").string(JDKUtils.getRawMessage(error)).newline();
                LibC.exit(3);
            } else {
                VMError.shouldNotReachHere("ExitOnOutOfMemoryError can only be used if the LibC support is present.");
            }
        }
        if (SubstrateGCOptions.ReportFatalErrorOnOutOfMemoryError.getValue().booleanValue()) {
            throw VMError.shouldNotReachHere("reporting due to java.lang.OutOfMemoryError");
        }
    }
}

