/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ComputeReferenceValue
implements FieldValueTransformer {
    private static final Field REFERENT_FIELD = ReflectionUtil.lookupField(Reference.class, (String)"referent");

    ComputeReferenceValue() {
    }

    public Object transform(Object receiver, Object originalValue) {
        if (receiver instanceof PhantomReference) {
            return null;
        }
        try {
            return REFERENT_FIELD.get(receiver);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

