/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.memory.FloatableThreadLocalAccess;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class LoadVMThreadLocalNode
extends FixedWithNextNode
implements VMThreadLocalAccess,
Lowerable,
SingleMemoryKill,
OrderedMemoryAccess,
MemoryAccess,
FloatableThreadLocalAccess {
    public static final NodeClass<LoadVMThreadLocalNode> TYPE = NodeClass.create(LoadVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    protected final BarrierType barrierType;
    @Node.Input
    protected ValueNode holder;
    private final MemoryOrderMode memoryOrder;

    public LoadVMThreadLocalNode(MetaAccessProvider metaAccess, VMThreadLocalInfo threadLocalInfo, ValueNode holder, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(TYPE, (Stamp)(threadLocalInfo.isObject ? StampFactory.object((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)metaAccess.lookupJavaType(threadLocalInfo.valueClass))) : StampFactory.forKind((JavaKind)threadLocalInfo.storageKind)));
        this.threadLocalInfo = threadLocalInfo;
        this.barrierType = barrierType;
        this.holder = holder;
        this.memoryOrder = memoryOrder;
    }

    public LocationIdentity getLocationIdentity() {
        return this.threadLocalInfo.locationIdentity;
    }

    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    public boolean canFloat() {
        return !this.ordersMemoryAccesses() && this.threadLocalInfo.allowFloatingReads;
    }

    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.holder.graph());
        AddressNode address = (AddressNode)this.graph().unique((Node)new OffsetAddressNode(this.holder, (ValueNode)offset));
        JavaReadNode read = (JavaReadNode)this.graph().add((Node)new JavaReadNode(this.stamp, this.threadLocalInfo.storageKind, address, this.threadLocalInfo.locationIdentity, this.barrierType, this.memoryOrder, true));
        if (this.canFloat()) {
            read.setGuard((GuardingNode)read.graph().start());
        }
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)read);
        tool.getLowerer().lower((Node)read, tool);
    }
}

