/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Predicate;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class KnownOffsets {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int vtableBaseOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int vtableEntrySize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int typeIDSlotsOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int javaFrameAnchorLastSPOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int javaFrameAnchorLastIPOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int vmThreadStatusOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int imageCodeInfoCodeStartOffset;

    @Fold
    public static KnownOffsets singleton() {
        return (KnownOffsets)ImageSingletons.lookup(KnownOffsets.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setLazyState(int vtableBaseOffset, int vtableEntrySize, int typeIDSlotsOffset, int javaFrameAnchorLastSPOffset, int javaFrameAnchorLastIPOffset, int vmThreadStatusOffset, int imageCodeInfoCodeStartOffset) {
        assert (!this.isFullyInitialized());
        this.vtableBaseOffset = vtableBaseOffset;
        this.vtableEntrySize = vtableEntrySize;
        this.typeIDSlotsOffset = typeIDSlotsOffset;
        this.javaFrameAnchorLastSPOffset = javaFrameAnchorLastSPOffset;
        this.javaFrameAnchorLastIPOffset = javaFrameAnchorLastIPOffset;
        this.vmThreadStatusOffset = vmThreadStatusOffset;
        this.imageCodeInfoCodeStartOffset = imageCodeInfoCodeStartOffset;
        assert (this.isFullyInitialized());
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            int[] currentValues = new int[]{vtableBaseOffset, vtableEntrySize, typeIDSlotsOffset, javaFrameAnchorLastSPOffset, javaFrameAnchorLastIPOffset, vmThreadStatusOffset, imageCodeInfoCodeStartOffset};
            long numFields = Arrays.stream(KnownOffsets.class.getDeclaredFields()).filter(Predicate.not(Field::isSynthetic)).count();
            VMError.guarantee(numFields == (long)currentValues.length, "Missing fields");
            if (ImageLayerBuildingSupport.buildingInitialLayer()) {
                ImageSingletons.add(PriorKnownOffsets.class, (Object)new PriorKnownOffsets(currentValues));
            } else {
                VMError.guarantee(Arrays.equals(currentValues, ((PriorKnownOffsets)ImageSingletons.lookup(PriorKnownOffsets.class)).priorValues));
            }
        }
    }

    private boolean isFullyInitialized() {
        return this.vtableEntrySize > 0;
    }

    public int getVTableBaseOffset() {
        return this.vtableBaseOffset;
    }

    public int getVTableEntrySize() {
        return this.vtableEntrySize;
    }

    public int getVTableOffset(int vTableIndex, boolean fromDynamicHubStart) {
        assert (this.isFullyInitialized());
        if (fromDynamicHubStart) {
            return this.vtableBaseOffset + vTableIndex * this.vtableEntrySize;
        }
        return vTableIndex * this.vtableEntrySize;
    }

    public int getTypeIDSlotsOffset() {
        assert (this.isFullyInitialized() && SubstrateOptions.useClosedTypeWorldHubLayout());
        return this.typeIDSlotsOffset;
    }

    public int getJavaFrameAnchorLastSPOffset() {
        assert (this.isFullyInitialized());
        return this.javaFrameAnchorLastSPOffset;
    }

    public int getJavaFrameAnchorLastIPOffset() {
        assert (this.isFullyInitialized());
        return this.javaFrameAnchorLastIPOffset;
    }

    public int getVMThreadStatusOffset() {
        assert (this.isFullyInitialized());
        assert (this.vmThreadStatusOffset != -1);
        return this.vmThreadStatusOffset;
    }

    public int getImageCodeInfoCodeStartOffset() {
        assert (this.isFullyInitialized());
        return this.imageCodeInfoCodeStartOffset;
    }

    static class PriorKnownOffsets
    implements LayeredImageSingleton {
        final int[] priorValues;

        PriorKnownOffsets(int[] priorValues) {
            this.priorValues = priorValues;
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
        }

        @Override
        public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
            writer.writeIntList("priorValues", Arrays.stream(this.priorValues).boxed().toList());
            return LayeredImageSingleton.PersistFlags.CREATE;
        }

        public static Object createFromLoader(ImageSingletonLoader loader) {
            int[] priorValues = loader.readIntList("priorValues").stream().mapToInt(e -> e).toArray();
            return new PriorKnownOffsets(priorValues);
        }
    }
}

