/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.UninterruptibleObjectReferenceVisitor;
import java.lang.ref.Reference;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class ObjectRefFixupVisitor
implements UninterruptibleObjectReferenceVisitor {
    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
        Pointer pos = firstObjRef;
        Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
        while (pos.belowThan((UnsignedWord)end)) {
            ObjectRefFixupVisitor.visitObjectReference(pos, compressed, holderObject);
            pos = pos.add(referenceSize);
        }
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
        Word p = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        if (p.isNull() || HeapImpl.getHeapImpl().isInImageHeap((Pointer)p)) {
            return;
        }
        Object original = p.toObjectNonNull();
        if (ObjectHeaderImpl.isAlignedObject(original)) {
            Pointer newLocation = ObjectMoveInfo.getNewObjectAddress((Pointer)p);
            assert (newLocation.isNonNull() || holderObject == null || holderObject instanceof Reference);
            Object obj = newLocation.toObjectNonNull();
            ReferenceAccess.singleton().writeObjectAt(objRef, obj, compressed);
        }
    }
}

