/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AdaptiveWeightedAverageStruct;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.FillerObjectUtil;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkLogging;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.TlabOptionCache;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class TlabSupport {
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/tlab_globals.hpp#L65-L67")
    private static final long TLAB_ALLOCATION_WEIGHT = 35L;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/tlab_globals.hpp#L69-L76")
    private static final long TLAB_WASTE_TARGET_PERCENT = 1L;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/tlab_globals.hpp#L78-L80")
    private static final long TLAB_REFILL_WASTE_FRACTION = 64L;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/tlab_globals.hpp#L82-L85")
    private static final long TLAB_WASTE_INCREMENT = 4L;
    private static final FastThreadLocalWord<UnsignedWord> desiredSize = FastThreadLocalFactory.createWord("TlabSupport.desiredSize");
    private static final FastThreadLocalWord<UnsignedWord> tlabAllocatedAlignedBytesBeforeLastGC = FastThreadLocalFactory.createWord("TlabSupport.tlabAllocatedAlignedBytesBeforeLastGC");
    private static final FastThreadLocalInt numberOfRefills = FastThreadLocalFactory.createInt("TlabSupport.numberOfRefills");
    private static final FastThreadLocalInt refillWaste = FastThreadLocalFactory.createInt("TlabSupport.refillWaste");
    private static final FastThreadLocalInt gcWaste = FastThreadLocalFactory.createInt("TlabSupport.gcWaste");
    private static final FastThreadLocalBytes<AdaptiveWeightedAverageStruct.Data> allocatedBytesAvg = FastThreadLocalFactory.createBytes(() -> SizeOf.get(AdaptiveWeightedAverageStruct.Data.class), "TlabSupport.allocatedBytesAvg");
    private static final FastThreadLocalWord<UnsignedWord> refillWasteLimit = FastThreadLocalFactory.createWord("TlabSupport.refillWasteLimit");
    private static final FastThreadLocalInt slowAllocations = FastThreadLocalFactory.createInt("TlabSupport.slowAllocations");
    private static UnsignedWord targetRefills = Word.unsigned((int)1);
    private static boolean initialized;

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+8/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L226-L267")
    @Uninterruptible(reason="Accesses TLAB")
    public static void startupInitialization() {
        if (!initialized) {
            TlabOptionCache.singleton().cacheOptionValues();
            targetRefills = Word.unsigned((long)50L);
            targetRefills = UnsignedUtils.max(targetRefills, Word.unsigned((int)1));
            initialized = true;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L208-L225")
    @Uninterruptible(reason="Accesses TLAB")
    public static void initialize(IsolateThread thread) {
        TlabSupport.initialize(ThreadLocalAllocation.getTlab(thread), (Pointer)Word.nullPointer(), (Pointer)Word.nullPointer(), (Pointer)Word.nullPointer());
        desiredSize.set(thread, TlabSupport.initialDesiredSize());
        AdaptiveWeightedAverageStruct.initialize(allocatedBytesAvg.getAddress(thread), 35.0);
        refillWasteLimit.set(TlabSupport.initialRefillWasteLimit());
        TlabSupport.resetStatistics(thread);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+25/src/hotspot/share/gc/shared/memAllocator.cpp#L257-L329")
    @Uninterruptible(reason="Holds uninitialized memory.")
    static Pointer allocateRawMemoryInTlabSlow(UnsignedWord size) {
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.getTlab();
        if (TlabSupport.shouldRetainTlab(tlab)) {
            TlabSupport.recordSlowAllocation();
            return (Pointer)Word.nullPointer();
        }
        TlabSupport.recordRefillWaste();
        TlabSupport.retireTlab(CurrentIsolate.getCurrentThread(), false);
        UnsignedWord newTlabSize = TlabSupport.computeSizeOfNewTlab(size);
        if (newTlabSize.equal(0)) {
            return (Pointer)Word.nullPointer();
        }
        UnsignedWord computedMinSize = TlabSupport.computeMinSizeOfNewTlab(size);
        WordPointer allocatedTlabSize = (WordPointer)StackValue.get(WordPointer.class);
        Pointer memory = YoungGeneration.getHeapAllocation().allocateNewTlab(computedMinSize, newTlabSize, allocatedTlabSize);
        if (memory.isNull()) {
            assert (Word.unsigned((int)0).equal((UnsignedWord)allocatedTlabSize.read())) : "Allocation failed, but actual size was updated.";
            return (Pointer)Word.nullPointer();
        }
        assert (Word.unsigned((int)0).notEqual((UnsignedWord)allocatedTlabSize.read())) : "Allocation succeeded but actual size not updated.";
        TlabSupport.fillTlab(memory, memory.add(size), allocatedTlabSize);
        return memory;
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+25/src/hotspot/share/runtime/thread.cpp#L168-L174"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L183-L195")})
    @Uninterruptible(reason="Accesses TLAB")
    private static void fillTlab(Pointer start, Pointer top, WordPointer newSize) {
        numberOfRefills.set(numberOfRefills.get() + 1);
        Pointer hardEnd = start.add((UnsignedWord)newSize.read());
        Pointer end = hardEnd.subtract(TlabSupport.getFillerObjectSize());
        assert (top.belowOrEqual((UnsignedWord)end)) : "size too small";
        TlabSupport.initialize(ThreadLocalAllocation.getTlab(), start, top, end);
        refillWasteLimit.set(TlabSupport.initialRefillWasteLimit());
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+25/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L143-L145")
    @Uninterruptible(reason="Accesses TLAB")
    private static void recordRefillWaste() {
        long availableTlabMemory = TlabSupport.availableTlabMemory(ThreadLocalAllocation.getTlab()).rawValue();
        refillWaste.set(refillWaste.get() + UninterruptibleUtils.NumUtil.safeToInt(availableTlabMemory));
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+25/src/hotspot/share/runtime/thread.cpp#L157-L166"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+25/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L131-L141")})
    @Uninterruptible(reason="Accesses TLAB")
    private static void retireTlab(IsolateThread thread, boolean calculateStats) {
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.getTlab(thread);
        if (tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNonNull()) {
            UnsignedWord usedBytes = TlabSupport.getUsedTlabSize(tlab);
            ThreadLocalAllocation.allocatedAlignedBytes.set(thread, ThreadLocalAllocation.allocatedAlignedBytes.get(thread).add(usedBytes));
        }
        if (calculateStats) {
            TlabSupport.accumulateAndResetStatistics(thread);
        }
        if (tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNonNull()) {
            assert (TlabSupport.checkInvariants(tlab));
            TlabSupport.insertFiller(tlab);
            TlabSupport.initialize(tlab, (Pointer)Word.nullPointer(), (Pointer)Word.nullPointer(), (Pointer)Word.nullPointer());
        }
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static UnsignedWord getUsedTlabSize(ThreadLocalAllocation.Descriptor tlab) {
        Word start = tlab.getAlignedAllocationStart(SubstrateAllocationSnippets.TLAB_START_IDENTITY);
        Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        assert (top.aboveOrEqual((UnsignedWord)start));
        return top.subtract((UnsignedWord)start);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L197-L206")
    @Uninterruptible(reason="Accesses TLAB")
    private static void initialize(ThreadLocalAllocation.Descriptor tlab, Pointer start, Pointer top, Pointer end) {
        VMError.guarantee(top.belowOrEqual((UnsignedWord)end), "top greater end during initialization");
        tlab.setAlignedAllocationStart(start, SubstrateAllocationSnippets.TLAB_START_IDENTITY);
        tlab.setAllocationTop(top, SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        tlab.setAllocationEnd(end, SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        assert (TlabSupport.checkInvariants(tlab));
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.hpp#L90")
    @Uninterruptible(reason="Accesses TLAB")
    private static boolean checkInvariants(ThreadLocalAllocation.Descriptor tlab) {
        return tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).aboveOrEqual(tlab.getAlignedAllocationStart(SubstrateAllocationSnippets.TLAB_START_IDENTITY)) && tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).belowOrEqual(tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY));
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void suspendAllocationInCurrentThread() {
        TlabSupport.retireTlab(CurrentIsolate.getCurrentThread(), false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void tearDown() {
        IsolateThread thread = VMThreads.firstThreadUnsafe();
        VMError.guarantee(VMThreads.nextThread(thread).isNull(), "Other isolate threads are still active");
        HeapChunkProvider.freeUnalignedChunkList(ThreadLocalAllocation.getTlab(thread).getUnalignedChunk());
    }

    static void disableAndFlushForAllThreads() {
        VMOperation.guaranteeInProgressAtSafepoint("TlabSupport.disableAndFlushForAllThreads");
        IsolateThread vmThread = VMThreads.firstThread();
        while (vmThread.isNonNull()) {
            TlabSupport.disableAndFlushForThread(vmThread);
            vmThread = VMThreads.nextThread(vmThread);
        }
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void disableAndFlushForThread(IsolateThread vmThread) {
        TlabSupport.retireTlabToEden(vmThread);
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static void retireTlabToEden(IsolateThread thread) {
        VMThreads.guaranteeOwnsThreadMutex("Otherwise, we wouldn't be allowed to access the space.", true);
        TlabSupport.retireTlab(thread, true);
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.getTlab(thread);
        UnalignedHeapChunk.UnalignedHeader unalignedChunk = tlab.getUnalignedChunk();
        tlab.setUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)Word.nullPointer());
        Space eden = HeapImpl.getHeapImpl().getYoungGeneration().getEden();
        while (unalignedChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(unalignedChunk);
            HeapChunk.setNext(unalignedChunk, (UnalignedHeapChunk.UnalignedHeader)Word.nullPointer());
            eden.appendUnalignedHeapChunk(unalignedChunk);
            unalignedChunk = next;
        }
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static UnsignedWord availableTlabMemory(ThreadLocalAllocation.Descriptor tlab) {
        Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        Word end = tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        assert (top.belowOrEqual((UnsignedWord)end));
        if (top.isNull() || end.isNull()) {
            return Word.unsigned((int)0);
        }
        return end.subtract((UnsignedWord)top);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/collectedHeap.cpp#L253-L259")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getFillerObjectSize() {
        UnsignedWord minSize = FillerObjectUtil.objectMinSize();
        return minSize.aboveThan(ConfigurationValues.getObjectLayout().getAlignment()) ? minSize : (UnsignedWord)Word.zero();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L119-L124")
    @Uninterruptible(reason="Accesses TLAB")
    private static void insertFiller(ThreadLocalAllocation.Descriptor tlab) {
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).isNonNull()) : "Must not be retired";
        assert (tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNonNull()) : "Must not be retired";
        Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        Word hardEnd = tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY).add(TlabSupport.getFillerObjectSize());
        UnsignedWord size = hardEnd.subtract((UnsignedWord)top);
        if (top.belowThan((UnsignedWord)hardEnd)) {
            FillerObjectUtil.writeFillerObjectAt((Pointer)top, size, false);
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L175-L181")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void resetStatistics(IsolateThread thread) {
        numberOfRefills.set(thread, 0);
        refillWaste.set(thread, 0);
        gcWaste.set(thread, 0);
        slowAllocations.set(thread, 0);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L270-L289")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord initialDesiredSize() {
        UnsignedWord initSize;
        if (TlabOptionCache.singleton().getTlabSize() > 0L) {
            long tlabSize = TlabOptionCache.singleton().getTlabSize();
            initSize = Word.unsigned((long)ConfigurationValues.getObjectLayout().alignUp(tlabSize));
        } else {
            long initialTLABSize = TlabOptionCache.singleton().getInitialTLABSize();
            initSize = Word.unsigned((long)ConfigurationValues.getObjectLayout().alignUp(initialTLABSize));
        }
        long minTlabSize = TlabOptionCache.singleton().getMinTlabSize();
        return UnsignedUtils.clamp(initSize, Word.unsigned((long)minTlabSize), TlabSupport.maxSize());
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+11/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L154-L172")
    public static void resize(IsolateThread thread) {
        assert (SubstrateGCOptions.TlabOptions.ResizeTLAB.getValue().booleanValue());
        assert (VMOperation.isGCInProgress());
        UnsignedWord allocatedAvg = Word.unsigned((long)((long)AdaptiveWeightedAverageStruct.getAverage(allocatedBytesAvg.getAddress(thread))));
        UnsignedWord newSize = allocatedAvg.unsignedDivide(targetRefills);
        long minTlabSize = TlabOptionCache.singleton().getMinTlabSize();
        newSize = UnsignedUtils.clamp(newSize, Word.unsigned((long)minTlabSize), TlabSupport.maxSize());
        UnsignedWord alignedNewSize = Word.unsigned((long)ConfigurationValues.getObjectLayout().alignUp(newSize.rawValue()));
        if (SerialAndEpsilonGCOptions.PrintTLAB.getValue().booleanValue()) {
            Log.log().string("TLAB new size: thread ").zhex((WordBase)thread).string(", target refills: ").unsigned((WordBase)targetRefills).string(", alloc avg.: ").unsigned((WordBase)allocatedAvg).string(", desired size: ").unsigned((WordBase)desiredSize.get(thread)).string(" -> ").unsigned((WordBase)alignedNewSize).newline();
        }
        desiredSize.set(thread, alignedNewSize);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L64")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord initialRefillWasteLimit() {
        return desiredSize.get().unsignedDivide(Word.unsigned((long)64L));
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+8/src/hotspot/share/gc/shared/threadLocalAllocBuffer.inline.hpp#L54-L71")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord computeSizeOfNewTlab(UnsignedWord allocationSize) {
        assert (UnsignedUtils.isAMultiple(allocationSize, Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment())));
        UnsignedWord availableSize = YoungGeneration.getHeapAllocation().unsafeMaxTlabAllocSize();
        UnsignedWord newTlabSize = UnsignedUtils.min(UnsignedUtils.min(availableSize, desiredSize.get().add(allocationSize)), TlabSupport.maxSize());
        if (newTlabSize.belowThan(TlabSupport.computeMinSizeOfNewTlab(allocationSize))) {
            return (UnsignedWord)Word.zero();
        }
        return newTlabSize;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.inline.hpp#L73-L77")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord computeMinSizeOfNewTlab(UnsignedWord allocationSize) {
        UnsignedWord alignedSize = Word.unsigned((long)ConfigurationValues.getObjectLayout().alignUp(allocationSize.rawValue()));
        UnsignedWord sizeWithReserve = alignedSize.add(TlabSupport.getFillerObjectSize());
        long minTlabSize = TlabOptionCache.singleton().getMinTlabSize();
        return UnsignedUtils.max(sizeWithReserve, Word.unsigned((long)minTlabSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean shouldRetainTlab(ThreadLocalAllocation.Descriptor tlab) {
        return TlabSupport.availableTlabMemory(tlab).aboveThan(refillWasteLimit.get());
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+11/src/hotspot/share/gc/shared/threadLocalAllocBuffer.inline.hpp#L79-L94")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void recordSlowAllocation() {
        refillWasteLimit.set(refillWasteLimit.get().add(Word.unsigned((long)4L)));
        slowAllocations.set(slowAllocations.get() + 1);
    }

    @Fold
    static UnsignedWord maxSize() {
        return AlignedHeapChunk.getUsableSizeForObjects();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/threadLocalAllocBuffer.cpp#L76-L117")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void accumulateAndResetStatistics(IsolateThread thread) {
        UnsignedWord remaining = TlabSupport.availableTlabMemory(ThreadLocalAllocation.getTlab());
        gcWaste.set(thread, gcWaste.get() + UnsignedUtils.safeToInt(remaining));
        UnsignedWord totalAlignedAllocated = ThreadLocalAllocation.getAlignedAllocatedBytes(thread);
        UnsignedWord allocatedAlignedSinceLastGC = totalAlignedAllocated.subtract(tlabAllocatedAlignedBytesBeforeLastGC.get(thread));
        tlabAllocatedAlignedBytesBeforeLastGC.set(thread, totalAlignedAllocated);
        AdaptiveWeightedAverageStruct.sample(allocatedBytesAvg.getAddress(thread), allocatedAlignedSinceLastGC.rawValue());
        TlabSupport.printStats(thread, allocatedAlignedSinceLastGC);
        TlabSupport.resetStatistics(thread);
    }

    @Uninterruptible(reason="Bridge between uninterruptible and interruptible code", calleeMustBe=false)
    private static void printStats(IsolateThread thread, UnsignedWord allocatedBytesSinceLastGC) {
        if (!SerialAndEpsilonGCOptions.PrintTLAB.getValue().booleanValue() || !VMOperation.isGCInProgress()) {
            return;
        }
        long waste = gcWaste.get(thread) + refillWaste.get(thread);
        Log.log().string("TLAB: thread: ").zhex((WordBase)thread).string(", slow allocs: ").unsigned(slowAllocations.get(thread)).string(", refills: ").unsigned(numberOfRefills.get(thread)).string(", alloc bytes: ").unsigned((WordBase)allocatedBytesSinceLastGC).string(", alloc avg.: ").unsigned((long)allocatedBytesAvg.getAddress(thread).getAverage()).string(", waste bytes: ").unsigned(waste).string(", GC waste: ").unsigned(gcWaste.get(thread)).string(", refill waste: ").unsigned(refillWaste.get(thread)).newline();
    }

    static void logTlabChunks(Log log, IsolateThread thread, String shortSpaceName) {
        ThreadLocalAllocation.Descriptor tlab = TlabSupport.getTlabUnsafe(thread);
        UnalignedHeapChunk.UnalignedHeader uChunk = tlab.getUnalignedChunk();
        HeapChunkLogging.logChunks(log, uChunk, shortSpaceName, false);
    }

    static boolean printTlabInfo(Log log, Pointer ptr) {
        IsolateThread thread = VMThreads.firstThreadUnsafe();
        while (thread.isNonNull()) {
            if (TlabSupport.printTlabInfo(log, ptr, thread)) {
                return true;
            }
            thread = VMThreads.nextThread(thread);
        }
        return false;
    }

    static boolean printTlabInfo(Log log, Pointer ptr, IsolateThread thread) {
        ThreadLocalAllocation.Descriptor tlab = TlabSupport.getTlabUnsafe(thread);
        Word start = tlab.getAlignedAllocationStart(SubstrateAllocationSnippets.TLAB_START_IDENTITY);
        Word end = tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        if (start.belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)end)) {
            Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            boolean unusablePart = top.isNonNull() && ptr.aboveOrEqual((UnsignedWord)top);
            TlabSupport.printTlabMemoryInfo(log, thread, (Pointer)start, "aligned TLAB", unusablePart);
            return true;
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = tlab.getUnalignedChunk();
        while (uChunk.isNonNull()) {
            if (HeapChunk.asPointer(uChunk).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)HeapChunk.getEndPointer(uChunk))) {
                boolean unusablePart = ptr.aboveOrEqual((UnsignedWord)HeapChunk.getTopPointer(uChunk));
                TlabSupport.printTlabMemoryInfo(log, thread, HeapChunk.asPointer(uChunk), "unaligned chunk", unusablePart);
                return true;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return false;
    }

    private static void printTlabMemoryInfo(Log log, IsolateThread thread, Pointer start, String memoryType, boolean unusablePart) {
        String unusable = unusablePart ? "unusable part of " : "";
        log.string("points into ").string(unusable).string(memoryType).spaces(1).zhex((WordBase)start).spaces(1);
        log.string("(TLAB of thread ").zhex((WordBase)thread).string(")");
    }

    @Uninterruptible(reason="This whole method is unsafe, so it is only uninterruptible to satisfy the checks.")
    private static ThreadLocalAllocation.Descriptor getTlabUnsafe(IsolateThread thread) {
        assert (SubstrateDiagnostics.isFatalErrorHandlingThread()) : "can cause crashes, so it may only be used while printing diagnostics";
        return ThreadLocalAllocation.getTlab(thread);
    }
}

