/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class SerialGCOptions {
    public static final HostedOptionKey<String> InitialCollectionPolicy = new HostedOptionKey<String>("Adaptive", SerialGCOptions::validateSerialHostedOption);
    public static final RuntimeOptionKey<Integer> PercentTimeInIncrementalCollection = new RuntimeOptionKey<Integer>(Integer.valueOf(50), SerialGCOptions::validateSerialRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Long> MaxHeapFree = new RuntimeOptionKey<Long>(Long.valueOf(0L), SerialGCOptions::validateSerialRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Integer> MaxSurvivorSpaces = new HostedOptionKey<Integer>(null, SerialGCOptions::validateSerialHostedOption){

        public Integer getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
            Integer value = (Integer)values.get((Object)this);
            UserError.guarantee(value == null || value >= 0, "%s value must be greater than or equal to 0", this.getName());
            return CollectionPolicy.getMaxSurvivorSpaces(value);
        }

        public Integer getValue(OptionValues values) {
            assert (this.checkDescriptorExists());
            return this.getValueOrDefault(values.getMap());
        }
    };
    public static final RuntimeOptionKey<Boolean> CollectYoungGenerationSeparately = new RuntimeOptionKey<Object>(null, SerialGCOptions::validateSerialRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> ImageHeapCardMarking = new HostedOptionKey<Object>(null, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Integer> SoftRefLRUPolicyMSPerMB = new HostedOptionKey<Integer>(1000, SerialGCOptions::validateSerialHostedOption);
    public static final RuntimeOptionKey<Boolean> PrintGCSummary = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::validateSerialRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> PrintGCTimes = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::validateSerialRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> VerifyBeforeGC = new HostedOptionKey<Boolean>(true, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> VerifyDuringGC = new HostedOptionKey<Boolean>(true, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> VerifyAfterGC = new HostedOptionKey<Boolean>(true, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> VerifyRememberedSet = new HostedOptionKey<Boolean>(true, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> VerifyReferences = new HostedOptionKey<Boolean>(true, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> VerifyReferencesPointIntoValidChunk = new HostedOptionKey<Boolean>(false, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> VerifyWriteBarriers = new HostedOptionKey<Boolean>(false, SerialGCOptions::validateSerialHostedOption);
    public static final RuntimeOptionKey<Boolean> TraceHeapChunks = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::validateSerialRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> GreyToBlackObjRefDemographics = new HostedOptionKey<Boolean>(false, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> IgnoreMaxHeapSizeWhileInVMInternalCode = new HostedOptionKey<Boolean>(false, SerialGCOptions::validateSerialHostedOption);
    public static final HostedOptionKey<Boolean> OutlineWriteBarriers = new HostedOptionKey<Object>(null, SerialGCOptions::validateSerialHostedOption);

    private SerialGCOptions() {
    }

    private static void validateSerialHostedOption(HostedOptionKey<?> optionKey) {
        if (optionKey.hasBeenSet() && !SubstrateOptions.useSerialGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial garbage collector ('--gc=serial').", new Object[0]);
        }
    }

    private static void validateSerialRuntimeOption(RuntimeOptionKey<?> optionKey) {
        if (optionKey.hasBeenSet() && !SubstrateOptions.useSerialGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial garbage collector ('--gc=serial').", new Object[0]);
        }
    }

    private static void validateCompactingOldGen(HostedOptionKey<Boolean> compactingOldGen) {
        if (!compactingOldGen.getValue().booleanValue()) {
            return;
        }
        SerialGCOptions.validateSerialHostedOption(compactingOldGen);
        if (!SerialGCOptions.useRememberedSet()) {
            throw UserError.abort("%s requires %s.", SubstrateOptionsParser.commandArgument(ConcealedOptions.CompactingOldGen, "+"), SubstrateOptionsParser.commandArgument(ConcealedOptions.UseRememberedSet, "+"));
        }
        if (SerialAndEpsilonGCOptions.AlignedHeapChunkSize.getValue() > 524288L) {
            throw UserError.abort("%s requires %s.", SubstrateOptionsParser.commandArgument(ConcealedOptions.CompactingOldGen, "+"), SubstrateOptionsParser.commandArgument(SerialAndEpsilonGCOptions.AlignedHeapChunkSize, "<value below or equal to 524288>"));
        }
    }

    @Fold
    public static boolean useRememberedSet() {
        return !SubstrateOptions.useEpsilonGC() && ConcealedOptions.UseRememberedSet.getValue() != false;
    }

    @Fold
    public static boolean useCompactingOldGen() {
        return !SubstrateOptions.useEpsilonGC() && ConcealedOptions.CompactingOldGen.getValue() != false;
    }

    public static class ConcealedOptions {
        public static final HostedOptionKey<Boolean> CompactingOldGen = new HostedOptionKey<Boolean>(false, SerialGCOptions::validateCompactingOldGen);
        public static final HostedOptionKey<Boolean> UseRememberedSet = new HostedOptionKey<Boolean>(true, SerialGCOptions::validateSerialHostedOption);
    }

    public static class DeprecatedOptions {
        public static final HostedOptionKey<Boolean> IgnoreMaxHeapSizeWhileInVMOperation = new HostedOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::validateSerialHostedOption){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                IgnoreMaxHeapSizeWhileInVMInternalCode.update(values, newValue);
            }
        };
    }
}

