/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.NotifyGCRuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;

public final class SerialAndEpsilonGCOptions {
    public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(80), SerialAndEpsilonGCOptions::validateSerialOrEpsilonRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(10), SerialAndEpsilonGCOptions::validateSerialOrEpsilonRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(524288L, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);
    public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(131072L, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);
    public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);
    public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);
    public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);
    public static final HostedOptionKey<Integer> HeapChunkHeaderPadding = new HostedOptionKey<Integer>(0, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);
    public static final RuntimeOptionKey<Long> InitialTLABSize = new RuntimeOptionKey<Long>(Long.valueOf(8192L), SerialAndEpsilonGCOptions::validateSerialOrEpsilonRuntimeOption, RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    public static final HostedOptionKey<Boolean> PrintTLAB = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrEpsilonHostedOption);

    private SerialAndEpsilonGCOptions() {
    }

    public static void validateSerialOrEpsilonHostedOption(HostedOptionKey<?> optionKey) {
        if (optionKey.hasBeenSet() && !SubstrateOptions.useSerialGC() && !SubstrateOptions.useEpsilonGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial ('--gc=serial') or the epsilon garbage collector ('--gc=epsilon').", new Object[0]);
        }
    }

    public static void validateSerialOrEpsilonRuntimeOption(RuntimeOptionKey<?> optionKey) {
        if (optionKey.hasBeenSet() && !SubstrateOptions.useSerialGC() && !SubstrateOptions.useEpsilonGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial ('--gc=serial') or the epsilon garbage collector ('--gc=epsilon').", new Object[0]);
        }
    }
}

