/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.image.ImageHeapObject;
import java.nio.ByteBuffer;
import java.util.List;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import sun.nio.ch.DirectBuffer;

public class RuntimeImageHeapChunkWriter
implements ImageHeapChunkWriter {
    private final Pointer heapBegin;
    private final Word layoutToBufferOffsetAddend;

    RuntimeImageHeapChunkWriter(ByteBuffer buffer, long layoutToBufferOffsetAddend) {
        DirectBuffer direct = (DirectBuffer)((Object)buffer);
        this.heapBegin = (Pointer)Word.pointer((long)direct.address());
        this.layoutToBufferOffsetAddend = (Word)Word.signed((long)layoutToBufferOffsetAddend);
    }

    private Pointer getChunkPointerInBuffer(int chunkPosition) {
        return this.heapBegin.add(chunkPosition).add((UnsignedWord)this.layoutToBufferOffsetAddend);
    }

    @Override
    public void initializeAlignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        this.initializeChunk(chunkPosition, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
    }

    @Override
    public void initializeUnalignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk, long objectSize) {
        this.initializeChunk(chunkPosition, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
        UnalignedHeapChunk.UnalignedHeader header = (UnalignedHeapChunk.UnalignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        UnalignedHeapChunk.initializeObjectStartOffset(header, Word.unsigned((long)objectSize));
    }

    private void initializeChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        HeapChunk.Header header = (HeapChunk.Header)this.getChunkPointerInBuffer(chunkPosition);
        header.setTopOffset(Word.unsigned((long)topOffset), HeapChunk.CHUNK_HEADER_TOP_IDENTITY);
        header.setEndOffset(Word.unsigned((long)endOffset));
        header.setSpace(null);
        header.setOffsetToPreviousChunk((SignedWord)Word.unsigned((long)offsetToPreviousChunk));
        header.setOffsetToNextChunk((SignedWord)Word.unsigned((long)offsetToNextChunk));
        header.setIdentityHashSalt((UnsignedWord)Word.zero(), IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION);
    }

    @Override
    public void enableRememberedSetForAlignedChunk(int chunkPosition, List<ImageHeapObject> objects) {
        AlignedHeapChunk.AlignedHeader header = (AlignedHeapChunk.AlignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        RememberedSet.get().enableRememberedSetForChunk(header);
    }

    @Override
    public void enableRememberedSetForUnalignedChunk(int chunkPosition, long objectSize) {
        UnalignedHeapChunk.UnalignedHeader header = (UnalignedHeapChunk.UnalignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        RememberedSet.get().enableRememberedSetForChunk(header);
    }
}

