/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.fieldvaluetransformer;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.fieldvaluetransformer.ObjectToConstantFieldValueTransformer;
import java.lang.reflect.Field;
import java.util.function.Function;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;

public record StaticFieldBaseFieldValueTransformer(Field targetField) implements ObjectToConstantFieldValueTransformer
{
    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    @Override
    public JavaConstant transformToConstant(ResolvedJavaField field, Object receiver, Object originalValue, Function<Object, JavaConstant> toConstant) {
        return StaticFieldsSupport.getStaticFieldsConstant(field, toConstant);
    }

    @Override
    public ValueNode intrinsify(CoreProviders providers, JavaConstant receiver) {
        return StaticFieldsSupport.createStaticFieldBaseNode(providers.getMetaAccess().lookupJavaField(this.targetField));
    }
}

