/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.deopt.DeoptState;
import com.oracle.svm.core.deopt.Deoptimizer;
import java.lang.reflect.Array;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.word.UnsignedWord;

public class VectorAPIDeoptimizationSupport {
    private final EconomicMap<Class<?>, PayloadLayout> typeMap = EconomicMap.create();

    public Object materializePayload(DeoptState deoptState, PayloadLayout layout, FrameInfoQueryResult.ValueInfo vectorEncoding, FrameInfoQueryResult sourceFrame) {
        JavaKind elementKind = JavaKind.fromJavaClass(layout.elementType);
        Object array = Array.newInstance(layout.elementType, layout.vectorLength);
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        UnsignedWord curOffset = Word.unsigned((int)objectLayout.getArrayBaseOffset(elementKind));
        for (int i = 0; i < layout.vectorLength; ++i) {
            FrameInfoQueryResult.ValueInfo elementEncoding = vectorEncoding.copyForElement(elementKind, i * elementKind.getByteCount());
            JavaConstant con = VectorAPIDeoptimizationSupport.readValue(deoptState, elementEncoding, sourceFrame);
            VectorAPIDeoptimizationSupport.writeValueInMaterializedObj(array, curOffset, con, sourceFrame);
            curOffset = curOffset.add(objectLayout.sizeInBytes(elementKind));
        }
        return array;
    }

    protected static JavaConstant readValue(DeoptState deoptState, FrameInfoQueryResult.ValueInfo valueInfo, FrameInfoQueryResult sourceFrame) {
        return deoptState.readValue(valueInfo, sourceFrame);
    }

    protected static void writeValueInMaterializedObj(Object materializedObj, UnsignedWord offsetInObj, JavaConstant constant, FrameInfoQueryResult frameInfo) {
        Deoptimizer.writeValueInMaterializedObj(materializedObj, offsetInObj, constant, frameInfo);
    }

    public void putLayout(Class<?> vectorClass, PayloadLayout layout) {
        this.typeMap.put(vectorClass, (Object)layout);
    }

    public PayloadLayout getLayout(Class<?> vectorClass) {
        return (PayloadLayout)this.typeMap.get(vectorClass);
    }

    public record PayloadLayout(Class<?> elementType, int vectorLength) {
    }
}

