/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.dcmd.DCmdOption;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.nio.charset.StandardCharsets;
import jdk.internal.vm.ThreadDumper;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/hotspot/share/services/diagnosticCommand.hpp#L757-L777")
public class ThreadDumpToFileDCmd
extends AbstractDCmd {
    private static final DCmdOption<String> FILEPATH = new DCmdOption<Object>(String.class, "filepath", "The file path to the output file", true, null);
    private static final DCmdOption<Boolean> OVERWRITE = new DCmdOption<Boolean>(Boolean.class, "-overwrite", "May overwrite existing file", false, false);
    private static final DCmdOption<String> FORMAT = new DCmdOption<String>(String.class, "-format", "Output format (\"plain\" or \"json\")", false, "plain");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ThreadDumpToFileDCmd() {
        super("Thread.dump_to_file", "Dump threads, with stack traces, to a file in plain text or JSON format.", DCmd.Impact.Medium, new DCmdOption[]{FILEPATH}, new DCmdOption[]{OVERWRITE, FORMAT}, new String[]{"$ jcmd <pid> Thread.dump_to_file /some/path/my_file.txt", "$ jcmd <pid> Thread.dump_to_file -format=json -overwrite=true /some/path/my_file.json"});
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/hotspot/share/services/diagnosticCommand.cpp#L1062-L1106")
    public String execute(DCmdArguments args) throws Throwable {
        String path = args.get(FILEPATH);
        boolean overwrite = args.get(OVERWRITE);
        boolean useJson = "json".equals(args.get(FORMAT));
        byte[] reply = ThreadDumpToFileDCmd.dumpThreads(useJson, path, overwrite);
        return new String(reply, StandardCharsets.UTF_8);
    }

    private static byte[] dumpThreads(boolean useJson, String path, boolean overwrite) {
        if (useJson) {
            return ThreadDumper.dumpThreadsToJson(path, overwrite);
        }
        return ThreadDumper.dumpThreads(path, overwrite);
    }
}

