/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.dcmd.CompilerDumpCodeCacheDCmd;
import com.oracle.svm.core.dcmd.DCmdSupport;
import com.oracle.svm.core.dcmd.GCHeapDumpDCmd;
import com.oracle.svm.core.dcmd.GCRunDCmd;
import com.oracle.svm.core.dcmd.HelpDCmd;
import com.oracle.svm.core.dcmd.JfrCheckDCmd;
import com.oracle.svm.core.dcmd.JfrDumpDCmd;
import com.oracle.svm.core.dcmd.JfrStartDCmd;
import com.oracle.svm.core.dcmd.JfrStopDCmd;
import com.oracle.svm.core.dcmd.ThreadDumpToFileDCmd;
import com.oracle.svm.core.dcmd.ThreadPrintDCmd;
import com.oracle.svm.core.dcmd.VMCommandLineDCmd;
import com.oracle.svm.core.dcmd.VMNativeMemoryDCmd;
import com.oracle.svm.core.dcmd.VMSystemPropertiesDCmd;
import com.oracle.svm.core.dcmd.VMUptimeDmd;
import com.oracle.svm.core.dcmd.VMVersionDmd;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.RuntimeCompilation;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class DCmdFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspectionOptions.hasJCmdSupport();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        DCmdSupport dcmdSupport = new DCmdSupport();
        ImageSingletons.add(DCmdSupport.class, (Object)dcmdSupport);
        if (VMInspectionOptions.hasHeapDumpSupport()) {
            dcmdSupport.registerCommand(new GCHeapDumpDCmd());
        }
        dcmdSupport.registerCommand(new GCRunDCmd());
        if (VMInspectionOptions.hasJfrSupport()) {
            dcmdSupport.registerCommand(new JfrStartDCmd());
            dcmdSupport.registerCommand(new JfrStopDCmd());
            dcmdSupport.registerCommand(new JfrCheckDCmd());
            dcmdSupport.registerCommand(new JfrDumpDCmd());
        }
        dcmdSupport.registerCommand(new ThreadDumpToFileDCmd());
        dcmdSupport.registerCommand(new ThreadPrintDCmd());
        if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
            dcmdSupport.registerCommand(new VMCommandLineDCmd());
        }
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            dcmdSupport.registerCommand(new VMNativeMemoryDCmd());
        }
        if (RuntimeCompilation.isEnabled()) {
            dcmdSupport.registerCommand(new CompilerDumpCodeCacheDCmd());
        }
        dcmdSupport.registerCommand(new VMSystemPropertiesDCmd());
        dcmdSupport.registerCommand(new VMUptimeDmd());
        dcmdSupport.registerCommand(new VMVersionDmd());
        dcmdSupport.registerCommand(new HelpDCmd());
    }
}

