/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.nmt.NmtCategory;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public class InstantReferenceAdjuster
implements ReferenceAdjuster {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setObjectInArray(NonmovableObjectArray<T> array, int index, T object) {
        NonmovableArrays.setObject(array, index, object);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setConstantTargetInArray(NonmovableObjectArray<T> array, int index, JavaConstant constant) {
        NonmovableArrays.setObject(array, index, this.getObject(constant));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setConstantTargetAt(PointerBase address, int length, JavaConstant constant) {
        ReferenceAdjuster.writeReference((Pointer)address, length, this.getObject(constant));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> NonmovableObjectArray<T> copyOfObjectArray(T[] source, NmtCategory nmtCategory) {
        return NonmovableArrays.copyOfObjectArray(source, nmtCategory);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isFinished() {
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Object getObject(JavaConstant constant) {
        return ((DirectSubstrateObjectConstant)constant).getObject();
    }
}

