/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import java.util.EnumSet;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;

public class ImageCodeInfoStorage
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    private final byte[] data;
    static final int ALIGNMENT = 8;

    ImageCodeInfoStorage(int dataSize) {
        this.data = new byte[dataSize];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static CodeInfoImpl get() {
        return ((ImageCodeInfoStorage)ImageSingletons.lookup(ImageCodeInfoStorage.class)).getData();
    }

    @Fold
    protected static UnsignedWord offset() {
        return Word.unsigned((int)ImageCodeInfoStorage.calculateOffset());
    }

    static int calculateOffset() {
        return NumUtil.roundUp((int)ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte), (int)8);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    CodeInfoImpl getData() {
        Word base = Word.objectToUntrackedPointer((Object)this.data).add(ImageCodeInfoStorage.offset());
        return (CodeInfoImpl)base;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.RUNTIME_ACCESS_ONLY;
    }
}

