/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.util.NonmovableByteArrayTypeReader;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CodePointer;

public class DeoptimizationSourcePositionDecoder {
    static final int NO_SOURCE_POSITION = -1;
    static final int NO_CALLER = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    public static NodeSourcePosition decode(int deoptId, CodePointer ip) {
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNull() || UntetheredCodeInfoAccess.isAOTImageCode(untetheredInfo)) {
            return null;
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            NodeSourcePosition nodeSourcePosition = DeoptimizationSourcePositionDecoder.decode0(deoptId, info);
            return nodeSourcePosition;
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly decode the source position.", calleeMustBe=false)
    private static NodeSourcePosition decode0(int deoptId, CodeInfo info) {
        return DeoptimizationSourcePositionDecoder.decode(deoptId, CodeInfoAccess.getDeoptimizationStartOffsets(info), CodeInfoAccess.getDeoptimizationEncodings(info), CodeInfoAccess.getDeoptimizationObjectConstants(info));
    }

    static NodeSourcePosition decode(int deoptId, NonmovableArray<Integer> deoptimizationStartOffsets, NonmovableArray<Byte> deoptimizationEncodings, NonmovableObjectArray<Object> deoptimizationObjectConstants) {
        if (deoptId < 0 || deoptId >= NonmovableArrays.lengthOf(deoptimizationStartOffsets)) {
            return null;
        }
        int startOffset = NonmovableArrays.getInt(deoptimizationStartOffsets, deoptId);
        if (startOffset == -1) {
            return null;
        }
        NonmovableByteArrayTypeReader readBuffer = new NonmovableByteArrayTypeReader(deoptimizationEncodings, 0L);
        return DeoptimizationSourcePositionDecoder.decodeSourcePosition(startOffset, deoptimizationObjectConstants, readBuffer);
    }

    private static NodeSourcePosition decodeSourcePosition(long startOffset, NonmovableObjectArray<Object> deoptimizationObjectConstants, NonmovableByteArrayTypeReader readBuffer) {
        readBuffer.setByteIndex(startOffset);
        long callerRelativeOffset = readBuffer.getUV();
        int bci = readBuffer.getSVInt();
        ResolvedJavaMethod method = (ResolvedJavaMethod)NonmovableArrays.getObject(deoptimizationObjectConstants, readBuffer.getUVInt());
        NodeSourcePosition caller = null;
        if (callerRelativeOffset != 0L) {
            caller = DeoptimizationSourcePositionDecoder.decodeSourcePosition(startOffset - callerRelativeOffset, deoptimizationObjectConstants, readBuffer);
        }
        return new NodeSourcePosition(caller, method, bci);
    }
}

