/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public final class CEntryPointBuiltins {
    private static final String UNINTERRUPTIBLE_REASON = "Unsafe state in case of failure";

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @CEntryPointBuiltinImplementation(builtin=CEntryPoint.Builtin.CREATE_ISOLATE)
    public static IsolateThread createIsolate() {
        int status = CEntryPointActions.enterCreateIsolate((CEntryPointCreateIsolateParameters)Word.nullPointer());
        if (status != 0) {
            return (IsolateThread)Word.nullPointer();
        }
        IsolateThread result = CurrentIsolate.getCurrentThread();
        CEntryPointActions.leave();
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @CEntryPointBuiltinImplementation(builtin=CEntryPoint.Builtin.ATTACH_THREAD)
    public static IsolateThread attachThread(Isolate isolate) {
        int status = CEntryPointActions.enterAttachThread(isolate, false, true);
        if (status != 0) {
            return (IsolateThread)Word.nullPointer();
        }
        IsolateThread result = CurrentIsolate.getCurrentThread();
        CEntryPointActions.leave();
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @CEntryPointBuiltinImplementation(builtin=CEntryPoint.Builtin.GET_CURRENT_THREAD)
    public static IsolateThread getCurrentThread(Isolate isolate) {
        int status = CEntryPointActions.enterByIsolate(isolate);
        if (status != 0) {
            return (IsolateThread)Word.nullPointer();
        }
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        CEntryPointActions.leave();
        return thread;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @CEntryPointBuiltinImplementation(builtin=CEntryPoint.Builtin.GET_ISOLATE)
    public static Isolate getIsolate(IsolateThread thread) {
        int status = CEntryPointActions.enter(thread);
        if (status != 0) {
            return (Isolate)Word.nullPointer();
        }
        Isolate isolate = CurrentIsolate.getIsolate();
        CEntryPointActions.leave();
        return isolate;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @CEntryPointBuiltinImplementation(builtin=CEntryPoint.Builtin.DETACH_THREAD)
    public static int detachThread(IsolateThread thread) {
        int status = CEntryPointActions.enter(thread);
        if (status != 0) {
            return status;
        }
        return CEntryPointActions.leaveDetachThread();
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @CEntryPointBuiltinImplementation(builtin=CEntryPoint.Builtin.TEAR_DOWN_ISOLATE)
    public static int tearDownIsolate(IsolateThread isolateThread) {
        int result = CEntryPointActions.enter(isolateThread);
        if (result != 0) {
            return result;
        }
        return CEntryPointActions.leaveTearDownIsolate();
    }

    private CEntryPointBuiltins() {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface CEntryPointBuiltinImplementation {
        public CEntryPoint.Builtin builtin() default CEntryPoint.Builtin.NO_BUILTIN;
    }
}

