/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.attach;

import com.oracle.svm.core.attach.AttachApiSupport;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdSupport;
import com.oracle.svm.core.jni.headers.JNIErrors;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class AttachListenerThread
extends Thread {
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.hpp#L176-L178")
    protected static final int ATTACH_ERROR_BAD_VERSION = 101;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.hpp#L171")
    protected static final int NAME_LENGTH_MAX_V1 = 16;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.hpp#L172")
    protected static final int ARG_LENGTH_MAX_V1 = 1024;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.hpp#L173")
    protected static final int ARG_COUNT_MAX_V1 = 3;
    private static final String JCMD_COMMAND_STRING = "jcmd";

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L668-L682")
    public AttachListenerThread() {
        super(PlatformThreads.singleton().systemGroup, "Attach Listener");
        this.setDaemon(true);
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L586-L651")
    public void run() {
        try {
            while (true) {
                AttachOperation op;
                if ((op = this.dequeue()) == null) {
                    AttachApiSupport.singleton().shutdown(false);
                    return;
                }
                if (JCMD_COMMAND_STRING.equals(op.name)) {
                    AttachListenerThread.handleJcmd(op);
                    continue;
                }
                op.complete(JNIErrors.JNI_ERR(), "Invalid Operation. Only jcmd is supported currently.");
            }
        }
        catch (Throwable e) {
            VMError.shouldNotReachHere("Exception in attach listener thread", e);
            return;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L364-L410")
    private static void handleJcmd(AttachOperation op) {
        try {
            String response = AttachListenerThread.parseAndExecute(op.getArguments().getFirst());
            op.complete(JNIErrors.JNI_OK(), response);
        }
        catch (Throwable e) {
            AttachListenerThread.handleException(op, e);
        }
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/diagnosticFramework.cpp#L382-L418"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/diagnosticFramework.cpp#L429-L446")})
    private static String parseAndExecute(String input) throws Throwable {
        String[] args = StringUtil.split((String)input, (String)" ");
        String cmdName = args[0];
        for (int i = 1; i < args.length; ++i) {
            String v = args[i];
            if (!"-h".equals(v) && !"--help".equals(v) && !"-help".equals(v)) continue;
            DCmd cmd = DCmdSupport.singleton().getCommand("help");
            return cmd.parseAndExecute("help " + cmdName);
        }
        DCmd cmd = DCmdSupport.singleton().getCommand(cmdName);
        if (cmd == null) {
            throw new IllegalArgumentException("Unknown diagnostic command '" + cmdName + "'");
        }
        return cmd.parseAndExecute(input);
    }

    private static void handleException(AttachOperation op, Throwable e) {
        if (!Options.JCmdExceptionStackTrace.getValue().booleanValue()) {
            op.complete(JNIErrors.JNI_ERR(), e.toString());
            return;
        }
        StringWriter s = new StringWriter();
        e.printStackTrace(new PrintWriter(s));
        op.complete(JNIErrors.JNI_OK(), s.toString());
    }

    protected abstract AttachOperation dequeue();

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L845-L906")
    protected static AttachOperation readRequest(AttachSocketChannel channel) {
        int minStrCount;
        int bufferSize;
        int ver = AttachListenerThread.readInt(channel);
        if (ver < 0) {
            return null;
        }
        int minReadSize = 1;
        switch (ver) {
            case 1: {
                bufferSize = 3092;
                minStrCount = 4;
                break;
            }
            case 2: {
                channel.writeReply(101, "v2 is unsupported");
                return null;
            }
            default: {
                channel.writeReply(101, "unknown version");
                return null;
            }
        }
        AttachOperation op = AttachListenerThread.readRequestData(channel, bufferSize, minStrCount, minReadSize);
        if (op != null && ver == 1) {
            if (op.getName().length() > 16) {
                return null;
            }
            for (String arg : op.getArguments()) {
                if (arg.length() <= 1024) continue;
                return null;
            }
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L735-L803")
    private static AttachOperation readRequestData(AttachSocketChannel channel, int bufferSize, int minStringCount, int minReadSize) {
        Pointer buffer = (Pointer)NativeMemory.malloc(bufferSize, NmtCategory.Serviceability);
        try {
            AttachOperation attachOperation = AttachListenerThread.readRequestData0(channel, buffer, bufferSize, minStringCount, minReadSize);
            return attachOperation;
        }
        finally {
            NativeMemory.free((PointerBase)buffer);
        }
    }

    private static AttachOperation readRequestData0(AttachSocketChannel channel, Pointer buffer, int bufferSize, int minStringCount, int minReadSize) {
        int n;
        int strCount = 0;
        int offset = 0;
        int left = bufferSize;
        do {
            if ((n = channel.read((PointerBase)buffer.add(offset), left)) < 0) {
                return null;
            }
            if (n == 0) break;
            if (minStringCount <= 0) continue;
            for (int i = 0; i < n; ++i) {
                if (buffer.readByte(offset + i) != 0) continue;
                ++strCount;
            }
        } while ((left -= n) > 0 && ((offset += n) < minReadSize || strCount < minStringCount));
        if (offset < minReadSize || strCount < minStringCount) {
            return null;
        }
        if (buffer.readByte(offset - 1) != 0) {
            return null;
        }
        ArrayList<String> values = AttachListenerThread.decodeStrings(buffer, buffer.add(offset));
        return AttachListenerThread.createAttachOperation(channel, values);
    }

    private static ArrayList<String> decodeStrings(Pointer dataStart, Pointer dataEnd) {
        ArrayList<String> result = new ArrayList<String>(4);
        Pointer currentStart = dataStart;
        Pointer pos = dataStart;
        while (pos.belowThan((UnsignedWord)dataEnd)) {
            if (pos.readByte(0) == 0) {
                String s = AttachListenerThread.decodeString(currentStart, pos);
                result.add(s);
                currentStart = pos.add(1);
            }
            pos = pos.add(1);
        }
        return result;
    }

    private static String decodeString(Pointer start, Pointer end) {
        assert (end.aboveOrEqual((UnsignedWord)start));
        Pointer length = end.subtract((UnsignedWord)start);
        return CTypeConversion.toJavaString((CCharPointer)((CCharPointer)start), (UnsignedWord)length, (Charset)StandardCharsets.UTF_8);
    }

    private static AttachOperation createAttachOperation(AttachSocketChannel channel, ArrayList<String> values) {
        String name;
        String nameAndOptions = values.getFirst();
        int optionStart = nameAndOptions.indexOf(32);
        if (optionStart != -1) {
            name = nameAndOptions.substring(0, optionStart);
            AttachListenerThread.parseOptions();
        } else {
            name = nameAndOptions;
        }
        List<String> args = values.subList(1, values.size());
        return new AttachOperation(channel, name, args);
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L805-L820"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L822-L843")})
    private static void parseOptions() {
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L704-L733")
    private static int readInt(AttachSocketChannel channel) {
        int maxValue = 0x6666666;
        CCharPointer chPtr = (CCharPointer)StackValue.get(CCharPointer.class);
        int value = 0;
        int n;
        while ((n = channel.read((PointerBase)chPtr, 1)) == 1) {
            byte ch = chPtr.read();
            if (ch == 0) {
                return value;
            }
            if (ch < 48 || ch > 57) {
                return -1;
            }
            if (value >= maxValue) {
                return -1;
            }
            value = value * 10 + (ch - 48);
        }
        return -1;
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.hpp#L167-L304"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L141-L158")})
    public static class AttachOperation {
        private final AttachSocketChannel channel;
        private final String name;
        private final List<String> args;

        public AttachOperation(AttachSocketChannel channel, String name, List<String> args) {
            this.channel = channel;
            this.name = name;
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getArguments() {
            return this.args;
        }

        @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L323-L325"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L107-L109")})
        public void complete(int result, String message) {
            this.channel.writeReply(result, message);
            this.channel.close();
        }
    }

    static class Options {
        public static final RuntimeOptionKey<Boolean> JCmdExceptionStackTrace = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);

        Options() {
        }
    }

    public static abstract class AttachSocketChannel {
        public abstract int read(PointerBase var1, int var2);

        @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L921-L934")
        public void writeReply(int result, String message) {
            byte[] lineBreak = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
            byte[] returnCodeData = Integer.toString(result).getBytes(StandardCharsets.UTF_8);
            this.write(returnCodeData);
            this.write(lineBreak);
            if (message != null && !message.isEmpty()) {
                byte[] responseBytes = message.getBytes(StandardCharsets.UTF_8);
                this.write(responseBytes);
                this.write(lineBreak);
            }
        }

        @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.cpp#L908-L919")
        protected abstract void write(byte[] var1);

        public abstract void close();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/share/services/attachListener.hpp#L71-L74")
    private static interface Version {
        public static final int V1 = 1;
        public static final int V2 = 2;
    }
}

