/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.amd64;

import com.oracle.svm.core.CPUFeatureAccessImpl;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.amd64.AMD64LibCHelper;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.JVMCISubstitutions;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.graal.compiler.vector.architecture.VectorLoweringProvider;
import jdk.graal.compiler.vector.architecture.amd64.VectorAMD64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;

public class AMD64CPUFeatureAccess
extends CPUFeatureAccessImpl {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AMD64CPUFeatureAccess(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        super(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }

    @Platforms(value={Platform.AMD64.class})
    public EnumSet<AMD64.CPUFeature> determineHostCPUFeatures() {
        EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
        AMD64LibCHelper.CPUFeatures cpuFeatures = UnsafeStackValue.get(AMD64LibCHelper.CPUFeatures.class);
        UnmanagedMemoryUtil.fill((Pointer)cpuFeatures, SizeOf.unsigned(AMD64LibCHelper.CPUFeatures.class), (byte)0);
        AMD64LibCHelper.determineCPUFeatures(cpuFeatures);
        ArrayList<String> unknownFeatures = new ArrayList<String>();
        for (AMD64.CPUFeature feature : AMD64.CPUFeature.values()) {
            if (!this.isFeaturePresent((Enum<?>)feature, (Pointer)cpuFeatures, (List<String>)unknownFeatures)) continue;
            features.add(feature);
        }
        if (!unknownFeatures.isEmpty()) {
            throw VMError.shouldNotReachHere("Native image does not support the following JVMCI CPU features: " + String.valueOf(unknownFeatures));
        }
        return features;
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public int verifyHostSupportsArchitectureEarly() {
        return AMD64LibCHelper.checkCPUFeatures((CCharPointer)BUILDTIME_CPU_FEATURE_MASK.get());
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public void verifyHostSupportsArchitectureEarlyOrExit() {
        AMD64LibCHelper.checkCPUFeaturesOrExit((CCharPointer)BUILDTIME_CPU_FEATURE_MASK.get(), (CCharPointer)IMAGE_CPU_FEATURE_ERROR_MSG.get());
    }

    public static boolean canUpdateCPUFeatures() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    @Override
    public void enableFeatures(Architecture runtimeArchitecture, LoweringProvider runtimeLowerer) {
        if (!AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
            return;
        }
        AMD64 architecture = (AMD64)runtimeArchitecture;
        EnumSet<AMD64.CPUFeature> features = this.determineHostCPUFeatures();
        architecture.getFeatures().addAll(features);
        AMD64Kind largestStorableKind = new AMD64(features).getLargestStorableKind(AMD64.XMM);
        JVMCISubstitutions.updateLargestStorableKind(architecture, largestStorableKind);
        AMD64Kind largestStorableMaskKind = new AMD64(features).getLargestStorableKind(AMD64.MASK);
        JVMCISubstitutions.updateLargestStorableMaskKind(architecture, largestStorableMaskKind);
        VectorAMD64 initialVectorArch = (VectorAMD64)((VectorLoweringProvider)runtimeLowerer).getVectorArchitecture();
        initialVectorArch.updateForRuntimeArchitecture((AMD64)runtimeArchitecture);
    }
}

