/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.common.meta.GuaranteeFolded;
import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.HostedSubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.StringUtil;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.util.Digest;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class SubstrateUtil {
    @GuaranteeFolded
    public static final boolean HOSTED = true;
    private static final Pattern SAFE_SHELL_ARG = Pattern.compile("[A-Za-z0-9@%_\\-+=:,./]+");
    private static Field classLoaderNameAndId = ReflectionUtil.lookupField(ClassLoader.class, (String)"nameAndId");

    public static String getArchitectureName() {
        String arch;
        return switch (arch = System.getProperty("os.arch")) {
            case "x86_64" -> "amd64";
            case "arm64" -> "aarch64";
            default -> arch;
        };
    }

    private static boolean isTTY() {
        Console console = System.console();
        if (console == null) {
            return false;
        }
        return console.isTerminal();
    }

    public static boolean isNonInteractiveTerminal() {
        return SubstrateUtil.isCISetToTrue() || !SubstrateUtil.isTTY();
    }

    public static boolean isCISetToTrue() {
        return Boolean.parseBoolean(System.getenv("CI"));
    }

    public static String quoteShellArg(String arg) {
        if (arg.isEmpty()) {
            return "''";
        }
        Matcher m = SAFE_SHELL_ARG.matcher(arg);
        if (m.matches()) {
            return arg;
        }
        return "'" + arg.replace("'", "'\"'\"'") + "'";
    }

    public static String getShellCommandString(List<String> cmd, boolean multiLine) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmd.size(); ++i) {
            if (i > 0) {
                sb.append(multiLine ? " \\\n" : " ");
            }
            sb.append(SubstrateUtil.quoteShellArg(cmd.get(i)));
        }
        return sb.toString();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static FileDescriptor getFileDescriptor(FileOutputStream out) {
        return SubstrateUtil.cast((Object)out, Target_java_io_FileOutputStream.class).fd;
    }

    public static String[] convertCToJavaArgs(int argc, CCharPointerPointer argv) {
        String[] args = new String[argc - 1];
        for (int i = 1; i < argc; ++i) {
            args[i - 1] = CTypeConversion.toJavaString((CCharPointer)argv.read(i));
        }
        return args;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord strlen(CCharPointer str) {
        UnsignedWord n = (UnsignedWord)Word.zero();
        while (((Pointer)str).readByte((WordBase)n) != 0) {
            n = n.add(1);
        }
        return n;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CCharPointer strchr(CCharPointer str, int c) {
        int index = 0;
        byte b;
        while ((b = str.read(index)) != c) {
            if (b == 0) {
                return (CCharPointer)Word.zero();
            }
            ++index;
        }
        return str.addressOf(index);
    }

    @AlwaysInline(value="Some callers rely on this never becoming an actual method call.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> T cast(Object obj, Class<T> toType) {
        return (T)obj;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean assertionsEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    @Node.NodeIntrinsic(value=BreakpointNode.class)
    public static native void breakpoint(Object var0);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }

    public static String[] split(String value, String separator) {
        return SubstrateUtil.split(value, separator, 0);
    }

    public static String[] split(String value, String separator, int limit) {
        return StringUtil.split((String)value, (String)separator, (int)limit);
    }

    public static String uniqueShortName(ResolvedJavaMethod m) {
        return UniqueShortNameProvider.singleton().uniqueShortName(null, m.getDeclaringClass(), m.getName(), m.getSignature(), m.isConstructor());
    }

    public static String uniqueShortName(ClassLoader loader, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        return UniqueShortNameProvider.singleton().uniqueShortName(loader, declaringClass, methodName, methodSignature, isConstructor);
    }

    public static String uniqueShortName(Member m) {
        return UniqueShortNameProvider.singleton().uniqueShortName(m);
    }

    public static String uniqueStubName(ResolvedJavaMethod m) {
        return SubstrateUtil.defaultUniqueShortName("", m.getDeclaringClass(), m.getName(), m.getSignature(), m.isConstructor());
    }

    public static String defaultUniqueShortName(String loaderNameAndId, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        StringBuilder sb = new StringBuilder(loaderNameAndId);
        sb.append(declaringClass.toClassName()).append(".").append(methodName).append("(");
        for (int i = 0; i < methodSignature.getParameterCount(false); ++i) {
            sb.append(methodSignature.getParameterType(i, null).toClassName()).append(",");
        }
        sb.append(')');
        if (!isConstructor) {
            sb.append(methodSignature.getReturnType(null).toClassName());
        }
        return SubstrateUtil.shortenClassName(SubstrateUtil.stripPackage(declaringClass.toJavaName())) + "_" + (String)(isConstructor ? "" : SubstrateUtil.stripExistingDigest(methodName) + "_") + Digest.digest((String)sb.toString());
    }

    public static String defaultUniqueShortName(Member m) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(m.getDeclaringClass().getName()).append(".");
        if (m instanceof Constructor) {
            fullName.append("<init>");
        } else {
            fullName.append(m.getName());
        }
        if (m instanceof Executable) {
            fullName.append("(");
            for (Class<?> c : ((Executable)m).getParameterTypes()) {
                fullName.append(c.getName()).append(",");
            }
            fullName.append(')');
            if (m instanceof Method) {
                fullName.append(((Method)m).getReturnType().getName());
            }
        }
        return SubstrateUtil.shortenClassName(SubstrateUtil.stripPackage(m.getDeclaringClass().getTypeName())) + "_" + (String)(m instanceof Constructor ? "" : SubstrateUtil.stripExistingDigest(m.getName()) + "_") + Digest.digest((String)fullName.toString());
    }

    public static String runtimeClassLoaderNameAndId(ClassLoader loader) {
        ClassLoader runtimeClassLoader;
        ClassLoader classLoader = runtimeClassLoader = HOSTED ? HostedSubstrateUtil.getRuntimeClassLoader(loader) : loader;
        if (runtimeClassLoader == null) {
            return "";
        }
        try {
            return (String)classLoaderNameAndId.get(runtimeClassLoader);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere("Cannot reflectively access ClassLoader.nameAndId");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String mangleName(String methodName) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < methodName.length(); ++i) {
            char c = methodName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i == 0 && c == '.' || i > 0 && c >= '0' && c <= '9') {
                out.append(c);
                continue;
            }
            if (c == '_') {
                out.append("__");
                continue;
            }
            out.append('_');
            out.append(String.format("%04x", c));
        }
        String mangled = out.toString();
        assert (mangled.matches("[a-zA-Z\\._][a-zA-Z0-9_]*")) : mangled;
        return mangled;
    }

    public static int arrayTypeDimension(Class<?> clazz) {
        int dimension = 0;
        Class<?> componentType = clazz;
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
            ++dimension;
        }
        return dimension;
    }

    public static int arrayTypeDimension(ResolvedJavaType arrayType) {
        int dimension = 0;
        ResolvedJavaType componentType = arrayType;
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
            ++dimension;
        }
        return dimension;
    }

    public static String stripPackage(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1).replace("/", "");
    }

    public static UUID getUUIDFromString(String value) {
        return Digest.digestAsUUID((String)value);
    }

    private static String shortenClassName(String className) {
        Object result = className;
        int lambdaStart = ((String)result).indexOf("$$Lambda");
        if (lambdaStart != -1) {
            int start = lambdaStart + "$$Lambda".length() + ".0x".length();
            int keepHashLen = 8;
            if (((String)result).length() > start + keepHashLen) {
                result = ((String)result).substring(0, lambdaStart) + "$$L" + ((String)result).substring(start, start + keepHashLen);
            }
        }
        int maxLen = 40;
        if (((String)result).length() > maxLen) {
            result = ((String)result).substring(((String)result).length() - maxLen, ((String)result).length());
        }
        return result;
    }

    private static String stripExistingDigest(String name) {
        int digestLength = 23;
        if (name.length() > digestLength && name.charAt(name.length() - digestLength) == '_') {
            return name.substring(0, name.length() - digestLength);
        }
        return name;
    }

    public static Class<?> toUnboxedClass(Class<?> clazz) {
        return SubstrateUtil.toUnboxedClassWithDefault(clazz, clazz);
    }

    public static Class<?> toUnboxedClassWithDefault(Class<?> clazz, Class<?> defaultClass) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return defaultClass;
    }

    public static String sanitizeForFileName(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c >= '0' && c <= '9') {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    @TargetClass(value=FileOutputStream.class)
    static final class Target_java_io_FileOutputStream {
        @Alias
        FileDescriptor fd;

        Target_java_io_FileOutputStream() {
        }
    }

    @FunctionalInterface
    public static interface Thunk {
        public void invoke();
    }

    @TargetClass(value=SubstrateUtil.class)
    static final class Target_com_oracle_svm_core_SubstrateUtil {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias, isFinal=true)
        private static boolean HOSTED = false;

        Target_com_oracle_svm_core_SubstrateUtil() {
        }
    }
}

