/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.ReplacingLocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class SubstrateOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(SubstrateOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "AOTInline": {
                return OptionDescriptor.create((String)"AOTInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated", (Object)this.getContainer(), SubstrateOptions.AOTInline, (String)"AOTInline", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "AOTTrivialInline": {
                return OptionDescriptor.create((String)"AOTTrivialInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform trivial method inlining in the AOT compiled native image", (Object)this.getContainer(), SubstrateOptions.AOTTrivialInline, (String)"AOTTrivialInline", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "APIFunctionPrefix": {
                return OptionDescriptor.create((String)"APIFunctionPrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of API functions.", (Object)this.getContainer(), SubstrateOptions.APIFunctionPrefix, (String)"APIFunctionPrefix", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "AbortOnNameConflict": {
                return OptionDescriptor.create((String)"AbortOnNameConflict", (OptionType)OptionType.Debug, Boolean.class, (String)"Throws an exception on potential type conflict during heap persisting if enabled", (Object)this.getContainer(), SubstrateOptions.AbortOnNameConflict, (String)"AbortOnNameConflict", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ActiveProcessorCount": {
                return OptionDescriptor.create((String)"ActiveProcessorCount", (OptionType)OptionType.Debug, Integer.class, (String)"Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.", (Object)this.getContainer(), SubstrateOptions.ActiveProcessorCount, (String)"ActiveProcessorCount", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AdditionalHeaderBytes": {
                return OptionDescriptor.create((String)"AdditionalHeaderBytes", (OptionType)OptionType.Debug, Integer.class, (String)"Add additional header bytes to each object, for diagnostic purposes.", (Object)this.getContainer(), SubstrateOptions.AdditionalHeaderBytes, (String)"AdditionalHeaderBytes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocateInstancePrefetchLines": {
                return OptionDescriptor.create((String)"AllocateInstancePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the object address using prefetch instructions.", (Object)this.getContainer(), SubstrateOptions.AllocateInstancePrefetchLines, (String)"AllocateInstancePrefetchLines", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchDistance": {
                return OptionDescriptor.create((String)"AllocatePrefetchDistance", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.", (Object)this.getContainer(), SubstrateOptions.AllocatePrefetchDistance, (String)"AllocatePrefetchDistance", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchInstr": {
                return OptionDescriptor.create((String)"AllocatePrefetchInstr", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.", (Object)this.getContainer(), SubstrateOptions.AllocatePrefetchInstr, (String)"AllocatePrefetchInstr", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchLines": {
                return OptionDescriptor.create((String)"AllocatePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the array allocation using prefetch instructions.", (Object)this.getContainer(), SubstrateOptions.AllocatePrefetchLines, (String)"AllocatePrefetchLines", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStepSize": {
                return OptionDescriptor.create((String)"AllocatePrefetchStepSize", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the step size (in bytes) for sequential prefetch instructions.", (Object)this.getContainer(), SubstrateOptions.AllocatePrefetchStepSize, (String)"AllocatePrefetchStepSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllowDeprecatedBuilderClassesOnImageClasspath": {
                return OptionDescriptor.create((String)"AllowDeprecatedBuilderClassesOnImageClasspath", (OptionType)OptionType.Debug, Boolean.class, (String)"Instead of abort, only warn if image builder classes are found on the image class-path.", (Object)this.getContainer(), SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath, (String)"AllowDeprecatedBuilderClassesOnImageClasspath", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"This option was introduced to simplify migration to GraalVM 23.0 and will be removed in a future release");
            }
            case "AllowUnsafeAllocationOfAllInstantiatedTypes": {
                return OptionDescriptor.create((String)"AllowUnsafeAllocationOfAllInstantiatedTypes", (OptionType)OptionType.Expert, Boolean.class, (String)"Allow all instantiated types to be allocated via Unsafe.allocateInstance().", (Object)this.getContainer(), SubstrateOptions.AllowUnsafeAllocationOfAllInstantiatedTypes, (String)"AllowUnsafeAllocationOfAllInstantiatedTypes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"ThrowMissingRegistrationErrors is the preferred way of configuring this on a per-type level.");
            }
            case "AllowVMInternalThreads": {
                return OptionDescriptor.create((String)"AllowVMInternalThreads", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM internal threads (e.g., a dedicated VM operation or reference handling thread) are allowed in this image.", (Object)this.getContainer(), SubstrateOptions.AllowVMInternalThreads, (String)"AllowVMInternalThreads", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ApplicationLayerInitializedClasses": {
                return OptionDescriptor.create((String)"ApplicationLayerInitializedClasses", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Register class as being initialized in the app layer.", (Object)this.getContainer(), SubstrateOptions.ApplicationLayerInitializedClasses, (String)"ApplicationLayerInitializedClasses", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ApplicationLayerOnlySingletons": {
                return OptionDescriptor.create((String)"ApplicationLayerOnlySingletons", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Mark singleton as application layer only", (Object)this.getContainer(), SubstrateOptions.ApplicationLayerOnlySingletons, (String)"ApplicationLayerOnlySingletons", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AsyncSignalSafeDiagnostics": {
                return OptionDescriptor.create((String)"AsyncSignalSafeDiagnostics", (OptionType)OptionType.Expert, Boolean.class, (String)"Only print diagnostic output that is async signal safe.", (Object)this.getContainer(), SubstrateOptions.AsyncSignalSafeDiagnostics, (String)"AsyncSignalSafeDiagnostics", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputBreakdowns": {
                return OptionDescriptor.create((String)"BuildOutputBreakdowns", (OptionType)OptionType.User, Boolean.class, (String)"Show code and heap breakdowns as part of the build output", (Object)this.getContainer(), SubstrateOptions.BuildOutputBreakdowns, (String)"BuildOutputBreakdowns", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"Deprecated without replacement");
            }
            case "BuildOutputColorful": {
                return OptionDescriptor.create((String)"BuildOutputColorful", (OptionType)OptionType.User, Boolean.class, (String)"Color build output (enabled by default if colors are supported by terminal)", (Object)this.getContainer(), SubstrateOptions.BuildOutputColorful, (String)"BuildOutputColorful", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"Please use '--color' instead.");
            }
            case "BuildOutputGCWarnings": {
                return OptionDescriptor.create((String)"BuildOutputGCWarnings", (OptionType)OptionType.User, Boolean.class, (String)"Print GC warnings as part of build output", (Object)this.getContainer(), SubstrateOptions.BuildOutputGCWarnings, (String)"BuildOutputGCWarnings", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputJSONFile": {
                return OptionDescriptor.create((String)"BuildOutputJSONFile", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Print build output statistics as JSON to the specified file. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-output-schema-v0.9.4.json", (Object)this.getContainer(), SubstrateOptions.BuildOutputJSONFile, (String)"BuildOutputJSONFile", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputLinks": {
                return OptionDescriptor.create((String)"BuildOutputLinks", (OptionType)OptionType.User, Boolean.class, (String)"Show links in build output (defaults to the value of BuildOutputColorful)", (Object)this.getContainer(), SubstrateOptions.BuildOutputLinks, (String)"BuildOutputLinks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputPrefix": {
                return OptionDescriptor.create((String)"BuildOutputPrefix", (OptionType)OptionType.User, Boolean.class, (String)"Deprecated, option no longer has any effect.", (Object)this.getContainer(), SubstrateOptions.BuildOutputPrefix, (String)"BuildOutputPrefix", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"It no longer has any effect, and no replacement is available");
            }
            case "BuildOutputProgress": {
                return OptionDescriptor.create((String)"BuildOutputProgress", (OptionType)OptionType.User, Boolean.class, (String)"Report progress in build output (default is adaptive)", (Object)this.getContainer(), SubstrateOptions.BuildOutputProgress, (String)"BuildOutputProgress", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputRecommendations": {
                return OptionDescriptor.create((String)"BuildOutputRecommendations", (OptionType)OptionType.User, Boolean.class, (String)"Show recommendations as part of the build output", (Object)this.getContainer(), SubstrateOptions.BuildOutputRecommendations, (String)"BuildOutputRecommendations", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputSilent": {
                return OptionDescriptor.create((String)"BuildOutputSilent", (OptionType)OptionType.User, Boolean.class, (String)"Silence build output", (Object)this.getContainer(), SubstrateOptions.BuildOutputSilent, (String)"BuildOutputSilent", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CCompilerOption": {
                return OptionDescriptor.create((String)"CCompilerOption", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Provide custom C compiler option used for query code compilation.", (Object)this.getContainer(), SubstrateOptions.CCompilerOption, (String)"CCompilerOption", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CCompilerPath": {
                return OptionDescriptor.create((String)"CCompilerPath", (OptionType)OptionType.User, String.class, (String)"Provide custom path to C compiler used for query code compilation and linking.", (Object)this.getContainer(), SubstrateOptions.CCompilerPath, (String)"CCompilerPath", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CLibraryPath": {
                return OptionDescriptor.create((String)"CLibraryPath", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Search path for C libraries passed to the linker (list of comma-separated directories)", (Object)this.getContainer(), SubstrateOptions.CLibraryPath, (String)"CLibraryPath", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "CheckBootModuleDependencies": {
                return OptionDescriptor.create((String)"CheckBootModuleDependencies", (OptionType)OptionType.Debug, Integer.class, (String)"Temporary option to disable checking of image builder module dependencies or increasing its verbosity", (Object)this.getContainer(), SubstrateOptions.CheckBootModuleDependencies, (String)"CheckBootModuleDependencies", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CheckIsolateThreadAtEntry": {
                return OptionDescriptor.create((String)"CheckIsolateThreadAtEntry", (OptionType)OptionType.Debug, Boolean.class, (String)"At CEntryPoints check that the passed IsolateThread is valid.", (Object)this.getContainer(), SubstrateOptions.CheckIsolateThreadAtEntry, (String)"CheckIsolateThreadAtEntry", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CheckToolchain": {
                return OptionDescriptor.create((String)"CheckToolchain", (OptionType)OptionType.Expert, Boolean.class, (String)"Check if native-toolchain is known to work with native-image", (Object)this.getContainer(), SubstrateOptions.CheckToolchain, (String)"CheckToolchain", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Class": {
                return OptionDescriptor.create((String)"Class", (OptionType)OptionType.User, String.class, (String)"Class containing the default entry point method. Optional if --shared is used.", (Object)this.getContainer(), SubstrateOptions.Class, (String)"Class", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "ClosedTypeWorld": {
                return OptionDescriptor.create((String)"ClosedTypeWorld", (OptionType)OptionType.Expert, Boolean.class, (String)"Assume new types cannot be added after analysis", (Object)this.getContainer(), SubstrateOptions.ClosedTypeWorld, (String)"ClosedTypeWorld", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ClosedTypeWorldHubLayout": {
                return OptionDescriptor.create((String)"ClosedTypeWorldHubLayout", (OptionType)OptionType.Expert, Boolean.class, (String)"Use the closed type world dynamic hub representation. This is only allowed when the option ClosedTypeWorld is also set to true.", (Object)this.getContainer(), SubstrateOptions.ClosedTypeWorldHubLayout, (String)"ClosedTypeWorldHubLayout", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Color": {
                return OptionDescriptor.create((String)"Color", (OptionType)OptionType.User, String.class, (String)"Color build output ('always', 'never', or 'auto')", (Object)this.getContainer(), SubstrateOptions.Color, (String)"Color", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompilationIsolateAddressSpaceSize": {
                return OptionDescriptor.create((String)"CompilationIsolateAddressSpaceSize", (OptionType)OptionType.Debug, Long.class, (String)"Size of the reserved address space of each compilation isolate (0: default for new isolates).", (Object)this.getContainer(), SubstrateOptions.CompilationIsolateAddressSpaceSize, (String)"CompilationIsolateAddressSpaceSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompilationIsolateOptions": {
                return OptionDescriptor.create((String)"CompilationIsolateOptions", (OptionType)OptionType.Debug, String.class, (String)"Options that are passed to each compilation isolate. Individual arguments are separated by spaces. Arguments that contain spaces need to be enclosed by single quotes.", (Object)this.getContainer(), SubstrateOptions.CompilationIsolateOptions, (String)"CompilationIsolateOptions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompilerBackend": {
                return OptionDescriptor.create((String)"CompilerBackend", (OptionType)OptionType.User, String.class, (String)"Backend used by the compiler", (Object)this.getContainer(), SubstrateOptions.CompilerBackend, (String)"CompilerBackend", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ConfigureReflectionMetadata": {
                return OptionDescriptor.create((String)"ConfigureReflectionMetadata", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable runtime instantiation of reflection objects for non-invoked methods.", (Object)this.getContainer(), SubstrateOptions.ConfigureReflectionMetadata, (String)"ConfigureReflectionMetadata", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "ContendedPaddingWidth": {
                return OptionDescriptor.create((String)"ContendedPaddingWidth", (OptionType)OptionType.Debug, Integer.class, (String)"How many bytes to pad fields and classes marked @Contended with.", (Object)this.getContainer(), SubstrateOptions.ContendedPaddingWidth, (String)"ContendedPaddingWidth", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogExitOnTimeout": {
                return OptionDescriptor.create((String)"DeadlockWatchdogExitOnTimeout", (OptionType)OptionType.Expert, Boolean.class, (String)"Exit the image builder VM after printing call stacks", (Object)this.getContainer(), SubstrateOptions.DeadlockWatchdogExitOnTimeout, (String)"DeadlockWatchdogExitOnTimeout", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogInterval": {
                return OptionDescriptor.create((String)"DeadlockWatchdogInterval", (OptionType)OptionType.Expert, Integer.class, (String)"The interval in minutes between watchdog checks (0 disables the watchdog)", (Object)this.getContainer(), SubstrateOptions.DeadlockWatchdogInterval, (String)"DeadlockWatchdogInterval", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DebugCodeInfoMaxDepth": {
                return OptionDescriptor.create((String)"DebugCodeInfoMaxDepth", (OptionType)OptionType.Debug, Integer.class, (String)"Specify maximum inlining depth to consider when building DebugCodeInfo", (Object)this.getContainer(), SubstrateOptions.DebugCodeInfoMaxDepth, (String)"DebugCodeInfoMaxDepth", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DebugCodeInfoUseSourceMappings": {
                return OptionDescriptor.create((String)"DebugCodeInfoUseSourceMappings", (OptionType)OptionType.Debug, Boolean.class, (String)"Do not use SourceMappings for generating DebugCodeInfo (i.e. only use Infopoints)", (Object)this.getContainer(), SubstrateOptions.DebugCodeInfoUseSourceMappings, (String)"DebugCodeInfoUseSourceMappings", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DebugInfoSourceCacheRoot": {
                return OptionDescriptor.create((String)"DebugInfoSourceCacheRoot", (OptionType)OptionType.Debug, String.class, (String)"Directory under which to create source file cache for Application or GraalVM classes", (Object)this.getContainer(), SubstrateOptions.DebugInfoSourceCacheRoot, (String)"DebugInfoSourceCacheRoot", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DeleteLocalSymbols": {
                return OptionDescriptor.create((String)"DeleteLocalSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to remove all local symbols from image.", (Object)this.getContainer(), SubstrateOptions.DeleteLocalSymbols, (String)"DeleteLocalSymbols", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DetectUserDirectoriesInImageHeap": {
                return OptionDescriptor.create((String)"DetectUserDirectoriesInImageHeap", (OptionType)OptionType.User, Boolean.class, (String)"When set to true, the image generator verifies that the image heap does not contain a home directory as a substring", (Object)this.getContainer(), SubstrateOptions.DetectUserDirectoriesInImageHeap, (String)"DetectUserDirectoriesInImageHeap", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "DiagnosticBufferSize": {
                return OptionDescriptor.create((String)"DiagnosticBufferSize", (OptionType)OptionType.Debug, Integer.class, (String)"Specifies the number of entries that diagnostic buffers have.", (Object)this.getContainer(), SubstrateOptions.DiagnosticBufferSize, (String)"DiagnosticBufferSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DiagnosticDetails": {
                return OptionDescriptor.create((String)"DiagnosticDetails", (OptionType)OptionType.Expert, String.class, (String)"Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.", (Object)this.getContainer(), SubstrateOptions.DiagnosticDetails, (String)"DiagnosticDetails", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DisableSubstitution": {
                return OptionDescriptor.create((String)"DisableSubstitution", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Disable the substitutions matched by the option value. A value can be a fully qualified method name with parameter list, a fully qualified method name without parameter list, or a fully qualified type name. When multiple methods match a value, then all matching substitutions are disabled.", (Object)this.getContainer(), SubstrateOptions.DisableSubstitution, (String)"DisableSubstitution", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DisableTypeIdResultVerification": {
                return OptionDescriptor.create((String)"DisableTypeIdResultVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"For internal purposes only. Disables type id result verification even when running with assertions enabled.", (Object)this.getContainer(), SubstrateOptions.DisableTypeIdResultVerification, (String)"DisableTypeIdResultVerification", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DisableURLProtocols": {
                return OptionDescriptor.create((String)"DisableURLProtocols", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols that must never be included.", (Object)this.getContainer(), SubstrateOptions.DisableURLProtocols, (String)"DisableURLProtocols", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpHeapAndExit": {
                return OptionDescriptor.create((String)"DumpHeapAndExit", (OptionType)OptionType.Debug, Boolean.class, (String)"Create a heap dump and exit.", (Object)this.getContainer(), SubstrateOptions.DumpHeapAndExit, (String)"DumpHeapAndExit", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpTargetInfo": {
                return OptionDescriptor.create((String)"DumpTargetInfo", (OptionType)OptionType.User, Boolean.class, (String)"Show native-toolchain information and image-build settings", (Object)this.getContainer(), SubstrateOptions.DumpTargetInfo, (String)"DumpTargetInfo", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableAllSecurityServices": {
                return OptionDescriptor.create((String)"EnableAllSecurityServices", (OptionType)OptionType.Debug, Boolean.class, (String)"Add all security service classes to the generated image.", (Object)this.getContainer(), SubstrateOptions.EnableAllSecurityServices, (String)"EnableAllSecurityServices", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "EnableSignalHandling": {
                return OptionDescriptor.create((String)"EnableSignalHandling", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables signal handling", (Object)this.getContainer(), SubstrateOptions.EnableSignalHandling, (String)"EnableSignalHandling", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableURLProtocols": {
                return OptionDescriptor.create((String)"EnableURLProtocols", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols to enable.", (Object)this.getContainer(), SubstrateOptions.EnableURLProtocols, (String)"EnableURLProtocols", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableWildcardExpansion": {
                return OptionDescriptor.create((String)"EnableWildcardExpansion", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable wildcard expansion in command line arguments on Windows.", (Object)this.getContainer(), SubstrateOptions.EnableWildcardExpansion, (String)"EnableWildcardExpansion", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EntryPointNamePrefix": {
                return OptionDescriptor.create((String)"EntryPointNamePrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of entry point methods.", (Object)this.getContainer(), SubstrateOptions.EntryPointNamePrefix, (String)"EntryPointNamePrefix", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FallbackThreshold": {
                return OptionDescriptor.create((String)"FallbackThreshold", (OptionType)OptionType.Debug, Integer.class, (String)"Define when fallback-image generation should be used.", (Object)this.getContainer(), SubstrateOptions.FallbackThreshold, (String)"FallbackThreshold", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FlightRecorder": {
                return OptionDescriptor.create((String)"FlightRecorder", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Flight Recorder.", (Object)this.getContainer(), SubstrateOptions.FlightRecorder, (String)"FlightRecorder", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FlightRecorderLogging": {
                return OptionDescriptor.create((String)"FlightRecorderLogging", (OptionType)OptionType.Debug, String.class, (String)"Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]\n\nWhen this option is not set, logging is enabled at a level of WARNING.\nWhen this option is set to the empty string, logging is enabled at a level of INFO.\nWhen this option is set to \"disable\", logging is disabled entirely.\n\nOtherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.\nA tag combination without a level is given a default level of INFO.\nMessages with tags that match a given tag combination are set to log at that tag combination's level.\nIf a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.\nOtherwise, messages whose tags are a subset of the tag combination are matched.\nSpecifying \"all\" instead of a tag combination matches all tag combinations.\nIf more than one tag combination matches a message's tags, the rightmost one will apply.\nMessages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.\nThis option is case insensitive.\n\nAvailable log levels:\n[trace, debug, info, warning, error, off]\n\nAvailable log tags:\n[jfr, system, event, setting, bytecode, parser, metadata, dcmd]", (Object)this.getContainer(), SubstrateOptions.FlightRecorderLogging, (String)"FlightRecorderLogging", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FlightRecorderOptions": {
                return OptionDescriptor.create((String)"FlightRecorderOptions", (OptionType)OptionType.Debug, String.class, (String)"Usage: -XX:FlightRecorderOptions=[option[=value][,...]]\n\nThis option expects a comma separated list of key-value pairs. None of the options are mandatory. Possible option keys are as follows:\n\nglobalbuffersize=512k      (Optional) Size of each global JFR buffer.\n                           This value cannot be changed once JFR has been initialized.\n                           The default value is determined by the value for memorysize.\n\nmaxchunksize=12m           (Optional) Maximum size of each individual JFR data chunk.\n                           This value cannot be changed once JFR has been initialized.\n\nmemorysize=10m             (Optional) Total size of all global JFR buffers.\n                           This value cannot be changed once JFR has been initialized.\n\nold-object-queue-size=256  (Optional) The maximum number of old objects to track when the JFR event\n                           OldObjectSample is enabled.\n\nrepository=...             (Optional) Path to the location where JFR recordings are stored until they are\n                           written to a permanent file.\n                           The default location is the temporary directory for the operating system.\n\nstackdepth=64              (Optional) Stack depth for stack traces.\n                           Setting this value greater than the default may cause a performance degradation.\n                           This value cannot be changed once JFR has been initialized.\n\nthreadbuffersize=8k        (Optional) Size of each thread-local JFR buffer.\n                           This value cannot be changed once JFR has been initialized.\n\npreserve-repository=false  (Optional) Preserve files stored in the disk repository after the process exits.", (Object)this.getContainer(), SubstrateOptions.FlightRecorderOptions, (String)"FlightRecorderOptions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FoldSecurityManagerGetter": {
                return OptionDescriptor.create((String)"FoldSecurityManagerGetter", (OptionType)OptionType.Expert, Boolean.class, (String)"Fold SecurityManager getter.", (Object)this.getContainer(), SubstrateOptions.FoldSecurityManagerGetter, (String)"FoldSecurityManagerGetter", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ForeignAPISupport": {
                return OptionDescriptor.create((String)"ForeignAPISupport", (OptionType)OptionType.Expert, Boolean.class, (String)"Support for calls via the Java Foreign Function and Memory API", (Object)this.getContainer(), SubstrateOptions.ForeignAPISupport, (String)"ForeignAPISupport", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GenerateBuildArtifactsFile": {
                return OptionDescriptor.create((String)"GenerateBuildArtifactsFile", (OptionType)OptionType.User, Boolean.class, (String)"Create a build-artifacts.json file in the build directory. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-artifacts-schema-v0.9.0.json", (Object)this.getContainer(), SubstrateOptions.GenerateBuildArtifactsFile, (String)"GenerateBuildArtifactsFile", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GenerateDebugInfo": {
                return OptionDescriptor.create((String)"GenerateDebugInfo", (OptionType)OptionType.Debug, Integer.class, (String)"Insert debug info into the generated native image or library", (Object)this.getContainer(), SubstrateOptions.GenerateDebugInfo, (String)"GenerateDebugInfo", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapDumpDefaultFilenamePrefix": {
                return OptionDescriptor.create((String)"HeapDumpDefaultFilenamePrefix", (OptionType)OptionType.Debug, String.class, (String)"A prefix that is used for heap dump filenames if no heap dump filename was specified explicitly.", (Object)this.getContainer(), SubstrateOptions.HeapDumpDefaultFilenamePrefix, (String)"HeapDumpDefaultFilenamePrefix", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapDumpOnOutOfMemoryError": {
                return OptionDescriptor.create((String)"HeapDumpOnOutOfMemoryError", (OptionType)OptionType.Debug, Boolean.class, (String)"Dump heap to file (see HeapDumpPath) the first time the image throws java.lang.OutOfMemoryError because it ran out of Java heap.", (Object)this.getContainer(), SubstrateOptions.HeapDumpOnOutOfMemoryError, (String)"HeapDumpOnOutOfMemoryError", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapDumpPath": {
                return OptionDescriptor.create((String)"HeapDumpPath", (OptionType)OptionType.Debug, String.class, (String)"Path of the file or directory in which heap dumps are created. An empty value means a default file name will be used. An existing directory means the dump will be placed in the directory and have the default file name.", (Object)this.getContainer(), SubstrateOptions.HeapDumpPath, (String)"HeapDumpPath", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IgnorePreserveForClasses": {
                return OptionDescriptor.create((String)"IgnorePreserveForClasses", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Ignore classes or packages (comma separated) from the ones included with '-H:Preserve'. This can be used to workaround potential issues related to '-H:Preserve'.", (Object)this.getContainer(), SubstrateOptions.IgnorePreserveForClasses, (String)"IgnorePreserveForClasses", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageBuildID": {
                return OptionDescriptor.create((String)"ImageBuildID", (OptionType)OptionType.Debug, String.class, (String)"Image Build ID is a 128-bit UUID string generated randomly, once per bundle or digest of input args when bundles are not used.", (Object)this.getContainer(), SubstrateOptions.ImageBuildID, (String)"ImageBuildID", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageSymbolsPrefix": {
                return OptionDescriptor.create((String)"ImageSymbolsPrefix", (OptionType)OptionType.Debug, String.class, (String)"Common prefix used by method symbols in image.", (Object)this.getContainer(), SubstrateOptions.ImageSymbolsPrefix, (String)"ImageSymbolsPrefix", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeDebugHelperMethods": {
                return OptionDescriptor.create((String)"IncludeDebugHelperMethods", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if debugging-specific helper methods are embedded into the image. Those methods can be called directly from the debugger to obtain or print additional information.", (Object)this.getContainer(), SubstrateOptions.IncludeDebugHelperMethods, (String)"IncludeDebugHelperMethods", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeMethodData": {
                return OptionDescriptor.create((String)"IncludeMethodData", (OptionType)OptionType.Expert, Boolean.class, (String)"Include a list of methods included in the image for runtime inspection.", (Object)this.getContainer(), SubstrateOptions.IncludeMethodData, (String)"IncludeMethodData", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeNodeSourcePositions": {
                return OptionDescriptor.create((String)"IncludeNodeSourcePositions", (OptionType)OptionType.Debug, Boolean.class, (String)"Track NodeSourcePositions during runtime-compilation", (Object)this.getContainer(), SubstrateOptions.IncludeNodeSourcePositions, (String)"IncludeNodeSourcePositions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InstallExitHandlers": {
                return OptionDescriptor.create((String)"InstallExitHandlers", (OptionType)OptionType.Expert, Boolean.class, (String)"Provide java.lang.Terminator exit handlers. Default value is true for executables and false for shared libraries because this option installs signal handlers.", (Object)this.getContainer(), SubstrateOptions.InstallExitHandlers, (String)"InstallExitHandlers", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InternalSymbolsAreGlobal": {
                return OptionDescriptor.create((String)"InternalSymbolsAreGlobal", (OptionType)OptionType.Debug, Boolean.class, (String)"Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.", (Object)this.getContainer(), SubstrateOptions.InternalSymbolsAreGlobal, (String)"InternalSymbolsAreGlobal", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InternalThreadStackSize": {
                return OptionDescriptor.create((String)"InternalThreadStackSize", (OptionType)OptionType.Debug, Long.class, (String)"Deprecated, has no effect.", (Object)this.getContainer(), SubstrateOptions.InternalThreadStackSize, (String)"InternalThreadStackSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "JNI": {
                return OptionDescriptor.create((String)"JNI", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Native Interface (JNI) support.", (Object)this.getContainer(), SubstrateOptions.JNI, (String)"JNI", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIEnhancedErrorCodes": {
                return OptionDescriptor.create((String)"JNIEnhancedErrorCodes", (OptionType)OptionType.User, Boolean.class, (String)"JNI functions will return more specific error codes.", (Object)this.getContainer(), SubstrateOptions.JNIEnhancedErrorCodes, (String)"JNIEnhancedErrorCodes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIExportSymbols": {
                return OptionDescriptor.create((String)"JNIExportSymbols", (OptionType)OptionType.User, Boolean.class, (String)"Export Invocation API symbols.", (Object)this.getContainer(), SubstrateOptions.JNIExportSymbols, (String)"JNIExportSymbols", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIVerboseLookupErrors": {
                return OptionDescriptor.create((String)"JNIVerboseLookupErrors", (OptionType)OptionType.User, Boolean.class, (String)"Report information about known JNI elements when lookup fails", (Object)this.getContainer(), SubstrateOptions.JNIVerboseLookupErrors, (String)"JNIVerboseLookupErrors", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JVMTI": {
                return OptionDescriptor.create((String)"JVMTI", (OptionType)OptionType.User, Boolean.class, (String)"Enable JVM Tool Interface (JVMTI) support.", (Object)this.getContainer(), SubstrateOptions.JVMTI, (String)"JVMTI", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JVMTIAgentLib": {
                return OptionDescriptor.create((String)"JVMTIAgentLib", (OptionType)OptionType.User, String.class, (String)"Loads the specified native agent library. After the library name, a comma-separated list of options specific to the library can be used.", (Object)this.getContainer(), SubstrateOptions.JVMTIAgentLib, (String)"JVMTIAgentLib", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JVMTIAgentPath": {
                return OptionDescriptor.create((String)"JVMTIAgentPath", (OptionType)OptionType.User, String.class, (String)"Loads the specified native agent library specified by the absolute path name. After the library path, a comma-separated list of options specific to the library can be used.", (Object)this.getContainer(), SubstrateOptions.JVMTIAgentPath, (String)"JVMTIAgentPath", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LayerCreate": {
                return OptionDescriptor.create((String)"LayerCreate", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Experimental: Build a Native Image layer.", (Object)this.getContainer(), SubstrateOptions.LayerCreate, (String)"LayerCreate", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LayerOptionVerification": {
                return OptionDescriptor.create((String)"LayerOptionVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"Experimental: Perform strict checking of options used for layered image build.", (Object)this.getContainer(), SubstrateOptions.LayerOptionVerification, (String)"LayerOptionVerification", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LayerOptionVerificationVerbose": {
                return OptionDescriptor.create((String)"LayerOptionVerificationVerbose", (OptionType)OptionType.Debug, Boolean.class, (String)"Experimental: Provide verbose output of difference in builder options between layers.", (Object)this.getContainer(), SubstrateOptions.LayerOptionVerificationVerbose, (String)"LayerOptionVerificationVerbose", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LayerUse": {
                return OptionDescriptor.create((String)"LayerUse", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Experimental: Build an image based on a Native Image layer.", (Object)this.getContainer(), SubstrateOptions.LayerUse, (String)"LayerUse", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LibGraalClassLoader": {
                return OptionDescriptor.create((String)"LibGraalClassLoader", (OptionType)OptionType.Debug, String.class, (String)"Specify the fully qualified name of a class that implements org.graalvm.nativeimage.libgraal.LibGraalLoader.\n\nThis option is only supported for building the libgraal shared library.\n\nThe named class is instantiated via the default constructor.\nIt affects image building as follows:\n\n 1. The custom loader is used to lookup Feature implementations passed via the --features option.\n 2. All @CEntryPoint definitions in classes loaded by the custom loader are processed.\n 3. All @TargetClass substitutions in classes loaded by the custom loader are processed.", (Object)this.getContainer(), SubstrateOptions.LibGraalClassLoader, (String)"LibGraalClassLoader", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LinkerRPath": {
                return OptionDescriptor.create((String)"LinkerRPath", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Path passed to the linker as the -rpath (list of comma-separated directories)", (Object)this.getContainer(), SubstrateOptions.LinkerRPath, (String)"LinkerRPath", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LoggingHashCodeInjection": {
                return OptionDescriptor.create((String)"LoggingHashCodeInjection", (OptionType)OptionType.Debug, Boolean.class, (String)"Enables logging of failed hash code injection", (Object)this.getContainer(), SubstrateOptions.LoggingHashCodeInjection, (String)"LoggingHashCodeInjection", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxDirectMemorySize": {
                return OptionDescriptor.create((String)"MaxDirectMemorySize", (OptionType)OptionType.Expert, Long.class, (String)"Maximum total size of NIO direct-buffer allocations", (Object)this.getContainer(), SubstrateOptions.MaxDirectMemorySize, (String)"MaxDirectMemorySize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxInvokesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxInvokesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of invokes in a method so that it is considered trivial (for testing only).", (Object)this.getContainer(), SubstrateOptions.MaxInvokesInTrivialMethod, (String)"MaxInvokesInTrivialMethod", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxNodesAfterTrivialInlining": {
                return OptionDescriptor.create((String)"MaxNodesAfterTrivialInlining", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum number of nodes in a graph allowed after trivial inlining.", (Object)this.getContainer(), SubstrateOptions.MaxNodesAfterTrivialInlining, (String)"MaxNodesAfterTrivialInlining", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialLeafMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialLeafMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.", (Object)this.getContainer(), SubstrateOptions.MaxNodesInTrivialLeafMethod, (String)"MaxNodesInTrivialLeafMethod", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial.", (Object)this.getContainer(), SubstrateOptions.MaxNodesInTrivialMethod, (String)"MaxNodesInTrivialMethod", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxUnrolledObjectZeroingStores": {
                return OptionDescriptor.create((String)"MaxUnrolledObjectZeroingStores", (OptionType)OptionType.Debug, Integer.class, (String)"Define the maximum number of stores for which the loop that zeroes out objects is unrolled.", (Object)this.getContainer(), SubstrateOptions.MaxUnrolledObjectZeroingStores, (String)"MaxUnrolledObjectZeroingStores", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Method": {
                return OptionDescriptor.create((String)"Method", (OptionType)OptionType.Debug, String.class, (String)"Name of the main entry point method. Optional if --shared is used.", (Object)this.getContainer(), SubstrateOptions.Method, (String)"Method", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MissingRegistrationReportingMode": {
                return OptionDescriptor.create((String)"MissingRegistrationReportingMode", (OptionType)OptionType.Debug, SubstrateOptions.ReportingMode.class, (String)"Select the mode in which the missing reflection registrations will be reported.\nPossible values are:\",\n \"Throw\" (default): Throw a MissingReflectionRegistrationError;\n \"Exit\": Call System.exit() to avoid accidentally catching the error;\n \"Warn\": Print a message to stdout, including a stack trace to see what caused the issue.", (Object)this.getContainer(), SubstrateOptions.MissingRegistrationReportingMode, (String)"MissingRegistrationReportingMode", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MissingRegistrationWarnContextLines": {
                return OptionDescriptor.create((String)"MissingRegistrationWarnContextLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of context lines printed for each missing registration error in Warn mode", (Object)this.getContainer(), SubstrateOptions.MissingRegistrationWarnContextLines, (String)"MissingRegistrationWarnContextLines", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Module": {
                return OptionDescriptor.create((String)"Module", (OptionType)OptionType.User, String.class, (String)"Module containing the class that contains the main entry point. Optional if --shared is used.", (Object)this.getContainer(), SubstrateOptions.Module, (String)"Module", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MremapImageHeap": {
                return OptionDescriptor.create((String)"MremapImageHeap", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable fallback to mremap for initializing the image heap.", (Object)this.getContainer(), SubstrateOptions.MremapImageHeap, (String)"MremapImageHeap", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MultiThreaded": {
                return OptionDescriptor.create((String)"MultiThreaded", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated, has no effect.", (Object)this.getContainer(), SubstrateOptions.MultiThreaded, (String)"MultiThreaded", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "Name": {
                return OptionDescriptor.create((String)"Name", (OptionType)OptionType.User, String.class, (String)"Name of the output file to be generated", (Object)this.getContainer(), SubstrateOptions.Name, (String)"Name", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "NeverInline": {
                return OptionDescriptor.create((String)"NeverInline", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Pattern for disabling inlining of methods during image generation.\nThe syntax for a pattern is:\n\n  SourcePatterns = SourcePattern [\",\" SourcePatterns] .\n  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .\n  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .\n  Class = { package \".\" } class .\n\nGlob pattern matching (*, ?) is allowed in all parts of the source pattern.\n\nExamples of method filters:\n---------\n  visit(Argument;BlockScope)\n\n  Matches all methods named \"visit\", with the first parameter of\n  type \"Argument\", and the second parameter of type \"BlockScope\".\n  The packages of the parameter types are irrelevant.\n---------\n  arraycopy(Object;;;;)\n\n  Matches all methods named \"arraycopy\", with the first parameter\n  of type \"Object\", and four more parameters of any type. The\n  packages of the parameter types are irrelevant.\n---------\n  jdk.graal.compiler.core.graph.PostOrderNodeIterator.*\n\n  Matches all methods in the class \"jdk.graal.compiler.core.graph.PostOrderNodeIterator\".\n---------\n  *\n\n  Matches all methods in all classes\n---------\n  jdk.graal.compiler.core.graph.*.visit\n\n  Matches all methods named \"visit\" in classes in the package\n  \"jdk.graal.compiler.core.graph\".\n---------\n  arraycopy,toString\n\n  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator.", (Object)this.getContainer(), SubstrateOptions.NeverInline, (String)"NeverInline", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "NoDirectRelocationsInText": {
                return OptionDescriptor.create((String)"NoDirectRelocationsInText", (OptionType)OptionType.Debug, Boolean.class, (String)"Force no direct relocations to be present in the text section of the generated image", (Object)this.getContainer(), SubstrateOptions.NoDirectRelocationsInText, (String)"NoDirectRelocationsInText", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "OmitInlinedMethodDebugLineInfo": {
                return OptionDescriptor.create((String)"OmitInlinedMethodDebugLineInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Omit generation of DebugLineInfo originating from inlined methods", (Object)this.getContainer(), SubstrateOptions.OmitInlinedMethodDebugLineInfo, (String)"OmitInlinedMethodDebugLineInfo", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Optimize": {
                return OptionDescriptor.create((String)"Optimize", (OptionType)OptionType.User, String.class, (String)"Control code optimizations: b - optimize for fastest build time, s - optimize for size, 0 - no optimizations, 1 - basic optimizations, 2 - advanced optimizations, 3 - all optimizations for best performance.", (Object)this.getContainer(), SubstrateOptions.Optimize, (String)"Optimize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ParseOnce": {
                return OptionDescriptor.create((String)"ParseOnce", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated, option no longer has any effect.", (Object)this.getContainer(), SubstrateOptions.ParseOnce, (String)"ParseOnce", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"It no longer has any effect, and no replacement is available");
            }
            case "ParseOnceJIT": {
                return OptionDescriptor.create((String)"ParseOnceJIT", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated, option no longer has any effect.", (Object)this.getContainer(), SubstrateOptions.ParseOnceJIT, (String)"ParseOnceJIT", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"It no longer has any effect, and no replacement is available");
            }
            case "ParseRuntimeOptions": {
                return OptionDescriptor.create((String)"ParseRuntimeOptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Parse and consume standard options and system properties from the command line arguments when the VM is created.", (Object)this.getContainer(), SubstrateOptions.ParseRuntimeOptions, (String)"ParseRuntimeOptions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PinnedObjectAddressing": {
                return OptionDescriptor.create((String)"PinnedObjectAddressing", (OptionType)OptionType.Expert, Boolean.class, (String)"Allows the addresses of pinned objects to be passed to other code.", (Object)this.getContainer(), SubstrateOptions.PinnedObjectAddressing, (String)"PinnedObjectAddressing", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Preserve": {
                return OptionDescriptor.create((String)"Preserve", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Preserves all classes and relevant resources from selected classpath entries in the image.\nFor the selected classpath entries it is not necessary to provide reachability metadata because all classes, as well as resources not ending in '.class' or '.jar', are included into the image.\nPlease note that using this option can result in a significant increase in build time and binary size, as well as a decrease in runtime performance.\n\nUsage: -H:Preserve=[all|none|module=<module>|package=<package>|package=<package-wildcard>|path=<cp-entry>][,...]\n\nThe flag can be used in following ways:\n1. -H:Preserve=all preserves all elements from the JDK, the classpath, and the module path\n2. -H:Preserve=module=<module> preserves all elements from a given module\n3. -H:Preserve=module=ALL-UNNAMED preserves all elements from all class-path entries\n4. -H:Preserve=package=<package> preserves all elements from a given package\n5. -H:Preserve=package=<package-wildcard> preserves all elements from packages captured by the wildcard. For example, -H:Preserve=package=my.app.*\n6. -H:Preserve=path=<cp-entry> preserves all elements from a given class-path entry\n7. -H:Preserve=none disables all previous selections for preservation\n8. A comma-separated list of the previous cases. For example, -H:Preserve=path=<cp-entry>,module=<module>,package=<package>\n\n'-H:Preserve' is only allowed on the native-image command line and cannot be embedded in the native-image.properties files.", (Object)this.getContainer(), SubstrateOptions.Preserve, (String)"Preserve", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PreserveFramePointer": {
                return OptionDescriptor.create((String)"PreserveFramePointer", (OptionType)OptionType.Debug, Boolean.class, (String)"Saves stack base pointer on the stack on method entry.", (Object)this.getContainer(), SubstrateOptions.PreserveFramePointer, (String)"PreserveFramePointer", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintClosedArenaUponThrow": {
                return OptionDescriptor.create((String)"PrintClosedArenaUponThrow", (OptionType)OptionType.Debug, Boolean.class, (String)"Flag indicating if the code checking for closed arenas should print to stdout when it sees an exception.", (Object)this.getContainer(), SubstrateOptions.PrintClosedArenaUponThrow, (String)"PrintClosedArenaUponThrow", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintVMInfoAndExit": {
                return OptionDescriptor.create((String)"PrintVMInfoAndExit", (OptionType)OptionType.Debug, Boolean.class, (String)"Print some VM information and exit.", (Object)this.getContainer(), SubstrateOptions.PrintVMInfoAndExit, (String)"PrintVMInfoAndExit", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReduceImplicitExceptionStackTraceInformation": {
                return OptionDescriptor.create((String)"ReduceImplicitExceptionStackTraceInformation", (OptionType)OptionType.Expert, Boolean.class, (String)"Reduce the amount of metadata in the image for implicit exceptions by removing inlining information from the stack trace. This makes the image smaller, but also the stack trace of implicit exceptions less precise.", (Object)this.getContainer(), SubstrateOptions.ReduceImplicitExceptionStackTraceInformation, (String)"ReduceImplicitExceptionStackTraceInformation", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RelativeCodePointers": {
                return OptionDescriptor.create((String)"RelativeCodePointers", (OptionType)OptionType.Expert, Boolean.class, (String)"Avoid linker relocations for code and instead emit address computations.", (Object)this.getContainer(), SubstrateOptions.RelativeCodePointers, (String)"RelativeCodePointers", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RemoveUnusedSymbols": {
                return OptionDescriptor.create((String)"RemoveUnusedSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to prevent unreferenced symbols in image.", (Object)this.getContainer(), SubstrateOptions.RemoveUnusedSymbols, (String)"RemoveUnusedSymbols", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReportAnalysisForbiddenType": {
                return OptionDescriptor.create((String)"ReportAnalysisForbiddenType", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: Reachable, Instantiated).", (Object)this.getContainer(), SubstrateOptions.ReportAnalysisForbiddenType, (String)"ReportAnalysisForbiddenType", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RunMainInNewThread": {
                return OptionDescriptor.create((String)"RunMainInNewThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Initializes and runs main entry point in a new native thread.", (Object)this.getContainer(), SubstrateOptions.RunMainInNewThread, (String)"RunMainInNewThread", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SharedArenaSupport": {
                return OptionDescriptor.create((String)"SharedArenaSupport", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable support for Arena.ofShared ", (Object)this.getContainer(), SubstrateOptions.SharedArenaSupport, (String)"SharedArenaSupport", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SharedLibrary": {
                return OptionDescriptor.create((String)"SharedLibrary", (OptionType)OptionType.Debug, Boolean.class, (String)"Build shared library", (Object)this.getContainer(), SubstrateOptions.SharedLibrary, (String)"SharedLibrary", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SourceLevelDebug": {
                return OptionDescriptor.create((String)"SourceLevelDebug", (OptionType)OptionType.Debug, Boolean.class, (String)"Preserve the local variable information for every Java source line to allow line-by-line stepping in the debugger. Allow the lookup of Java-level method information, e.g., in stack traces.", (Object)this.getContainer(), SubstrateOptions.SourceLevelDebug, (String)"SourceLevelDebug", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SourceLevelDebugFilter": {
                return OptionDescriptor.create((String)"SourceLevelDebugFilter", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Constrain debug info generation to the comma-separated list of package prefixes given to this option.", (Object)this.getContainer(), SubstrateOptions.SourceLevelDebugFilter, (String)"SourceLevelDebugFilter", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SpawnIsolates": {
                return OptionDescriptor.create((String)"SpawnIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support multiple isolates.", (Object)this.getContainer(), SubstrateOptions.SpawnIsolates, (String)"SpawnIsolates", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"This option disables a major feature of GraalVM Native Image and will be removed in a future release");
            }
            case "StackSize": {
                return OptionDescriptor.create((String)"StackSize", (OptionType)OptionType.User, Long.class, (String)"The size of each thread stack at run-time, in bytes.", (Object)this.getContainer(), SubstrateOptions.StackSize, (String)"StackSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StackTrace": {
                return OptionDescriptor.create((String)"StackTrace", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated, has no effect.", (Object)this.getContainer(), SubstrateOptions.StackTrace, (String)"StackTrace", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "StartFlightRecording": {
                return OptionDescriptor.create((String)"StartFlightRecording", (OptionType)OptionType.Debug, String.class, (String)"Start a flight recording by passing a comma-separated list of key-value pairs.\n\nUsage: -XX:StartFlightRecording=[key[=value][,...]]\n\nThe following key-value pairs are supported:\n\nname       (Optional) Specify a name to identify the recording, for example, `name=MyRecording` to identify the recording, for example, \"name=MyRecording\".\n\nsettings   (Optional) Specify a settings file (profile.jfc, default.jfc, etc.), for example, \"settings=myprofile.jfc\".\n\ndelay      (Optional) Delay recording start with (s)econds, (m)inutes, (h)ours, or (d)ays, for example, \"delay=5h\".\n\nduration   (Optional) Duration of recording in (s)econds, (m)inutes, (h)ours, or (d)ays for example, \"duration=300s\". Default: 0 (infinite).\n\nfilename   (Optional) Specify a resulting recording filename, for example, \"filename=recording1.jfr\".\n\nmaxage     (Optional) Maximum time to keep the recorded data on disk in (s)econds, (m)inutes, (h)ours, or (d)ays, e.g., 60m, or 0 for no limit, for example, \"maxage=1d\". Default: 0 (no limit).\n\nmaxsize    (Optional) Maximum amount of bytes to keep on disk in (k)B, (M)B or (G)B, or 0 for no limit, for example, 500M, or 0 for no limit, for example, \"maxsize=1G\". Default: 0 (no limit).\n\ndumponexit (Optional) Whether to dump a running recording when the JVM shuts down, for example, \"dumponexit=true\". Default: false.", (Object)this.getContainer(), SubstrateOptions.StartFlightRecording, (String)"StartFlightRecording", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StaticExecutable": {
                return OptionDescriptor.create((String)"StaticExecutable", (OptionType)OptionType.Debug, Boolean.class, (String)"Build statically linked executable (requires static libc and zlib)", (Object)this.getContainer(), SubstrateOptions.StaticExecutable, (String)"StaticExecutable", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StaticExecutableWithDynamicLibC": {
                return OptionDescriptor.create((String)"StaticExecutableWithDynamicLibC", (OptionType)OptionType.Expert, Boolean.class, (String)"Build statically linked executable with libc dynamically linked", (Object)this.getContainer(), SubstrateOptions.StaticExecutableWithDynamicLibC, (String)"StaticExecutableWithDynamicLibC", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StaticLibStdCpp": {
                return OptionDescriptor.create((String)"StaticLibStdCpp", (OptionType)OptionType.Expert, Boolean.class, (String)"Builds image with libstdc++ statically linked into the image (if needed)", (Object)this.getContainer(), SubstrateOptions.StaticLibStdCpp, (String)"StaticLibStdCpp", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StrictQueryCodeCompilation": {
                return OptionDescriptor.create((String)"StrictQueryCodeCompilation", (OptionType)OptionType.User, Boolean.class, (String)"Use strict checks when performing query code compilation.", (Object)this.getContainer(), SubstrateOptions.StrictQueryCodeCompilation, (String)"StrictQueryCodeCompilation", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StripDebugInfo": {
                return OptionDescriptor.create((String)"StripDebugInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a separate file for debug info.", (Object)this.getContainer(), SubstrateOptions.StripDebugInfo, (String)"StripDebugInfo", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SupportedGCs": {
                return OptionDescriptor.create((String)"SupportedGCs", (OptionType)OptionType.Debug, ReplacingLocatableMultiOptionValue.DelimitedString.class, (String)"Please use '--gc=*' instead. Possible values are listed with '--help'.", (Object)this.getContainer(), SubstrateOptions.SupportedGCs, (String)"SupportedGCs", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TargetPlatform": {
                return OptionDescriptor.create((String)"TargetPlatform", (OptionType)OptionType.Debug, String.class, (String)"Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.", (Object)this.getContainer(), SubstrateOptions.TargetPlatform, (String)"TargetPlatform", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TearDownWarningSeconds": {
                return OptionDescriptor.create((String)"TearDownWarningSeconds", (OptionType)OptionType.Debug, Long.class, (String)"The number of seconds before and between which tearing down an isolate gives a warning message. 0 implies no warning.", (Object)this.getContainer(), SubstrateOptions.TearDownWarningSeconds, (String)"TearDownWarningSeconds", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ThrowLinkAtBuildTimeIOExceptions": {
                return OptionDescriptor.create((String)"ThrowLinkAtBuildTimeIOExceptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Instead of warning, throw IOExceptions for link-at-build-time resources at build time", (Object)this.getContainer(), SubstrateOptions.ThrowLinkAtBuildTimeIOExceptions, (String)"ThrowLinkAtBuildTimeIOExceptions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ThrowMissingRegistrationErrors": {
                return OptionDescriptor.create((String)"ThrowMissingRegistrationErrors", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Enables exact and user-friendly handling of reflection, resources, JNI, and serialization.\nWhen reachability metadata for an element is specified, the native executable will have expected and predictable behavior.\nWhen reachability metadata for an element is not specified, the binary will fail fast with a subtype of `java.lang.Error`\n that explains exactly which element was missing. The errors can happen on reflection, resource, JNI, and serialization accesses.\n\nNote: '--exact-reachability-metadata' will become the default in future versions of Native Image. It is recommended to adopt the mode early\n to avoid breakage during migration to newer GraalVM versions.\n\nIf errors occur in third-party code, exact reachability metadata can be applied only to a single package with\n '--exact-reachability-metadata=pkg'. To apply to whole jars, modules, and class-path entries please use\n '--exact-reachability-metadata-path'. Using '--exact-reachability-metadata=<pkg>' with arguments is allowed in every scope:\n\n  1. On command line\n  2. Embedded in a 'native-image.properties' file of some zip/jar file on module-path\n  3. Embedded in a 'native-image.properties' file of some zip/jar file on class-path\n\nIf used without arguments (only '--exact-reachability-metadata'), the errors will be thrown when calling the corresponding query from any\n class in scope of the option. Using '--exact-reachability-metadata' without arguments is only allowed on command line or when\n embedded in a 'native-image.properties' file of some zip/jar file on the module-path (but not on class-path).\n In the module path case, the option will cause all classes of the module to trigger missing registration errors.\n If used without arguments on command line all classes will trigger missing registration errors.\n\nIf the option is embedded in 'native-image.properties' file in some zip/jar file all class-names\nand package-names passed to the option have to be found in the zip/jar files the option is embedded\nin. Using '--exact-reachability-metadata' with arguments on command line does not have that restriction.", (Object)this.getContainer(), SubstrateOptions.ThrowMissingRegistrationErrors, (String)"ThrowMissingRegistrationErrors", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ThrowMissingRegistrationErrorsPaths": {
                return OptionDescriptor.create((String)"ThrowMissingRegistrationErrorsPaths", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Trigger exact handling of reflection, resources, JNI, and serialization from all types in the given class-path or module-path entries.\n\nThis option requires arguments that are of the same type as the arguments passed via -p (--module-path) or -cp (--class-path):\n\n  --exact-reachability-metadata-path <class-search path of directories and jar files>\n\nThe given entries are searched and all classes inside are registered as '--exact-reachability-metadata' classes.\n\nThis option is only allowed to be used on command line. The option will be rejected if it is provided\nby 'Args' in a 'native-image.properties' file that is embedded in a jar file.", (Object)this.getContainer(), SubstrateOptions.ThrowMissingRegistrationErrorsPaths, (String)"ThrowMissingRegistrationErrorsPaths", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceClassInitialization": {
                return OptionDescriptor.create((String)"TraceClassInitialization", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Comma-separated list of fully-qualified class names that class initialization is traced for.", (Object)this.getContainer(), SubstrateOptions.TraceClassInitialization, (String)"TraceClassInitialization", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"This option is not required anymore with the strict image heap enabled by default.");
            }
            case "TraceNativeToolUsage": {
                return OptionDescriptor.create((String)"TraceNativeToolUsage", (OptionType)OptionType.User, Boolean.class, (String)"Trace all native tool invocations as part of image building", (Object)this.getContainer(), SubstrateOptions.TraceNativeToolUsage, (String)"TraceNativeToolUsage", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceObjectInstantiation": {
                return OptionDescriptor.create((String)"TraceObjectInstantiation", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Comma-separated list of fully-qualified class names that object instantiation is traced for.", (Object)this.getContainer(), SubstrateOptions.TraceObjectInstantiation, (String)"TraceObjectInstantiation", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceVMOperations": {
                return OptionDescriptor.create((String)"TraceVMOperations", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace VMOperation execution.", (Object)this.getContainer(), SubstrateOptions.TraceVMOperations, (String)"TraceVMOperations", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TrackDynamicAccess": {
                return OptionDescriptor.create((String)"TrackDynamicAccess", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Reports all reflection (e.g., Class#forName(String)) and resource (e.g., Class#getResource(String)) calls in reachable code that require metadata for dynamic access.\nThe analysis is limited to the provided comma-separated list of class-path entries, and module or package names.\nIf any dynamic access calls are found, a \"dynamic-access\" directory is created in the native image output,\nand the calls are serialized in \"dynamic-access/<entry-name>/[reflection-calls.json][resource-calls.json]\".\n\nUsage: -H:TrackDynamicAccess=[all|none|to-console|no-dump|path=<cp-entry>|module=<module>|package=<package>][,...]\n\nThe flag can be used in following ways:\n1. -H:TrackDynamicAccess=all reports all dynamic access calls made across the entire project\n2. -H:TrackDynamicAccess=path=<cp-entry> reports all dynamic access calls made from the specified class-path entry\n3. -H:TrackDynamicAccess=module=<module> reports all dynamic access calls made from the specified module\n4. -H:TrackDynamicAccess=package=<package> reports all dynamic access calls made from the specified package\n5. -H:TrackDynamicAccess=none disables all previous selections for dynamic access detection\n6. -H:TrackDynamicAccess=to-console outputs all detected dynamic access calls to the console\n7. -H:TrackDynamicAccess=no-dump disables the serialization of detected dynamic access calls\n8. A comma-separated list of the previous cases. For example, -H:TrackDynamicAccess=path=<cp-entry>,module=<module>,package=<package>\n\nExample of the option usage:\n\n    native-image -cp lib/app.jar:lib/util.jar:lib/tck.jar -H:TrackDynamicAccess=path=lib/app.jar,path=lib/util.jar HelloWorld\n\n    In this example, the phase will look for dynamic access calls in lib/app.jar and lib/util.jar, and will not detect any calls in lib/tck.jar.", (Object)this.getContainer(), SubstrateOptions.TrackDynamicAccess, (String)"TrackDynamicAccess", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TrackJavaHomeAccess": {
                return OptionDescriptor.create((String)"TrackJavaHomeAccess", (OptionType)OptionType.Debug, Boolean.class, (String)"Track System.getProperty(\\\"java.home\\\") usage in reachable parts of the project.", (Object)this.getContainer(), SubstrateOptions.TrackJavaHomeAccess, (String)"TrackJavaHomeAccess", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TrackJavaHomeAccessDetailed": {
                return OptionDescriptor.create((String)"TrackJavaHomeAccessDetailed", (OptionType)OptionType.Debug, Boolean.class, (String)"Output all System.getProperty(\\\"java.home\\\") calls in reachable parts of the project.", (Object)this.getContainer(), SubstrateOptions.TrackJavaHomeAccessDetailed, (String)"TrackJavaHomeAccessDetailed", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UnlockExperimentalVMOptions": {
                return OptionDescriptor.create((String)"UnlockExperimentalVMOptions", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable and disable normal processing of flags relating to experimental options.", (Object)this.getContainer(), SubstrateOptions.UnlockExperimentalVMOptions, (String)"UnlockExperimentalVMOptions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseBaseLayerInclusionPolicy": {
                return OptionDescriptor.create((String)"UseBaseLayerInclusionPolicy", (OptionType)OptionType.Debug, Boolean.class, (String)"Force include include all public types and methods that can be reached using normal Java access rules.", (Object)this.getContainer(), SubstrateOptions.UseBaseLayerInclusionPolicy, (String)"UseBaseLayerInclusionPolicy", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseCalleeSavedRegisters": {
                return OptionDescriptor.create((String)"UseCalleeSavedRegisters", (OptionType)OptionType.Debug, Boolean.class, (String)"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)", (Object)this.getContainer(), SubstrateOptions.UseCalleeSavedRegisters, (String)"UseCalleeSavedRegisters", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseContainerSupport": {
                return OptionDescriptor.create((String)"UseContainerSupport", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable detection and runtime container configuration support.", (Object)this.getContainer(), SubstrateOptions.UseContainerSupport, (String)"UseContainerSupport", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseDirectCallTrampolinesALot": {
                return OptionDescriptor.create((String)"UseDirectCallTrampolinesALot", (OptionType)OptionType.Debug, Boolean.class, (String)"Force many trampolines to be needed for inter-method calls. Normally trampolines are only used when a method destination is outside the range of a pc-relative branch instruction.", (Object)this.getContainer(), SubstrateOptions.UseDirectCallTrampolinesALot, (String)"UseDirectCallTrampolinesALot", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseImagebuildDebugSections": {
                return OptionDescriptor.create((String)"UseImagebuildDebugSections", (OptionType)OptionType.Debug, Boolean.class, (String)"Emit debuginfo debug.svm.imagebuild.* sections with detailed image-build options.", (Object)this.getContainer(), SubstrateOptions.UseImagebuildDebugSections, (String)"UseImagebuildDebugSections", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseLibC": {
                return OptionDescriptor.create((String)"UseLibC", (OptionType)OptionType.Debug, String.class, (String)"Selects the libc implementation to use. Available implementations: glibc, musl, bionic", (Object)this.getContainer(), SubstrateOptions.UseLibC, (String)"UseLibC", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseNullRegion": {
                return OptionDescriptor.create((String)"UseNullRegion", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a null region is present between the heap base and the image heap.", (Object)this.getContainer(), SubstrateOptions.UseNullRegion, (String)"UseNullRegion", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseOldMethodHandleIntrinsics": {
                return OptionDescriptor.create((String)"UseOldMethodHandleIntrinsics", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated, option no longer has any effect.", (Object)this.getContainer(), SubstrateOptions.UseOldMethodHandleIntrinsics, (String)"UseOldMethodHandleIntrinsics", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"It no longer has any effect, and no replacement is available");
            }
            case "UseSharedLayerGraphs": {
                return OptionDescriptor.create((String)"UseSharedLayerGraphs", (OptionType)OptionType.Debug, Boolean.class, (String)"Persist and reload all graphs across layers. If false, graphs defined in the base layer can be reparsed by the current layer and inlined before analysis, but will not be inlined after analysis has completed via our other inlining infrastructure", (Object)this.getContainer(), SubstrateOptions.UseSharedLayerGraphs, (String)"UseSharedLayerGraphs", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseSharedLayerStrengthenedGraphs": {
                return OptionDescriptor.create((String)"UseSharedLayerStrengthenedGraphs", (OptionType)OptionType.Debug, Boolean.class, (String)"Persist and reload strengthened graphs across layers. If false, inlining after analysis will be disabled", (Object)this.getContainer(), SubstrateOptions.UseSharedLayerStrengthenedGraphs, (String)"UseSharedLayerStrengthenedGraphs", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseSystemLocale": {
                return OptionDescriptor.create((String)"UseSystemLocale", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if the system locale should be used at run-time. If this is disabled, the locale 'en-US' will be used instead.", (Object)this.getContainer(), SubstrateOptions.UseSystemLocale, (String)"UseSystemLocale", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VectorAPISupport": {
                return OptionDescriptor.create((String)"VectorAPISupport", (OptionType)OptionType.Expert, Boolean.class, (String)"Support for intrinsics from the Java Vector API", (Object)this.getContainer(), SubstrateOptions.VectorAPISupport, (String)"VectorAPISupport", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyFrameAccess": {
                return OptionDescriptor.create((String)"VerifyFrameAccess", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if frame accesses are verified at run-time.", (Object)this.getContainer(), SubstrateOptions.VerifyFrameAccess, (String)"VerifyFrameAccess", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyFrameAnchors": {
                return OptionDescriptor.create((String)"VerifyFrameAnchors", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if frame anchors are verified at run-time.", (Object)this.getContainer(), SubstrateOptions.VerifyFrameAnchors, (String)"VerifyFrameAnchors", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyNamingConventions": {
                return OptionDescriptor.create((String)"VerifyNamingConventions", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify naming conventions during image construction.", (Object)this.getContainer(), SubstrateOptions.VerifyNamingConventions, (String)"VerifyNamingConventions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyTypes": {
                return OptionDescriptor.create((String)"VerifyTypes", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify type states computed by the static analysis at run time. This is useful when diagnosing problems in the static analysis, but reduces peak performance significantly.", (Object)this.getContainer(), SubstrateOptions.VerifyTypes, (String)"VerifyTypes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ZapNativeMemory": {
                return OptionDescriptor.create((String)"ZapNativeMemory", (OptionType)OptionType.Debug, Boolean.class, (String)"Fill unused and freed native memory with sentinel values. Needs NMT.", (Object)this.getContainer(), SubstrateOptions.ZapNativeMemory, (String)"ZapNativeMemory", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 168;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTInline");
                    }
                    case 1: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTTrivialInline");
                    }
                    case 2: {
                        return SubstrateOptions_OptionDescriptors.this.get("APIFunctionPrefix");
                    }
                    case 3: {
                        return SubstrateOptions_OptionDescriptors.this.get("AbortOnNameConflict");
                    }
                    case 4: {
                        return SubstrateOptions_OptionDescriptors.this.get("ActiveProcessorCount");
                    }
                    case 5: {
                        return SubstrateOptions_OptionDescriptors.this.get("AdditionalHeaderBytes");
                    }
                    case 6: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocateInstancePrefetchLines");
                    }
                    case 7: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchDistance");
                    }
                    case 8: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchInstr");
                    }
                    case 9: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchLines");
                    }
                    case 10: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStepSize");
                    }
                    case 11: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowDeprecatedBuilderClassesOnImageClasspath");
                    }
                    case 12: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowUnsafeAllocationOfAllInstantiatedTypes");
                    }
                    case 13: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowVMInternalThreads");
                    }
                    case 14: {
                        return SubstrateOptions_OptionDescriptors.this.get("ApplicationLayerInitializedClasses");
                    }
                    case 15: {
                        return SubstrateOptions_OptionDescriptors.this.get("ApplicationLayerOnlySingletons");
                    }
                    case 16: {
                        return SubstrateOptions_OptionDescriptors.this.get("AsyncSignalSafeDiagnostics");
                    }
                    case 17: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputBreakdowns");
                    }
                    case 18: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputColorful");
                    }
                    case 19: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputGCWarnings");
                    }
                    case 20: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputJSONFile");
                    }
                    case 21: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputLinks");
                    }
                    case 22: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputPrefix");
                    }
                    case 23: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputProgress");
                    }
                    case 24: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputRecommendations");
                    }
                    case 25: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputSilent");
                    }
                    case 26: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerOption");
                    }
                    case 27: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerPath");
                    }
                    case 28: {
                        return SubstrateOptions_OptionDescriptors.this.get("CLibraryPath");
                    }
                    case 29: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckBootModuleDependencies");
                    }
                    case 30: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckIsolateThreadAtEntry");
                    }
                    case 31: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckToolchain");
                    }
                    case 32: {
                        return SubstrateOptions_OptionDescriptors.this.get("Class");
                    }
                    case 33: {
                        return SubstrateOptions_OptionDescriptors.this.get("ClosedTypeWorld");
                    }
                    case 34: {
                        return SubstrateOptions_OptionDescriptors.this.get("ClosedTypeWorldHubLayout");
                    }
                    case 35: {
                        return SubstrateOptions_OptionDescriptors.this.get("Color");
                    }
                    case 36: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilationIsolateAddressSpaceSize");
                    }
                    case 37: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilationIsolateOptions");
                    }
                    case 38: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilerBackend");
                    }
                    case 39: {
                        return SubstrateOptions_OptionDescriptors.this.get("ConfigureReflectionMetadata");
                    }
                    case 40: {
                        return SubstrateOptions_OptionDescriptors.this.get("ContendedPaddingWidth");
                    }
                    case 41: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogExitOnTimeout");
                    }
                    case 42: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogInterval");
                    }
                    case 43: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugCodeInfoMaxDepth");
                    }
                    case 44: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugCodeInfoUseSourceMappings");
                    }
                    case 45: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugInfoSourceCacheRoot");
                    }
                    case 46: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeleteLocalSymbols");
                    }
                    case 47: {
                        return SubstrateOptions_OptionDescriptors.this.get("DetectUserDirectoriesInImageHeap");
                    }
                    case 48: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticBufferSize");
                    }
                    case 49: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticDetails");
                    }
                    case 50: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableSubstitution");
                    }
                    case 51: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableTypeIdResultVerification");
                    }
                    case 52: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableURLProtocols");
                    }
                    case 53: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpHeapAndExit");
                    }
                    case 54: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpTargetInfo");
                    }
                    case 55: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableAllSecurityServices");
                    }
                    case 56: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableSignalHandling");
                    }
                    case 57: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableURLProtocols");
                    }
                    case 58: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableWildcardExpansion");
                    }
                    case 59: {
                        return SubstrateOptions_OptionDescriptors.this.get("EntryPointNamePrefix");
                    }
                    case 60: {
                        return SubstrateOptions_OptionDescriptors.this.get("FallbackThreshold");
                    }
                    case 61: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorder");
                    }
                    case 62: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorderLogging");
                    }
                    case 63: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorderOptions");
                    }
                    case 64: {
                        return SubstrateOptions_OptionDescriptors.this.get("FoldSecurityManagerGetter");
                    }
                    case 65: {
                        return SubstrateOptions_OptionDescriptors.this.get("ForeignAPISupport");
                    }
                    case 66: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateBuildArtifactsFile");
                    }
                    case 67: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateDebugInfo");
                    }
                    case 68: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpDefaultFilenamePrefix");
                    }
                    case 69: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpOnOutOfMemoryError");
                    }
                    case 70: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpPath");
                    }
                    case 71: {
                        return SubstrateOptions_OptionDescriptors.this.get("IgnorePreserveForClasses");
                    }
                    case 72: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImageBuildID");
                    }
                    case 73: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImageSymbolsPrefix");
                    }
                    case 74: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeDebugHelperMethods");
                    }
                    case 75: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeMethodData");
                    }
                    case 76: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeNodeSourcePositions");
                    }
                    case 77: {
                        return SubstrateOptions_OptionDescriptors.this.get("InstallExitHandlers");
                    }
                    case 78: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalSymbolsAreGlobal");
                    }
                    case 79: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalThreadStackSize");
                    }
                    case 80: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNI");
                    }
                    case 81: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIEnhancedErrorCodes");
                    }
                    case 82: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIExportSymbols");
                    }
                    case 83: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIVerboseLookupErrors");
                    }
                    case 84: {
                        return SubstrateOptions_OptionDescriptors.this.get("JVMTI");
                    }
                    case 85: {
                        return SubstrateOptions_OptionDescriptors.this.get("JVMTIAgentLib");
                    }
                    case 86: {
                        return SubstrateOptions_OptionDescriptors.this.get("JVMTIAgentPath");
                    }
                    case 87: {
                        return SubstrateOptions_OptionDescriptors.this.get("LayerCreate");
                    }
                    case 88: {
                        return SubstrateOptions_OptionDescriptors.this.get("LayerOptionVerification");
                    }
                    case 89: {
                        return SubstrateOptions_OptionDescriptors.this.get("LayerOptionVerificationVerbose");
                    }
                    case 90: {
                        return SubstrateOptions_OptionDescriptors.this.get("LayerUse");
                    }
                    case 91: {
                        return SubstrateOptions_OptionDescriptors.this.get("LibGraalClassLoader");
                    }
                    case 92: {
                        return SubstrateOptions_OptionDescriptors.this.get("LinkerRPath");
                    }
                    case 93: {
                        return SubstrateOptions_OptionDescriptors.this.get("LoggingHashCodeInjection");
                    }
                    case 94: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxDirectMemorySize");
                    }
                    case 95: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxInvokesInTrivialMethod");
                    }
                    case 96: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesAfterTrivialInlining");
                    }
                    case 97: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialLeafMethod");
                    }
                    case 98: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialMethod");
                    }
                    case 99: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxUnrolledObjectZeroingStores");
                    }
                    case 100: {
                        return SubstrateOptions_OptionDescriptors.this.get("Method");
                    }
                    case 101: {
                        return SubstrateOptions_OptionDescriptors.this.get("MissingRegistrationReportingMode");
                    }
                    case 102: {
                        return SubstrateOptions_OptionDescriptors.this.get("MissingRegistrationWarnContextLines");
                    }
                    case 103: {
                        return SubstrateOptions_OptionDescriptors.this.get("Module");
                    }
                    case 104: {
                        return SubstrateOptions_OptionDescriptors.this.get("MremapImageHeap");
                    }
                    case 105: {
                        return SubstrateOptions_OptionDescriptors.this.get("MultiThreaded");
                    }
                    case 106: {
                        return SubstrateOptions_OptionDescriptors.this.get("Name");
                    }
                    case 107: {
                        return SubstrateOptions_OptionDescriptors.this.get("NeverInline");
                    }
                    case 108: {
                        return SubstrateOptions_OptionDescriptors.this.get("NoDirectRelocationsInText");
                    }
                    case 109: {
                        return SubstrateOptions_OptionDescriptors.this.get("OmitInlinedMethodDebugLineInfo");
                    }
                    case 110: {
                        return SubstrateOptions_OptionDescriptors.this.get("Optimize");
                    }
                    case 111: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnce");
                    }
                    case 112: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnceJIT");
                    }
                    case 113: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseRuntimeOptions");
                    }
                    case 114: {
                        return SubstrateOptions_OptionDescriptors.this.get("PinnedObjectAddressing");
                    }
                    case 115: {
                        return SubstrateOptions_OptionDescriptors.this.get("Preserve");
                    }
                    case 116: {
                        return SubstrateOptions_OptionDescriptors.this.get("PreserveFramePointer");
                    }
                    case 117: {
                        return SubstrateOptions_OptionDescriptors.this.get("PrintClosedArenaUponThrow");
                    }
                    case 118: {
                        return SubstrateOptions_OptionDescriptors.this.get("PrintVMInfoAndExit");
                    }
                    case 119: {
                        return SubstrateOptions_OptionDescriptors.this.get("ReduceImplicitExceptionStackTraceInformation");
                    }
                    case 120: {
                        return SubstrateOptions_OptionDescriptors.this.get("RelativeCodePointers");
                    }
                    case 121: {
                        return SubstrateOptions_OptionDescriptors.this.get("RemoveUnusedSymbols");
                    }
                    case 122: {
                        return SubstrateOptions_OptionDescriptors.this.get("ReportAnalysisForbiddenType");
                    }
                    case 123: {
                        return SubstrateOptions_OptionDescriptors.this.get("RunMainInNewThread");
                    }
                    case 124: {
                        return SubstrateOptions_OptionDescriptors.this.get("SharedArenaSupport");
                    }
                    case 125: {
                        return SubstrateOptions_OptionDescriptors.this.get("SharedLibrary");
                    }
                    case 126: {
                        return SubstrateOptions_OptionDescriptors.this.get("SourceLevelDebug");
                    }
                    case 127: {
                        return SubstrateOptions_OptionDescriptors.this.get("SourceLevelDebugFilter");
                    }
                    case 128: {
                        return SubstrateOptions_OptionDescriptors.this.get("SpawnIsolates");
                    }
                    case 129: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackSize");
                    }
                    case 130: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackTrace");
                    }
                    case 131: {
                        return SubstrateOptions_OptionDescriptors.this.get("StartFlightRecording");
                    }
                    case 132: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutable");
                    }
                    case 133: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutableWithDynamicLibC");
                    }
                    case 134: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticLibStdCpp");
                    }
                    case 135: {
                        return SubstrateOptions_OptionDescriptors.this.get("StrictQueryCodeCompilation");
                    }
                    case 136: {
                        return SubstrateOptions_OptionDescriptors.this.get("StripDebugInfo");
                    }
                    case 137: {
                        return SubstrateOptions_OptionDescriptors.this.get("SupportedGCs");
                    }
                    case 138: {
                        return SubstrateOptions_OptionDescriptors.this.get("TargetPlatform");
                    }
                    case 139: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownWarningSeconds");
                    }
                    case 140: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowLinkAtBuildTimeIOExceptions");
                    }
                    case 141: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowMissingRegistrationErrors");
                    }
                    case 142: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowMissingRegistrationErrorsPaths");
                    }
                    case 143: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceClassInitialization");
                    }
                    case 144: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceNativeToolUsage");
                    }
                    case 145: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceObjectInstantiation");
                    }
                    case 146: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceVMOperations");
                    }
                    case 147: {
                        return SubstrateOptions_OptionDescriptors.this.get("TrackDynamicAccess");
                    }
                    case 148: {
                        return SubstrateOptions_OptionDescriptors.this.get("TrackJavaHomeAccess");
                    }
                    case 149: {
                        return SubstrateOptions_OptionDescriptors.this.get("TrackJavaHomeAccessDetailed");
                    }
                    case 150: {
                        return SubstrateOptions_OptionDescriptors.this.get("UnlockExperimentalVMOptions");
                    }
                    case 151: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseBaseLayerInclusionPolicy");
                    }
                    case 152: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCalleeSavedRegisters");
                    }
                    case 153: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseContainerSupport");
                    }
                    case 154: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDirectCallTrampolinesALot");
                    }
                    case 155: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseImagebuildDebugSections");
                    }
                    case 156: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseLibC");
                    }
                    case 157: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseNullRegion");
                    }
                    case 158: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseOldMethodHandleIntrinsics");
                    }
                    case 159: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseSharedLayerGraphs");
                    }
                    case 160: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseSharedLayerStrengthenedGraphs");
                    }
                    case 161: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseSystemLocale");
                    }
                    case 162: {
                        return SubstrateOptions_OptionDescriptors.this.get("VectorAPISupport");
                    }
                    case 163: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyFrameAccess");
                    }
                    case 164: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyFrameAnchors");
                    }
                    case 165: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyNamingConventions");
                    }
                    case 166: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyTypes");
                    }
                    case 167: {
                        return SubstrateOptions_OptionDescriptors.this.get("ZapNativeMemory");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

