/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import java.lang.reflect.Type;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

@AutomaticallyRegisteredFeature
final class StaticFieldsFeature
implements InternalFeature {
    StaticFieldsFeature() {
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), StaticFieldsSupport.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getStaticObjectFieldsAtRuntime", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode layerNum) {
                if (!ImageLayerBuildingSupport.buildingImageLayer()) {
                    b.addPush(JavaKind.Object, (ValueNode)new StaticFieldsSupport.StaticFieldResolvedBaseNode(false, -1));
                    return true;
                }
                if (layerNum.isJavaConstant()) {
                    int num = layerNum.asJavaConstant().asInt();
                    b.addPush(JavaKind.Object, (ValueNode)new StaticFieldsSupport.StaticFieldResolvedBaseNode(false, num));
                    return true;
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getStaticPrimitiveFieldsAtRuntime", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode layerNum) {
                if (!ImageLayerBuildingSupport.buildingImageLayer()) {
                    b.addPush(JavaKind.Object, (ValueNode)new StaticFieldsSupport.StaticFieldResolvedBaseNode(true, -1));
                    return true;
                }
                if (layerNum.isJavaConstant()) {
                    int num = layerNum.asJavaConstant().asInt();
                    b.addPush(JavaKind.Object, (ValueNode)new StaticFieldsSupport.StaticFieldResolvedBaseNode(true, num));
                    return true;
                }
                return false;
            }
        });
    }
}

