/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import java.util.EnumSet;
import java.util.Objects;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
class MultiLayeredStaticFieldsBase
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private Object[] staticObjectFields = null;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private byte[] staticPrimitiveFields = null;

    MultiLayeredStaticFieldsBase() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static MultiLayeredStaticFieldsBase currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(MultiLayeredStaticFieldsBase.class, false, true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static MultiLayeredStaticFieldsBase forLayer(int layerNum) {
        return MultiLayeredImageSingleton.getForLayer(MultiLayeredStaticFieldsBase.class, layerNum);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Object[] getObjectFields() {
        return this.staticObjectFields;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    byte[] getPrimitiveFields() {
        return this.staticPrimitiveFields;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void setData(Object[] objectFields, byte[] primitiveFields) {
        this.staticObjectFields = Objects.requireNonNull(objectFields);
        this.staticPrimitiveFields = Objects.requireNonNull(primitiveFields);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

