/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.InitializeReservedRegistersPrologue;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.function.BooleanSupplier;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class DebugHelper {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getArrayElementSize(DynamicHub hub) {
        if (hub.isArray()) {
            return LayoutEncoding.getArrayIndexScale(hub.getLayoutEncoding());
        }
        return -1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getArrayBaseOffset(DynamicHub hub) {
        if (hub.isArray()) {
            return LayoutEncoding.getArrayIndexScale(hub.getLayoutEncoding());
        }
        return -1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isArray(DynamicHub hub) {
        return LayoutEncoding.isArray(hub.getLayoutEncoding());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isPrimitiveArray(DynamicHub hub) {
        return LayoutEncoding.isPrimitiveArray(hub.getLayoutEncoding());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isObjectArray(DynamicHub hub) {
        return LayoutEncoding.isObjectArray(hub.getLayoutEncoding());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isInstance(DynamicHub hub) {
        return LayoutEncoding.isPureInstance(hub.getLayoutEncoding());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isReference(DynamicHub hub) {
        return hub.isReferenceInstanceClass();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final class IncludeDebugHelperMethods
    implements BooleanSupplier {
        private IncludeDebugHelperMethods() {
        }

        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.IncludeDebugHelperMethods.getValue();
        }
    }

    static class DiagnosticDebugHelper {
        DiagnosticDebugHelper() {
        }

        @Uninterruptible(reason="Called with a raw object pointer.", calleeMustBe=false)
        @CEntryPoint(name="svm_dbg_print_hub", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static void printHub(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            Log.log().string(hub.getName()).newline();
        }

        @Uninterruptible(reason="Called with a raw object pointer.", calleeMustBe=false)
        @CEntryPoint(name="svm_dbg_print_obj", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static void printObject(IsolateThread thread, Pointer objPtr) {
            SubstrateDiagnostics.printObjectInfo(Log.log(), objPtr.toObject());
            Log.log().newline();
        }

        @Uninterruptible(reason="Called with a raw object pointer.", calleeMustBe=false)
        @CEntryPoint(name="svm_dbg_print_string", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static void printString(IsolateThread thread, Pointer strPtr) {
            String str = (String)strPtr.toObject();
            Log.log().string(str).newline();
        }

        @Uninterruptible(reason="Just to keep the verification happy.", calleeMustBe=false)
        @CEntryPoint(name="svm_dbg_print_fatalErrorDiagnostics", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static void printFatalErrorDiagnostics(IsolateThread thread, Pointer sp, CodePointer ip) {
            SubstrateDiagnostics.printFatalError(Log.log(), sp, ip, (RegisterDumper.Context)Word.nullPointer(), false);
        }

        @Uninterruptible(reason="Just to keep the verification happy.", calleeMustBe=false)
        @CEntryPoint(name="svm_dbg_print_locationInfo", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static void printLocationInfo(IsolateThread thread, Pointer mem) {
            SubstrateDiagnostics.printLocationInfo(Log.log(), (UnsignedWord)mem, true, true);
        }
    }

    static class StringDebugHelper {
        StringDebugHelper() {
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_string_length", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static int getStringLength(IsolateThread thread, Pointer strPtr) {
            String str = (String)strPtr.toObject();
            return str.length();
        }
    }

    static class ObjectDebugHelper {
        ObjectDebugHelper() {
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_getHub", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static long getHub(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            return Word.objectToUntrackedPointer((Object)KnownIntrinsics.readHub(obj)).rawValue();
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_getObjectSize", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static long getObjectSize(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            return LayoutEncoding.getSizeFromObject(obj).rawValue();
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_getArrayElementSize", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static int getArrayElementSize(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.getArrayElementSize(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_getArrayBaseOffset", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static long getArrayBaseOffset(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.getArrayBaseOffset(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_isArray", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isArray(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.isArray(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_isPrimitiveArray", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isPrimitiveArray(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.isPrimitiveArray(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_isObjectArray", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isObjectArray(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.isObjectArray(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_isInstance", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isInstance(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.isInstance(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_isReference", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isReference(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            return DebugHelper.isReference(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_uncompress", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static long uncompressObjectPointer(IsolateThread thread, Pointer compressedPtr) {
            return Word.objectToUntrackedPointer((Object)ReferenceAccess.singleton().uncompressReference((UnsignedWord)compressedPtr)).rawValue();
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_obj_compress", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static long compressObjectPointer(IsolateThread thread, Pointer objPtr) {
            Object obj = objPtr.toObject();
            return ReferenceAccess.singleton().getCompressedRepresentation(obj).rawValue();
        }
    }

    static class HubDebugHelper {
        HubDebugHelper() {
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_getLayoutEncoding", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static int getLayoutEncoding(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return hub.getLayoutEncoding();
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_getArrayElementSize", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static int getArrayElementSize(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.getArrayElementSize(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_getArrayBaseOffset", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static int getArrayBaseOffset(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.getArrayBaseOffset(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_isArray", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isArray(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.isArray(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_isPrimitiveArray", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isPrimitiveArray(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.isPrimitiveArray(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_isObjectArray", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isObjectArray(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.isObjectArray(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_isInstance", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isInstance(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.isInstance(hub);
        }

        @Uninterruptible(reason="Called with a raw object pointer.")
        @CEntryPoint(name="svm_dbg_hub_isReference", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isReference(IsolateThread thread, Pointer hubPtr) {
            DynamicHub hub = (DynamicHub)hubPtr.toObject();
            return DebugHelper.isReference(hub);
        }
    }

    static class PointerDebugHelper {
        PointerDebugHelper() {
        }

        @Uninterruptible(reason="Called with a raw pointer.")
        @CEntryPoint(name="svm_dbg_ptr_isInImageHeap", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isInImageHeap(IsolateThread thread, Pointer ptr) {
            return Heap.getHeap().isInImageHeap(ptr);
        }

        @Uninterruptible(reason="Called with a raw pointer.")
        @CEntryPoint(name="svm_dbg_ptr_isObject", include=IncludeDebugHelperMethods.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=InitializeReservedRegistersPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static boolean isObject(IsolateThread thread, Pointer ptr) {
            ObjectHeader header = Heap.getHeap().getObjectHeader();
            return header.pointsToObjectHeader(ptr);
        }
    }
}

