/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.nativebridge;

import com.oracle.svm.jdwp.bridge.nativebridge.BinaryInput;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryOutput;
import com.oracle.svm.jdwp.bridge.nativebridge.StackTraceElementMarshaller;

final class DefaultStackTraceMarshaller
implements BinaryMarshaller<StackTraceElement[]> {
    static final DefaultStackTraceMarshaller INSTANCE = new DefaultStackTraceMarshaller();

    private DefaultStackTraceMarshaller() {
    }

    @Override
    public StackTraceElement[] read(BinaryInput in) {
        int len = in.readInt();
        StackTraceElement[] res = new StackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            res[i] = StackTraceElementMarshaller.INSTANCE.read(in);
        }
        return res;
    }

    @Override
    public void write(BinaryOutput out, StackTraceElement[] stack) {
        out.writeInt(stack.length);
        for (StackTraceElement stackTraceElement : stack) {
            StackTraceElementMarshaller.INSTANCE.write(out, stackTraceElement);
        }
    }

    @Override
    public int inferSize(StackTraceElement[] object) {
        return object.length == 0 ? 0 : object.length * StackTraceElementMarshaller.INSTANCE.inferSize(object[0]);
    }
}

