/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.imagelayer.CapnProtoAdapters;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class SVMImageLayerSingletonLoader {
    private final HostedImageLayerBuildingSupport imageLayerBuildingSupport;
    private final SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot;
    private Map<Class<?>, Integer> initialLayerOnlySingletonConstantIds;

    public SVMImageLayerSingletonLoader(HostedImageLayerBuildingSupport imageLayerBuildingSupport, SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot) {
        this.imageLayerBuildingSupport = imageLayerBuildingSupport;
        this.snapshot = snapshot;
    }

    public Map<Object, Set<Class<?>>> loadImageSingletons(Object forbiddenObject) {
        HashMap<Integer, Object> idToObjectMap = new HashMap<Integer, Object>();
        HashMap initialLayerKeyToIdMap = new HashMap();
        for (SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Reader obj : this.snapshot.getSingletonObjects()) {
            Object result;
            String className = obj.getClassName().toString();
            EconomicMap keyStore = EconomicMap.create();
            for (SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Reader entry : obj.getStore()) {
                SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Reader v = entry.getValue();
                String[] value = switch (v.which()) {
                    default -> throw new MatchException(null, null);
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which.I -> v.getI();
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which.J -> v.getJ();
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which.STR -> v.getStr().toString();
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which.IL -> (String[])CapnProtoAdapters.toIntArray(v.getIl());
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which.ZL -> (String[])CapnProtoAdapters.toBooleanArray(v.getZl());
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which.STRL -> CapnProtoAdapters.toStringArray(v.getStrl());
                    case SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Value.Which._NOT_IN_SCHEMA -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)v.which()));
                };
                keyStore.put((Object)entry.getKey().toString(), (Object)value);
            }
            try {
                Class<?> clazz = this.imageLayerBuildingSupport.lookupClass(false, className);
                Method createMethod = ReflectionUtil.lookupMethod(clazz, (String)"createFromLoader", (Class[])new Class[]{ImageSingletonLoader.class});
                result = createMethod.invoke(null, new ImageSingletonLoaderImpl((UnmodifiableEconomicMap<String, Object>)keyStore, this.snapshot));
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere("Failed to recreate image singleton", t);
            }
            idToObjectMap.put(obj.getId(), result);
        }
        HashMap singletonInitializationMap = new HashMap();
        for (SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Reader entry : this.snapshot.getSingletonKeys()) {
            String className = entry.getKeyClassName().toString();
            LayeredImageSingleton.PersistFlags persistInfo = LayeredImageSingleton.PersistFlags.values()[entry.getPersistFlag()];
            int id = entry.getObjectId();
            if (persistInfo == LayeredImageSingleton.PersistFlags.CREATE) {
                assert (id != -1) : "Create image singletons should be linked to an object";
                Object singletonObject = idToObjectMap.get(id);
                Class<?> clazz = this.imageLayerBuildingSupport.lookupClass(false, className);
                singletonInitializationMap.computeIfAbsent(singletonObject, k -> new HashSet());
                ((Set)singletonInitializationMap.get(singletonObject)).add(clazz);
                continue;
            }
            if (persistInfo == LayeredImageSingleton.PersistFlags.FORBIDDEN) {
                int constantId;
                assert (id == -1) : "Unrestored image singleton should not be linked to an object";
                Class<?> clazz = this.imageLayerBuildingSupport.lookupClass(false, className);
                singletonInitializationMap.computeIfAbsent(forbiddenObject, k -> new HashSet());
                ((Set)singletonInitializationMap.get(forbiddenObject)).add(clazz);
                if (!InitialLayerOnlyImageSingleton.class.isAssignableFrom(clazz) || (constantId = entry.getConstantId()) == -1) continue;
                initialLayerKeyToIdMap.put(clazz, constantId);
                continue;
            }
            assert (persistInfo == LayeredImageSingleton.PersistFlags.NOTHING) : "Unexpected PersistFlags value: " + String.valueOf((Object)persistInfo);
            assert (id == -1) : "Unrestored image singleton should not be linked to an object";
        }
        this.initialLayerOnlySingletonConstantIds = Map.copyOf(initialLayerKeyToIdMap);
        return singletonInitializationMap;
    }

    public JavaConstant loadInitialLayerOnlyImageSingleton(Class<?> key) {
        int constantId = this.initialLayerOnlySingletonConstantIds.getOrDefault(key, -1);
        if (constantId != -1) {
            return this.imageLayerBuildingSupport.getLoader().getOrCreateConstant(constantId);
        }
        throw UserError.abort("Unable to load InitialLayerOnlyImageSingleton: %s. Please override accessibleInFutureLayers if you want this singleton to be reachable in future layers.", key);
    }

    public Class<?> lookupClass(boolean optional, String className) {
        return this.imageLayerBuildingSupport.lookupClass(optional, className);
    }

    public static class ImageSingletonLoaderImpl
    implements ImageSingletonLoader {
        private final UnmodifiableEconomicMap<String, Object> keyStore;
        private final SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshotReader;

        ImageSingletonLoaderImpl(UnmodifiableEconomicMap<String, Object> keyStore, SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshotReader) {
            this.keyStore = keyStore;
            this.snapshotReader = snapshotReader;
        }

        @Override
        public List<Boolean> readBoolList(String keyName) {
            boolean[] l = (boolean[])this.keyStore.get((Object)keyName);
            return IntStream.range(0, l.length).mapToObj(i -> l[i]).toList();
        }

        @Override
        public int readInt(String keyName) {
            return (Integer)this.keyStore.get((Object)keyName);
        }

        @Override
        public List<Integer> readIntList(String keyName) {
            int[] l = (int[])this.keyStore.get((Object)keyName);
            return IntStream.of(l).boxed().toList();
        }

        @Override
        public long readLong(String keyName) {
            return (Long)this.keyStore.get((Object)keyName);
        }

        @Override
        public String readString(String keyName) {
            return (String)this.keyStore.get((Object)keyName);
        }

        @Override
        public List<String> readStringList(String keyName) {
            return List.of((String[])this.keyStore.get((Object)keyName));
        }

        public SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader getSnapshotReader() {
            return this.snapshotReader;
        }
    }
}

