/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.Parker;
import com.oracle.svm.core.util.BasedOnJDKFile;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class PosixParker
extends Parker {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long EVENT_OFFSET = U.objectFieldOffset(PosixParker.class, "event");
    private Pthread.pthread_mutex_t mutex;
    private Pthread.pthread_cond_t relativeCond;
    private Pthread.pthread_cond_t absoluteCond;
    private Pthread.pthread_cond_t currentCond;
    private volatile int event = 0;

    PosixParker() {
        UnsignedWord mutexSize = SizeOf.unsigned(Pthread.pthread_mutex_t.class);
        UnsignedWord condSize = SizeOf.unsigned(Pthread.pthread_cond_t.class);
        Pointer memory = (Pointer)NativeMemory.malloc(mutexSize.add(condSize.multiply(2)), NmtCategory.Threading);
        this.mutex = (Pthread.pthread_mutex_t)memory;
        this.relativeCond = (Pthread.pthread_cond_t)memory.add(mutexSize);
        this.absoluteCond = (Pthread.pthread_cond_t)memory.add(mutexSize).add(condSize);
        Pthread.pthread_mutexattr_t mutexAttr = (Pthread.pthread_mutexattr_t)Word.nullPointer();
        PosixUtils.checkStatusIs0(Pthread.pthread_mutex_init(this.mutex, mutexAttr), "mutex initialization");
        PosixUtils.checkStatusIs0(PthreadConditionUtils.initConditionWithRelativeTime(this.relativeCond), "relative-time condition variable initialization");
        PosixUtils.checkStatusIs0(PthreadConditionUtils.initConditionWithAbsoluteTime(this.absoluteCond), "absolute-time condition variable initialization");
    }

    @Override
    protected void reset() {
        this.event = 0;
    }

    @Override
    protected boolean tryFastPark() {
        return U.getAndSetInt(this, EVENT_OFFSET, 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void park(boolean isAbsolute, long time) {
        assert (!(time < 0L || isAbsolute && time == 0L)) : "must not be called otherwise";
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            this.park0(isAbsolute, time);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/os/posix/os_posix.cpp#L1662-L1738")
    private void park0(boolean isAbsolute, long time) {
        int status = Pthread.pthread_mutex_trylock_no_transition(this.mutex);
        if (status == Errno.EBUSY()) {
            return;
        }
        PosixUtils.checkStatusIs0(status, "park: mutex_trylock");
        try {
            if (this.event == 0) {
                assert (this.currentCond.isNull());
                try {
                    if (time == 0L) {
                        this.currentCond = this.relativeCond;
                        status = Pthread.pthread_cond_wait(this.currentCond, this.mutex);
                    } else {
                        this.currentCond = isAbsolute ? this.absoluteCond : this.relativeCond;
                        Time.timespec deadline = UnsafeStackValue.get(Time.timespec.class);
                        PthreadConditionUtils.fillTimespec(deadline, time, isAbsolute);
                        status = Pthread.pthread_cond_timedwait(this.currentCond, this.mutex, deadline);
                    }
                    assert (status == 0 || status == Errno.ETIMEDOUT());
                }
                finally {
                    this.currentCond = (Pthread.pthread_cond_t)Word.nullPointer();
                }
            }
            this.event = 0;
        }
        finally {
            PosixUtils.checkStatusIs0(Pthread.pthread_mutex_unlock(this.mutex), "park: mutex_unlock");
            U.fullFence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/os/posix/os_posix.cpp#L1740-L1763")
    protected void unpark() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            Pthread.pthread_cond_t p;
            int s;
            int status = Pthread.pthread_mutex_trylock_no_transition(this.mutex);
            if (status == Errno.EBUSY()) {
                status = Pthread.pthread_mutex_lock(this.mutex);
            }
            PosixUtils.checkStatusIs0(status, "PosixParker.unpark(): mutex lock");
            try {
                s = this.event;
                this.event = 1;
                p = this.currentCond;
            }
            finally {
                PosixUtils.checkStatusIs0(Pthread.pthread_mutex_unlock(this.mutex), "PosixParker.unpark(): mutex unlock");
            }
            if (s == 0 && p.isNonNull()) {
                PosixUtils.checkStatusIs0(Pthread.pthread_cond_signal(p), "PosixParker.unpark(): condition variable signal");
            }
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void release() {
        int status = Pthread.pthread_cond_destroy(this.relativeCond);
        assert (status == 0);
        this.relativeCond = (Pthread.pthread_cond_t)Word.nullPointer();
        status = Pthread.pthread_cond_destroy(this.absoluteCond);
        assert (status == 0);
        this.absoluteCond = (Pthread.pthread_cond_t)Word.nullPointer();
        status = Pthread.pthread_mutex_destroy(this.mutex);
        assert (status == 0);
        NativeMemory.free(this.mutex);
        this.mutex = (Pthread.pthread_mutex_t)Word.nullPointer();
    }
}

