/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti.headers;

import com.oracle.svm.core.jvmti.headers.JvmtiDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;

@CContext(value=JvmtiDirectives.class)
public final class JvmtiVersion {
    private static final int JVMTI_VERSION_INTERFACE_JVMTI = 0x30000000;
    private static final int LATEST_SUPPORTED_MAJOR_VERSION = 21;
    public static final int CURRENT_VERSION = 806682624;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JvmtiVersion() {
    }

    public static boolean isSupported(int version) {
        if (JvmtiVersion.isJvmtiVersion(version)) {
            return JvmtiVersion.isSupported0(version);
        }
        return false;
    }

    private static boolean isJvmtiVersion(int version) {
        return (version & JvmtiVersion.JVMTI_VERSION_MASK_INTERFACE_TYPE()) == 0x30000000;
    }

    private static boolean isSupported0(int version) {
        int major = (version & JvmtiVersion.JVMTI_VERSION_MASK_MAJOR()) >> JvmtiVersion.JVMTI_VERSION_SHIFT_MAJOR();
        int minor = (version & JvmtiVersion.JVMTI_VERSION_MASK_MINOR()) >> JvmtiVersion.JVMTI_VERSION_SHIFT_MINOR();
        if (major == 1) {
            return minor >= 0 && minor <= 2;
        }
        if (major == 9 || major == 11) {
            return minor == 0;
        }
        return major >= 13 && major <= 21;
    }

    @CConstant
    private static native int JVMTI_VERSION_MASK_INTERFACE_TYPE();

    @CConstant
    private static native int JVMTI_VERSION_MASK_MAJOR();

    @CConstant
    private static native int JVMTI_VERSION_MASK_MINOR();

    @CConstant
    private static native int JVMTI_VERSION_SHIFT_MAJOR();

    @CConstant
    private static native int JVMTI_VERSION_SHIFT_MINOR();
}

