/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.TimeZoneSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class TimeZoneFeature
implements InternalFeature {
    TimeZoneFeature() {
    }

    private static byte[] cleanCR(byte[] buffer) {
        byte[] scratch = new byte[buffer.length];
        int copied = 0;
        for (byte b : buffer) {
            if (b == 13) continue;
            scratch[copied++] = b;
        }
        byte[] content = new byte[copied];
        System.arraycopy(scratch, 0, content, 0, copied);
        return content;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (OS.getCurrent() != OS.WINDOWS) {
            return;
        }
        Path tzMappingsPath = Paths.get(System.getProperty("java.home"), "lib", "tzmappings");
        try {
            byte[] buffer = Files.readAllBytes(tzMappingsPath);
            byte[] content = TimeZoneFeature.cleanCR(buffer);
            ImageSingletons.add(TimeZoneSupport.class, (Object)new TimeZoneSupport(content));
        }
        catch (IOException e) {
            VMError.shouldNotReachHere("Failed to read time zone mappings. The time zone mappings should be partof your JDK usually found: " + String.valueOf(tzMappingsPath.toAbsolutePath()), e);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        TimeZoneFeature.ensureStableTzdbZoneRulesProviderProvideRules();
    }

    private static void ensureStableTzdbZoneRulesProviderProvideRules() {
        ZoneId.systemDefault();
    }

    static class Options {
        public static final HostedOptionKey<Boolean> IncludeAllTimeZones = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                Options.printWarning();
            }
        };
        public static final HostedOptionKey<String> IncludeTimeZones = new HostedOptionKey<String>(""){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                Options.printWarning();
            }
        };

        Options() {
        }

        private static void printWarning() {
            System.err.println("-H:IncludeAllTimeZones and -H:IncludeTimeZones are now deprecated. Native-image includes all timezones by default.");
        }
    }
}

