/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.imagelayer.LoadImageSingletonFactory;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_2)
public class LoadImageSingletonNode
extends FixedWithNextNode
implements Lowerable,
Canonicalizable {
    public static final NodeClass<LoadImageSingletonNode> TYPE = NodeClass.create(LoadImageSingletonNode.class);
    private final LoadImageSingletonFactory.LoadImageSingletonData singletonInfo;

    protected LoadImageSingletonNode(LoadImageSingletonFactory.LoadImageSingletonData singletonInfo, Stamp stamp) {
        super(TYPE, stamp);
        this.singletonInfo = singletonInfo;
    }

    public static LoadImageSingletonNode createLoadImageSingleton(LoadImageSingletonFactory.LoadImageSingletonData singletonInfo, MetaAccessProvider metaAccess) {
        return new LoadImageSingletonNode(singletonInfo, (Stamp)StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)metaAccess.lookupJavaType(singletonInfo.getLoadType()))));
    }

    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (this.singletonInfo.isApplicationLayerConstant()) {
            return this.singletonInfo.asApplicationLayerConstant(tool.getMetaAccess(), tool.getSnippetReflection());
        }
        return this;
    }

    public void lower(LoweringTool tool) {
        StructuredGraph graph = this.graph();
        LoadImageSingletonFactory.SingletonAccessInfo singletonAccessInfo = this.singletonInfo.getAccessInfo();
        CGlobalDataLoadAddressNode baseAddress = (CGlobalDataLoadAddressNode)graph.unique((Node)new CGlobalDataLoadAddressNode(singletonAccessInfo.tableBase()));
        AddressNode address = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)baseAddress, (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)singletonAccessInfo.offset(), (StructuredGraph)graph)));
        AbstractObjectStamp tableReadStamp = SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)this.stamp(NodeView.DEFAULT), ReferenceAccess.singleton().getCompressEncoding());
        ReadNode tableRead = (ReadNode)graph.add((Node)new ReadNode(address, NamedLocationIdentity.FINAL_LOCATION, (Stamp)tableReadStamp, BarrierType.NONE, MemoryOrderMode.PLAIN));
        SubstrateCompressionNode uncompress = SubstrateCompressionNode.uncompress(this.graph(), (ValueNode)tableRead, ReferenceAccess.singleton().getCompressEncoding());
        this.replaceAtUsages((Node)uncompress);
        graph.replaceFixed((FixedWithNextNode)this, (Node)tableRead);
    }
}

