/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.aarch64.AArch64CalleeSavedRegisters;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64BlockEndOp;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="FAR_RETURN")
public final class AArch64FarReturnOp
extends AArch64BlockEndOp {
    public static final LIRInstructionClass<AArch64FarReturnOp> TYPE = LIRInstructionClass.create(AArch64FarReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue sp;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue ip;
    private final boolean fromMethodWithCalleeSavedRegisters;

    public AArch64FarReturnOp(AllocatableValue result, AllocatableValue sp, AllocatableValue ip, boolean fromMethodWithCalleeSavedRegisters) {
        super(TYPE);
        this.result = result;
        this.sp = sp;
        this.ip = ip;
        this.fromMethodWithCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (this.sp.getPlatformKind().getSizeInBytes() == FrameAccess.wordSize() && FrameAccess.wordSize() == 8) : Assertions.errorMessage((Object[])new Object[]{this.sp.getPlatformKind().getSizeInBytes(), FrameAccess.wordSize()});
        if (!SubstrateOptions.PreserveFramePointer.getValue().booleanValue() && !this.fromMethodWithCalleeSavedRegisters) {
            masm.mov(64, AArch64.sp, ValueUtil.asRegister((Value)this.sp));
            AArch64FarReturnOp.returnTo(ValueUtil.asRegister((Value)this.ip), masm);
            return;
        }
        Label notSameFrame = new Label();
        masm.cmp(64, AArch64.sp, ValueUtil.asRegister((Value)this.sp));
        masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, notSameFrame);
        AArch64FarReturnOp.returnTo(ValueUtil.asRegister((Value)this.ip), masm);
        masm.bind(notSameFrame);
        int minCalleeFrameSize = FrameAccess.wordSize() * 2;
        try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();){
            Register ipRegister;
            Register ipScratch = scratch1.getRegister();
            if (this.fromMethodWithCalleeSavedRegisters) {
                Register arithScratch;
                int calleeFrameSize = minCalleeFrameSize + CalleeSavedRegisters.singleton().getSaveAreaSize();
                try (AArch64MacroAssembler.ScratchRegister scratch2 = masm.getScratchRegister();){
                    arithScratch = scratch2.getRegister();
                    masm.sub(64, AArch64.sp, ValueUtil.asRegister((Value)this.sp), calleeFrameSize, arithScratch);
                }
                masm.mov(64, ipScratch, ValueUtil.asRegister((Value)this.ip));
                ipRegister = ipScratch;
                AArch64CalleeSavedRegisters.singleton().emitRestore(masm, calleeFrameSize, ValueUtil.asRegister((Value)this.result));
                scratch2 = masm.getScratchRegister();
                try {
                    arithScratch = scratch2.getRegister();
                    masm.add(64, AArch64.sp, AArch64.sp, CalleeSavedRegisters.singleton().getSaveAreaSize(), arithScratch);
                }
                finally {
                    if (scratch2 != null) {
                        scratch2.close();
                    }
                }
            }
            masm.sub(64, AArch64.sp, ValueUtil.asRegister((Value)this.sp), minCalleeFrameSize);
            ipRegister = ValueUtil.asRegister((Value)this.ip);
            masm.ldr(64, SubstrateAArch64RegisterConfig.fp, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, (Register)AArch64.sp, (int)minCalleeFrameSize));
            AArch64FarReturnOp.returnTo(ipRegister, masm);
        }
    }

    private static void returnTo(Register ipRegister, AArch64MacroAssembler masm) {
        masm.mov(64, AArch64.lr, ipRegister);
        masm.ret(AArch64.lr);
    }
}

