/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.SerialGCOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class SerialGCOptions_ConcealedOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(SerialGCOptions.ConcealedOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "CompactingOldGen": {
                return OptionDescriptor.create((String)"CompactingOldGen", (OptionType)OptionType.Expert, Boolean.class, (String)"Collect old generation by compacting in-place instead of copying. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.ConcealedOptions.CompactingOldGen, (String)"CompactingOldGen", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseRememberedSet": {
                return OptionDescriptor.create((String)"UseRememberedSet", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a remembered set is used, which is necessary for collecting the young and old generation independently. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.ConcealedOptions.UseRememberedSet, (String)"UseRememberedSet", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SerialGCOptions_ConcealedOptions_OptionDescriptors.this.get("CompactingOldGen");
                    }
                    case 1: {
                        return SerialGCOptions_ConcealedOptions_OptionDescriptors.this.get("UseRememberedSet");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

