/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.word.Word;

class ChunkedImageHeapAllocator {
    private final int alignedChunkSize;
    private final int alignedChunkAlignment;
    private final int alignedChunkObjectsOffset;
    private long position;
    private final ArrayList<UnalignedChunk> unalignedChunks = new ArrayList();
    private final ArrayList<AlignedChunk> alignedChunks = new ArrayList();
    private AlignedChunk currentAlignedChunk;
    final int minimumObjectSize;

    ChunkedImageHeapAllocator(long position) {
        this.alignedChunkSize = UnsignedUtils.safeToInt(HeapParameters.getAlignedHeapChunkSize());
        this.alignedChunkAlignment = UnsignedUtils.safeToInt(HeapParameters.getAlignedHeapChunkAlignment());
        this.alignedChunkObjectsOffset = UnsignedUtils.safeToInt(AlignedHeapChunk.getObjectsStartOffset());
        this.position = position;
        this.minimumObjectSize = ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize();
    }

    public long getPosition() {
        return this.currentAlignedChunk != null ? this.currentAlignedChunk.getTop() : this.position;
    }

    public long allocateUnalignedChunkForObject(ImageHeapObject obj, boolean writable) {
        assert (this.currentAlignedChunk == null);
        long objSize = obj.getSize();
        long chunkSize = UnalignedHeapChunk.getChunkSizeForObject(Word.unsigned((long)objSize)).rawValue();
        long chunkBegin = this.allocateRaw(chunkSize);
        this.unalignedChunks.add(new UnalignedChunk(chunkBegin, chunkSize, writable, objSize));
        return chunkBegin + (long)UnsignedUtils.safeToInt(UnalignedHeapChunk.calculateObjectStartOffset(Word.unsigned((long)objSize)));
    }

    public void maybeStartAlignedChunk() {
        if (this.currentAlignedChunk == null) {
            this.startNewAlignedChunk();
        }
    }

    public void startNewAlignedChunk() {
        this.finishAlignedChunk();
        this.alignBetweenChunks(this.alignedChunkAlignment);
        long chunkBegin = this.allocateRaw(this.alignedChunkSize);
        this.currentAlignedChunk = new AlignedChunk(chunkBegin);
        this.alignedChunks.add(this.currentAlignedChunk);
    }

    private void alignBetweenChunks(int multiple) {
        assert (this.currentAlignedChunk == null);
        this.allocateRaw(ChunkedImageHeapAllocator.computePadding(this.position, multiple));
    }

    public long getRemainingBytesInAlignedChunk() {
        return this.currentAlignedChunk.getUnallocatedBytes();
    }

    public long allocateObjectInAlignedChunk(ImageHeapObject obj, boolean writable) {
        return this.currentAlignedChunk.allocate(obj, writable);
    }

    public void finishAlignedChunk() {
        this.currentAlignedChunk = null;
    }

    public List<AlignedChunk> getAlignedChunks() {
        return this.alignedChunks;
    }

    public List<UnalignedChunk> getUnalignedChunks() {
        return this.unalignedChunks;
    }

    private long allocateRaw(long size) {
        assert (this.currentAlignedChunk == null);
        long begin = this.position;
        this.position += size;
        return begin;
    }

    private static long computePadding(long offset, int alignment) {
        long remainder = offset % (long)alignment;
        return remainder == 0L ? 0L : (long)alignment - remainder;
    }

    final class AlignedChunk
    extends Chunk {
        private final List<ImageHeapObject> objects;
        private long topOffset;

        AlignedChunk(long begin) {
            super(begin, ChunkedImageHeapAllocator.this.alignedChunkSize, false);
            this.objects = new ArrayList<ImageHeapObject>();
            this.topOffset = ChunkedImageHeapAllocator.this.alignedChunkObjectsOffset;
        }

        public long allocate(ImageHeapObject obj, boolean writable) {
            long size = obj.getSize();
            if (size > this.getUnallocatedBytes()) {
                throw VMError.shouldNotReachHere("Object of size " + size + " does not fit in the chunk's remaining bytes");
            }
            long objStart = this.getTop();
            this.topOffset += size;
            this.objects.add(obj);
            if (writable) {
                this.setWritable();
            }
            return objStart;
        }

        public List<ImageHeapObject> getObjects() {
            return this.objects;
        }

        @Override
        public long getTopOffset() {
            return this.topOffset;
        }

        public long getTop() {
            return this.getBegin() + this.topOffset;
        }

        public long getUnallocatedBytes() {
            return this.getEndOffset() - this.topOffset;
        }
    }

    static final class UnalignedChunk
    extends Chunk {
        private final long objectSize;

        UnalignedChunk(long begin, long endOffset, boolean writable, long objectSize) {
            super(begin, endOffset, writable);
            this.objectSize = objectSize;
        }

        @Override
        public long getTopOffset() {
            return this.getEndOffset();
        }

        public long getObjectSize() {
            return this.objectSize;
        }
    }

    static abstract class Chunk {
        private final long begin;
        private final long endOffset;
        private boolean writable;

        Chunk(long begin, long endOffset, boolean writable) {
            this.begin = begin;
            this.endOffset = endOffset;
            this.writable = writable;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.begin + this.endOffset;
        }

        public long getEndOffset() {
            return this.endOffset;
        }

        public abstract long getTopOffset();

        public void setWritable() {
            this.writable = true;
        }

        public boolean isWritable() {
            return this.writable;
        }
    }
}

