/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.IsolateArgumentAccess;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NativeMemoryTracking;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.os.ChunkBasedCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class AddressRangeCommittedMemoryProvider
extends ChunkBasedCommittedMemoryProvider {
    private static final long MIN_RESERVED_ADDRESS_SPACE_SIZE = 0x800000000L;
    protected static final int NO_ERROR = 0;
    protected static final int OUT_OF_ADDRESS_SPACE = 1;
    protected static final int COMMIT_FAILED = 2;
    private static final OutOfMemoryError NODE_ALLOCATION_FAILED = new OutOfMemoryError("Could not allocate node for free list, OS may be out of memory.");
    private static final OutOfMemoryError ALIGNED_OUT_OF_ADDRESS_SPACE = new OutOfMemoryError("Could not allocate an aligned heap chunk because the heap address space is exhausted. Consider increasing the address space size (see option -XX:ReservedAddressSpaceSize).");
    private static final OutOfMemoryError UNALIGNED_OUT_OF_ADDRESS_SPACE = new OutOfMemoryError("Could not allocate an unaligned heap chunk because the heap address space is exhausted. Consider increasing the address space size (see option -XX:ReservedAddressSpaceSize).");
    private final VMMutex lock = new VMMutex("freeList");
    protected FreeListNode allocListHead;
    protected long allocListCount;
    protected FreeListNode unusedListHead;
    protected long unusedListCount;
    protected UnsignedWord reservedSpaceSize;
    protected Pointer collectedHeapBegin;
    protected UnsignedWord collectedHeapSize;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AddressRangeCommittedMemoryProvider() {
        assert (SubstrateOptions.SpawnIsolates.getValue().booleanValue());
    }

    @Override
    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer heapBasePointer, IsolateArguments arguments) {
        WordPointer beginOut;
        UnsignedWord alignment;
        int errorCode;
        UnsignedWord reserved = Word.unsigned((long)IsolateArgumentAccess.readLong(arguments, IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.ReservedAddressSpaceSize)));
        if (reserved.equal(0)) {
            UnsignedWord maxHeapSize = Word.unsigned((long)IsolateArgumentAccess.readLong(arguments, IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MaxHeapSize)));
            reserved = UnsignedUtils.max(maxHeapSize, Word.unsigned((long)0x800000000L));
        }
        if ((errorCode = this.reserveHeapMemory(reserved = UnsignedUtils.min(reserved, ReferenceAccess.singleton().getMaxAddressSpaceSize()), alignment = Word.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment()), arguments, beginOut = (WordPointer)StackValue.get(WordPointer.class))) != 0) {
            return errorCode;
        }
        Pointer begin = (Pointer)beginOut.read();
        WordPointer imageHeapEndOut = (WordPointer)StackValue.get(WordPointer.class);
        errorCode = ImageHeapProvider.get().initialize(begin, reserved, heapBasePointer, imageHeapEndOut);
        if (errorCode != 0) {
            this.freeOnInitializeError(begin, reserved);
            return errorCode;
        }
        CEntryPointSnippets.initBaseRegisters((PointerBase)heapBasePointer.read());
        WordPointer runtimeHeapBeginOut = (WordPointer)StackValue.get(WordPointer.class);
        errorCode = this.getCollectedHeapBegin(arguments, begin, reserved, (Pointer)imageHeapEndOut.read(), runtimeHeapBeginOut);
        if (errorCode != 0) {
            this.freeOnInitializeError(begin, reserved);
            return errorCode;
        }
        errorCode = AddressRangeCommittedMemoryProvider.initialize(begin, reserved, (Pointer)runtimeHeapBeginOut.read());
        if (errorCode != 0) {
            this.freeOnInitializeError(begin, reserved);
        }
        return errorCode;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected int getCollectedHeapBegin(IsolateArguments arguments, Pointer begin, UnsignedWord reserved, Pointer imageHeapEnd, WordPointer collectedHeapBeginOut) {
        Pointer result = PointerUtils.roundUp((PointerBase)imageHeapEnd, this.getGranularity());
        collectedHeapBeginOut.write((WordBase)result);
        return 0;
    }

    @NeverInline(value="Ensure a newly looked up value is used as 'this', now that the image heap is initialized")
    @Uninterruptible(reason="Called from uninterruptible code.")
    private static int initialize(Pointer spaceBegin, UnsignedWord spaceSize, Pointer collectedHeapBegin) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            UnsignedWord imageHeapAddressSpace = ImageHeapProvider.get().getImageHeapAddressSpaceSize();
            UnsignedWord javaHeapAddressSpace = spaceSize.subtract(imageHeapAddressSpace);
            NativeMemoryTracking.singleton().trackReserve(javaHeapAddressSpace, NmtCategory.JavaHeap);
        }
        AddressRangeCommittedMemoryProvider provider = (AddressRangeCommittedMemoryProvider)ChunkBasedCommittedMemoryProvider.get();
        return provider.initializeFields(spaceBegin, spaceSize, collectedHeapBegin);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int initializeFields(Pointer spaceBegin, UnsignedWord reservedSpaceSize, Pointer collectedHeapBegin) {
        this.reservedSpaceSize = reservedSpaceSize;
        this.collectedHeapBegin = collectedHeapBegin;
        this.collectedHeapSize = spaceBegin.add(reservedSpaceSize).subtract((UnsignedWord)collectedHeapBegin);
        FreeListNode node = this.allocNodeOrNull(collectedHeapBegin, this.collectedHeapSize);
        if (node.isNull()) {
            return 3;
        }
        this.unusedListHead = node;
        this.unusedListCount = 1L;
        this.allocListHead = node;
        this.allocListCount = 1L;
        return 0;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected int reserveHeapMemory(UnsignedWord reserved, UnsignedWord alignment, IsolateArguments arguments, WordPointer beginOut) {
        Pointer begin = this.reserveHeapMemory0(reserved, alignment, arguments);
        if (begin.isNull()) {
            return 801;
        }
        beginOut.write((WordBase)begin);
        return 0;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected Pointer reserveHeapMemory0(UnsignedWord reserved, UnsignedWord alignment, IsolateArguments arguments) {
        return VirtualMemoryProvider.get().reserve(reserved, alignment, false);
    }

    @Uninterruptible(reason="Still being initialized.")
    protected void freeOnInitializeError(Pointer begin, UnsignedWord reserved) {
        VirtualMemoryProvider.get().free((PointerBase)begin, reserved);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FreeListNode allocNode(Pointer start, UnsignedWord size) {
        FreeListNode node = this.allocNodeOrNull(start, size);
        if (node.isNull()) {
            throw NODE_ALLOCATION_FAILED;
        }
        return node;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FreeListNode allocNodeOrNull(Pointer start, UnsignedWord size) {
        FreeListNode node = (FreeListNode)NullableNativeMemory.calloc(this.sizeOfFreeListNode(), NmtCategory.GC);
        if (node.isNonNull()) {
            this.setBounds(node, start, size);
        }
        return node;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord sizeOfFreeListNode() {
        return SizeOf.unsigned(FreeListNode.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeNode(FreeListNode node) {
        NullableNativeMemory.free(node);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isAllocatable(UnsignedWord size) {
        return size.aboveOrEqual(AddressRangeCommittedMemoryProvider.minAllocationSize());
    }

    @Fold
    static UnsignedWord minAllocationSize() {
        return UnsignedUtils.min(HeapParameters.getAlignedHeapChunkSize(), HeapParameters.getMinUnalignedChunkSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setBounds(FreeListNode node, Pointer start, UnsignedWord size) {
        assert (UnsignedUtils.isAMultiple((UnsignedWord)start, this.getGranularity()));
        assert (UnsignedUtils.isAMultiple(size, this.getGranularity()));
        assert (start.aboveOrEqual((UnsignedWord)this.collectedHeapBegin));
        assert (size.belowOrEqual(this.collectedHeapSize));
        assert (start.add(size).belowOrEqual((UnsignedWord)this.collectedHeapBegin.add(this.collectedHeapSize)));
        node.setStart(start);
        node.setSize(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static Pointer getNodeEnd(FreeListNode node) {
        return node.getStart().add(node.getSize());
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        FreeListNode node = this.unusedListHead;
        while (node.isNonNull()) {
            FreeListNode next = node.getUnusedNext();
            AddressRangeCommittedMemoryProvider.freeNode(node);
            node = next;
        }
        return this.unmapAddressSpace((PointerBase)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Tear-down in progress.")
    protected int unmapAddressSpace(PointerBase heapBase) {
        if (VirtualMemoryProvider.get().free(heapBase, this.reservedSpaceSize) != 0) {
            return 19;
        }
        return 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord nbytes, UnsignedWord alignment) {
        WordPointer allocOut = UnsafeStackValue.get(WordPointer.class);
        int error = this.allocateInHeapAddressSpace(nbytes, alignment, allocOut);
        if (error == 0) {
            if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
                NativeMemoryTracking.singleton().trackCommit(nbytes, NmtCategory.JavaHeap);
            }
            return (Pointer)allocOut.read();
        }
        throw this.reportAlignedChunkAllocationFailed(error);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected OutOfMemoryError reportAlignedChunkAllocationFailed(int error) {
        if (error == 1) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(ALIGNED_OUT_OF_ADDRESS_SPACE);
        }
        if (error == 2) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(ALIGNED_CHUNK_COMMIT_FAILED);
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateUnalignedChunk(UnsignedWord nbytes) {
        WordPointer allocOut = UnsafeStackValue.get(WordPointer.class);
        int error = this.allocateInHeapAddressSpace(nbytes, AddressRangeCommittedMemoryProvider.getAlignmentForUnalignedChunks(), allocOut);
        if (error == 0) {
            if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
                NativeMemoryTracking.singleton().trackCommit(nbytes, NmtCategory.JavaHeap);
            }
            return (Pointer)allocOut.read();
        }
        throw this.reportUnalignedChunkAllocationFailed(error);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected OutOfMemoryError reportUnalignedChunkAllocationFailed(int error) {
        if (error == 1) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(UNALIGNED_OUT_OF_ADDRESS_SPACE);
        }
        if (error == 2) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(UNALIGNED_CHUNK_COMMIT_FAILED);
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    protected int allocateInHeapAddressSpace(UnsignedWord size, UnsignedWord alignment, WordPointer allocOut) {
        assert (size.aboveThan(0));
        assert (alignment.aboveThan(0));
        this.lock.lockNoTransitionUnspecifiedOwner();
        try {
            FreeListNode fit = (FreeListNode)Word.nullPointer();
            FreeListNode fitAllocPrevious = (FreeListNode)Word.nullPointer();
            UnsignedWord fitSize = UnsignedUtils.MAX_VALUE;
            FreeListNode previous2 = (FreeListNode)Word.nullPointer();
            FreeListNode node = this.allocListHead;
            while (node.isNonNull()) {
                UnsignedWord nodeSize = node.getSize();
                if (nodeSize.aboveOrEqual(size) && nodeSize.belowThan(fitSize)) {
                    Pointer offset = PointerUtils.roundUp((PointerBase)node.getStart(), alignment).subtract((UnsignedWord)node.getStart());
                    if (nodeSize.subtract(size).aboveOrEqual((UnsignedWord)offset)) {
                        fitAllocPrevious = previous2;
                        fit = node;
                        fitSize = nodeSize;
                        if (nodeSize.equal(size)) break;
                    }
                }
                previous2 = node;
                node = node.getAllocNext();
            }
            if (fit.isNull()) {
                allocOut.write((WordBase)Word.nullPointer());
                int previous2 = 1;
                return previous2;
            }
            UnsignedWord pageSize = this.getGranularity();
            Pointer fitStart = fit.getStart();
            assert (PointerUtils.isAMultiple((PointerBase)fitStart, pageSize));
            assert (UnsignedUtils.isAMultiple(fitSize, pageSize));
            Pointer allocated = PointerUtils.roundUp((PointerBase)fitStart, alignment);
            Pointer mapBegin = PointerUtils.roundDown((PointerBase)allocated, pageSize);
            Pointer mapEnd = PointerUtils.roundUp((PointerBase)allocated.add(size), pageSize);
            Pointer alignedSize = mapEnd.subtract((UnsignedWord)mapBegin);
            assert (mapBegin.aboveOrEqual((UnsignedWord)fitStart) && mapEnd.belowOrEqual((UnsignedWord)fitStart.add(fitSize)));
            int access = 3;
            Pointer actualMapBegin = VirtualMemoryProvider.get().commit((PointerBase)mapBegin, (UnsignedWord)alignedSize, 3);
            if (actualMapBegin.isNull()) {
                allocOut.write((WordBase)Word.nullPointer());
                int n = 2;
                return n;
            }
            VMError.guarantee(actualMapBegin.equal((UnsignedWord)mapBegin), "Must not be mapped anywhere else.");
            Pointer leadingSize = mapBegin.subtract((UnsignedWord)fitStart);
            Pointer trailingSize = fitStart.add(fitSize).subtract((UnsignedWord)mapEnd);
            boolean perfectFit = false;
            if (leadingSize.aboveThan(0) && trailingSize.aboveThan(0)) {
                if (AddressRangeCommittedMemoryProvider.isAllocatable((UnsignedWord)leadingSize)) {
                    this.createNodeForTrailingMemory(fit, mapEnd, (UnsignedWord)trailingSize);
                    this.trimBounds(fit, fit.getStart(), (UnsignedWord)leadingSize);
                } else {
                    this.createNodeForLeadingMemory(fit, (UnsignedWord)leadingSize);
                    this.trimBounds(fit, mapEnd, (UnsignedWord)trailingSize);
                }
            } else if (trailingSize.aboveThan(0)) {
                this.trimBounds(fit, mapEnd, (UnsignedWord)trailingSize);
            } else if (leadingSize.aboveThan(0)) {
                this.trimBounds(fit, fit.getStart(), (UnsignedWord)leadingSize);
            } else {
                perfectFit = true;
            }
            if (perfectFit || !AddressRangeCommittedMemoryProvider.isAllocatable(fit.getSize())) {
                this.removeFromAllocList(fit, fitAllocPrevious);
            }
            if (perfectFit) {
                this.removeFromUnusedList(fit);
                AddressRangeCommittedMemoryProvider.freeNode(fit);
                fit = (FreeListNode)Word.nullPointer();
            }
            allocOut.write((WordBase)allocated);
            int n = 0;
            return n;
        }
        finally {
            this.lock.unlockNoTransitionUnspecifiedOwner();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void createNodeForLeadingMemory(FreeListNode fit, UnsignedWord leadingSize) {
        FreeListNode leadingNode = this.createNodeWhenSplitting(fit, fit.getStart(), leadingSize);
        this.addToUnusedList(leadingNode, fit.getUnusedPrevious());
        assert (!AddressRangeCommittedMemoryProvider.isAllocatable(leadingSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void createNodeForTrailingMemory(FreeListNode fit, Pointer trailingStart, UnsignedWord trailingSize) {
        FreeListNode trailingNode = this.createNodeWhenSplitting(fit, trailingStart, trailingSize);
        this.addToUnusedList(trailingNode, fit);
        if (AddressRangeCommittedMemoryProvider.isAllocatable(trailingSize)) {
            this.addToAllocList(trailingNode, fit);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected FreeListNode createNodeWhenSplitting(FreeListNode fit, Pointer start, UnsignedWord size) {
        return this.allocNode(start, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void addToUnusedList(FreeListNode newNode, FreeListNode prev) {
        FreeListNode next;
        assert (newNode.isNonNull());
        assert (newNode.getUnusedNext().isNull());
        assert (newNode.getUnusedPrevious().isNull());
        if (prev.isNull()) {
            next = this.unusedListHead;
            this.unusedListHead = newNode;
        } else {
            next = prev.getUnusedNext();
            prev.setUnusedNext(newNode);
            newNode.setUnusedPrevious(prev);
        }
        if (next.isNonNull()) {
            next.setUnusedPrevious(newNode);
            newNode.setUnusedNext(next);
        }
        ++this.unusedListCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void removeFromUnusedList(FreeListNode node) {
        assert (node.isNonNull());
        FreeListNode next = node.getUnusedNext();
        FreeListNode prev = node.getUnusedPrevious();
        if (next.isNonNull()) {
            next.setUnusedPrevious(prev);
        }
        if (node == this.unusedListHead) {
            this.unusedListHead = next;
        } else {
            prev.setUnusedNext(next);
        }
        --this.unusedListCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void addToAllocList(FreeListNode newNode, FreeListNode prev) {
        assert (newNode.isNonNull());
        assert (newNode.getAllocNext().isNull());
        assert (AddressRangeCommittedMemoryProvider.isAllocatable(newNode.getSize()));
        if (prev.isNull()) {
            newNode.setAllocNext(this.allocListHead);
            this.allocListHead = newNode;
        } else {
            newNode.setAllocNext(prev.getAllocNext());
            prev.setAllocNext(newNode);
        }
        ++this.allocListCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void removeFromAllocList(FreeListNode node, FreeListNode prevNode) {
        assert (node.isNonNull());
        if (node == this.allocListHead) {
            assert (prevNode.isNull());
            this.allocListHead = node.getAllocNext();
        } else {
            prevNode.setAllocNext(node.getAllocNext());
        }
        node.setAllocNext((FreeListNode)Word.nullPointer());
        --this.allocListCount;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NativeMemoryTracking.singleton().trackUncommit(nbytes, NmtCategory.JavaHeap);
        }
        this.freeInHeapAddressSpace((Pointer)start, nbytes);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase start, UnsignedWord nbytes) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NativeMemoryTracking.singleton().trackUncommit(nbytes, NmtCategory.JavaHeap);
        }
        this.freeInHeapAddressSpace((Pointer)start, nbytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    protected void freeInHeapAddressSpace(Pointer start, UnsignedWord nbytes) {
        assert (start.isNonNull());
        assert (nbytes.aboveThan(0));
        this.lock.lockNoTransition();
        try {
            FreeListNode container;
            boolean adjacentSuccessor;
            FreeListNode unusedNext;
            UnsignedWord pageSize = this.getGranularity();
            Pointer mapBegin = PointerUtils.roundDown((PointerBase)start, pageSize);
            FreeListNode allocPrevious = (FreeListNode)Word.nullPointer();
            FreeListNode allocNext = this.allocListHead;
            while (allocNext.isNonNull() && allocNext.getStart().belowThan((UnsignedWord)mapBegin)) {
                allocPrevious = allocNext;
                allocNext = allocNext.getAllocNext();
            }
            FreeListNode unusedPrevious = allocPrevious;
            FreeListNode freeListNode = unusedNext = unusedPrevious.isNull() ? this.unusedListHead : unusedPrevious.getUnusedNext();
            while (unusedNext.isNonNull() && unusedNext.getStart().belowThan((UnsignedWord)mapBegin)) {
                unusedPrevious = unusedNext;
                unusedNext = unusedNext.getUnusedNext();
            }
            Pointer mapEnd = PointerUtils.roundUp((PointerBase)start.add(nbytes), pageSize);
            Pointer alignedSize = mapEnd.subtract((UnsignedWord)mapBegin);
            assert (alignedSize.aboveOrEqual(nbytes));
            assert (unusedPrevious.isNull() || mapBegin.aboveOrEqual((UnsignedWord)AddressRangeCommittedMemoryProvider.getNodeEnd(unusedPrevious)));
            assert (unusedNext.isNull() || mapEnd.belowOrEqual((UnsignedWord)unusedNext.getStart()));
            boolean adjacentPredecessor = unusedPrevious.isNonNull() && AddressRangeCommittedMemoryProvider.getNodeEnd(unusedPrevious).equal((UnsignedWord)mapBegin);
            boolean bl = adjacentSuccessor = unusedNext.isNonNull() && mapEnd.equal((UnsignedWord)unusedNext.getStart());
            if (adjacentPredecessor) {
                this.increaseBounds(unusedPrevious, mapBegin, (UnsignedWord)alignedSize);
                container = unusedPrevious;
                if (adjacentSuccessor) {
                    this.mergeNodes(container, unusedNext);
                    if (allocNext == unusedNext) {
                        allocNext = allocNext.getAllocNext();
                        this.removeFromAllocList(unusedNext, allocPrevious);
                    }
                    this.removeFromUnusedList(unusedNext);
                    AddressRangeCommittedMemoryProvider.freeNode(unusedNext);
                    unusedNext = (FreeListNode)Word.nullPointer();
                }
            } else if (adjacentSuccessor) {
                this.increaseBounds(unusedNext, mapBegin, (UnsignedWord)alignedSize);
                container = unusedNext;
            } else {
                FreeListNode node = this.allocNode(mapBegin, (UnsignedWord)alignedSize);
                this.addToUnusedList(node, unusedPrevious);
                container = node;
            }
            this.uncommit(container, mapBegin, (UnsignedWord)alignedSize);
            if (AddressRangeCommittedMemoryProvider.isAllocatable(container.getSize()) && container != allocPrevious && container != allocNext) {
                this.addToAllocList(container, allocPrevious);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void uncommit(FreeListNode node, Pointer mapBegin, UnsignedWord mappingSize) {
        if (VirtualMemoryProvider.get().uncommit((PointerBase)mapBegin, mappingSize) != 0) {
            throw AddressRangeCommittedMemoryProvider.reportUncommitFailed(mapBegin, mappingSize);
        }
    }

    @Uninterruptible(reason="Switch to interruptible code for error reporting.", calleeMustBe=false)
    private static RuntimeException reportUncommitFailed(Pointer mapBegin, UnsignedWord mappingSize) {
        throw AddressRangeCommittedMemoryProvider.reportUncommitFailedInterruptibly(mapBegin, mappingSize);
    }

    private static RuntimeException reportUncommitFailedInterruptibly(Pointer mapBegin, UnsignedWord mappingSize) {
        Log.log().string("Uncommitting ").unsigned((WordBase)mappingSize).string(" bytes of unused memory at ").hex((WordBase)mapBegin).string(" failed.").newline();
        throw VMError.shouldNotReachHere("Uncommitting memory failed.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void mergeNodes(FreeListNode target, FreeListNode obsolete) {
        this.increaseBounds(target, obsolete.getStart(), obsolete.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void increaseBounds(FreeListNode node, Pointer otherStart, UnsignedWord otherSize) {
        assert (AddressRangeCommittedMemoryProvider.getNodeEnd(node).equal((UnsignedWord)otherStart) || otherStart.add(otherSize).equal((UnsignedWord)node.getStart())) : "must be adjacent";
        assert (UnsignedUtils.isAMultiple(otherSize, this.getGranularity()));
        assert (otherSize.belowOrEqual(this.reservedSpaceSize));
        Pointer newStart = PointerUtils.min(node.getStart(), otherStart);
        UnsignedWord newSize = node.getSize().add(otherSize);
        this.setBounds(node, newStart, newSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void trimBounds(FreeListNode fit, Pointer newStart, UnsignedWord newSize) {
        assert (newSize.belowOrEqual(this.reservedSpaceSize));
        assert (fit.getStart().equal((UnsignedWord)newStart) && newSize.belowThan(fit.getSize()) || fit.getStart().belowThan((UnsignedWord)newStart) && AddressRangeCommittedMemoryProvider.getNodeEnd(fit).equal((UnsignedWord)newStart.add(newSize)));
        this.setBounds(fit, newStart, newSize);
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void beforeGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
        assert (!this.lock.hasOwner()) : "Must not be locked -- is mutator code holding the lock?";
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            this.verifyFreeList();
        }
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void uncommitUnusedMemory() {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
        assert (!this.lock.hasOwner()) : "Must not be locked";
        this.uncommitUnusedMemory0();
    }

    protected void uncommitUnusedMemory0() {
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            this.verifyFreeList();
        }
    }

    protected void verifyFreeList() {
        int unusedCount = 0;
        FreeListNode unusedPrevious = (FreeListNode)Word.nullPointer();
        FreeListNode unused = this.unusedListHead;
        while (unused.isNonNull()) {
            VMError.guarantee(unused.getUnusedPrevious().equal((ComparableWord)unusedPrevious), "Unused list previous-next node linkage must be consistent");
            VMError.guarantee(unusedPrevious.isNull() || unused.getStart().aboveThan((UnsignedWord)AddressRangeCommittedMemoryProvider.getNodeEnd(unusedPrevious)), "Unused blocks must not be adjacent or overlapping");
            VMError.guarantee(this.isInAllocList(unused) == AddressRangeCommittedMemoryProvider.isAllocatable(unused.getSize()), "Allocatable blocks must be in the alloc list");
            ++unusedCount;
            unusedPrevious = unused;
            unused = unused.getUnusedNext();
        }
        VMError.guarantee((long)unusedCount == this.unusedListCount, "Number of unused list nodes must match recorded count");
        int unusedReverseCounted = 0;
        if (unusedPrevious.isNonNull()) {
            FreeListNode unusedNext = unusedPrevious;
            ++unusedReverseCounted;
            FreeListNode unused2 = unusedNext.getUnusedPrevious();
            while (unused2.isNonNull()) {
                VMError.guarantee(unused2.getUnusedNext().equal((ComparableWord)unusedNext), "Unused list previous-next node linkage must be consistent");
                VMError.guarantee(unusedNext.getStart().aboveThan((UnsignedWord)AddressRangeCommittedMemoryProvider.getNodeEnd(unused2)), "Unused blocks must not be adjacent or overlapping");
                ++unusedReverseCounted;
                unusedNext = unused2;
                unused2 = unused2.getUnusedPrevious();
            }
            VMError.guarantee(unusedNext == this.unusedListHead, "Unused list reverse iteration must terminate at list head");
        }
        VMError.guarantee(unusedCount == unusedReverseCounted, "Number of unused list nodes must be the same for forward and reverse iteration");
        int allocCount = 0;
        FreeListNode previous = (FreeListNode)Word.nullPointer();
        FreeListNode alloc = this.allocListHead;
        while (alloc.isNonNull()) {
            VMError.guarantee(previous.isNull() || alloc.getStart().aboveThan((UnsignedWord)AddressRangeCommittedMemoryProvider.getNodeEnd(previous)), "Allocatable blocks must not be adjacent or overlapping");
            VMError.guarantee(AddressRangeCommittedMemoryProvider.isAllocatable(alloc.getSize()), "Allocatable blocks must satisfy minimum allocatable size");
            ++allocCount;
            previous = alloc;
            alloc = alloc.getAllocNext();
        }
        VMError.guarantee(this.allocListHead.isNull() || this.unusedListHead.equal((ComparableWord)this.allocListHead) || AddressRangeCommittedMemoryProvider.getNodeEnd(this.unusedListHead).belowOrEqual((UnsignedWord)this.allocListHead.getStart()), "First unused block must start before first allocatable block, or be allocatable itself");
        VMError.guarantee(allocCount <= unusedCount, "Allocation list must not be longer than unused list");
        VMError.guarantee((long)allocCount == this.allocListCount, "Number of allocation list nodes must match recorded count");
    }

    private boolean isInAllocList(FreeListNode node) {
        FreeListNode alloc = this.allocListHead;
        while (alloc.isNonNull() && alloc.getStart().belowOrEqual((UnsignedWord)node.getStart())) {
            if (alloc.equal((ComparableWord)node)) {
                return true;
            }
            alloc = alloc.getAllocNext();
        }
        return false;
    }

    @Override
    public UnsignedWord getReservedAddressSpaceSize() {
        return this.reservedSpaceSize;
    }

    @RawStructure
    protected static interface FreeListNode
    extends PointerBase {
        @RawField
        public Pointer getStart();

        @RawField
        public void setStart(Pointer var1);

        @RawField
        public UnsignedWord getSize();

        @RawField
        public void setSize(UnsignedWord var1);

        @RawField
        public FreeListNode getAllocNext();

        @RawField
        public void setAllocNext(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedPrevious();

        @RawField
        public void setUnusedPrevious(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedNext();

        @RawField
        public void setUnusedNext(FreeListNode var1);
    }
}

