/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.jdwp.bridge.DebugOptions;
import com.oracle.svm.jdwp.resident.DebuggingOnDemandHandler;
import com.oracle.svm.jdwp.resident.JDWPOptions;

public class DebuggingOnDemandHook
implements RuntimeSupport.Hook {
    static final String ADDITIONAL_JDWP_OPTIONS_ENV_VARIABLE = "_NATIVE_JDWP_OPTIONS";

    @Override
    public void execute(boolean isFirstIsolate) {
        if (isFirstIsolate) {
            String jdwpOptions = JDWPOptions.JDWPOptions.getValue();
            if (jdwpOptions == null) {
                return;
            }
            String nativeJDWPOptions = System.getenv(ADDITIONAL_JDWP_OPTIONS_ENV_VARIABLE);
            DebugOptions.Options options = null;
            try {
                options = DebugOptions.parse(jdwpOptions, nativeJDWPOptions, true, JDWPOptions.JDWPTrace.getValue());
            }
            catch (IllegalArgumentException e) {
                String errorMessage = MetadataUtil.fmt("ERROR: JDWP option syntax error: %s %s=%s", jdwpOptions, ADDITIONAL_JDWP_OPTIONS_ENV_VARIABLE, nativeJDWPOptions);
                System.err.println(errorMessage);
                System.exit(1);
            }
            new DebuggingOnDemandHandler(options).spawnJDWPThread();
        } else {
            VMError.shouldNotReachHere("debugging only works in main isolate, for now");
        }
    }
}

