/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.nativebridge;

import com.oracle.svm.jdwp.bridge.nativebridge.BinaryMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.DefaultStackTraceMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.DefaultThrowableMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.MarshallerAnnotation;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolateThread;
import com.oracle.svm.jdwp.bridge.nativebridge.StackTraceElementMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.StringMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.graalvm.collections.Pair;

public final class JNIConfig {
    private final Map<Type, BinaryMarshaller<?>> binaryMarshallers;
    private final Map<Class<? extends Annotation>, List<Pair<Class<?>, BinaryMarshaller<?>>>> annotationBinaryMarshallers;
    private final LongUnaryOperator attachThreadAction;
    private final LongUnaryOperator detachThreadAction;
    private final LongBinaryOperator shutDownIsolateAction;
    private final LongBinaryOperator releaseNativeObjectAction;
    private final Function<Supplier<NativeIsolateThread>, ThreadLocal<NativeIsolateThread>> threadLocalFactory;

    JNIConfig(Map<Type, BinaryMarshaller<?>> binaryMarshallers, Map<Class<? extends Annotation>, List<Pair<Class<?>, BinaryMarshaller<?>>>> annotationBinaryMarshallers, LongUnaryOperator attachThreadAction, LongUnaryOperator detachThreadAction, LongBinaryOperator shutDownIsolateAction, LongBinaryOperator releaseNativeObjectAction, Function<Supplier<NativeIsolateThread>, ThreadLocal<NativeIsolateThread>> threadLocalFactory) {
        this.binaryMarshallers = binaryMarshallers;
        this.annotationBinaryMarshallers = annotationBinaryMarshallers;
        this.attachThreadAction = attachThreadAction;
        this.detachThreadAction = detachThreadAction;
        this.shutDownIsolateAction = shutDownIsolateAction;
        this.releaseNativeObjectAction = releaseNativeObjectAction;
        this.threadLocalFactory = threadLocalFactory;
    }

    @SafeVarargs
    public final <T> BinaryMarshaller<T> lookupMarshaller(Class<T> type, Class<? extends Annotation> ... annotationTypes) {
        BinaryMarshaller<?> res = this.lookupBinaryMarshallerImpl(type, annotationTypes);
        if (res != null) {
            return res;
        }
        throw JNIConfig.unsupported(type);
    }

    @SafeVarargs
    public final <T> BinaryMarshaller<T> lookupMarshaller(TypeLiteral<T> parameterizedType, Class<? extends Annotation> ... annotationTypes) {
        BinaryMarshaller<?> res = this.lookupBinaryMarshallerImpl(parameterizedType.getType(), annotationTypes);
        if (res != null) {
            return res;
        }
        throw JNIConfig.unsupported(parameterizedType.getType());
    }

    Function<Supplier<NativeIsolateThread>, ThreadLocal<NativeIsolateThread>> getThreadLocalFactory() {
        return this.threadLocalFactory;
    }

    long attachThread(long isolate) {
        return this.attachThreadAction.applyAsLong(isolate);
    }

    boolean detachThread(long isolateThread) {
        return this.detachThreadAction.applyAsLong(isolateThread) == 0L;
    }

    boolean releaseNativeObject(long isolateThread, long handle) {
        return this.releaseNativeObjectAction.applyAsLong(isolateThread, handle) == 0L;
    }

    boolean shutDownIsolate(long isolate, long isolateThread) {
        return this.shutDownIsolateAction.applyAsLong(isolate, isolateThread) == 0L;
    }

    private static RuntimeException unsupported(Type type) {
        throw new UnsupportedOperationException(String.format("Marshalling of %s is not supported", type));
    }

    @SafeVarargs
    private final BinaryMarshaller<?> lookupBinaryMarshallerImpl(Type type, Class<? extends Annotation> ... annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            JNIConfig.verifyAnnotation(annotationType);
            BinaryMarshaller res = (BinaryMarshaller)JNIConfig.lookup(this.annotationBinaryMarshallers, type, annotationType);
            if (res == null) continue;
            return res;
        }
        return this.binaryMarshallers.get(type);
    }

    private static <T> T lookup(Map<Class<? extends Annotation>, List<Pair<Class<?>, T>>> marshallers, Type type, Class<? extends Annotation> annotationType) {
        List<Pair<Class<?>, T>> marshallersForAnnotation = marshallers.get(annotationType);
        if (marshallersForAnnotation != null) {
            Class<?> rawType = JNIConfig.erasure(type);
            for (Pair<Class<?>, T> marshaller : marshallersForAnnotation) {
                if (!((Class)marshaller.getLeft()).isAssignableFrom(rawType)) continue;
                return (T)marshaller.getRight();
            }
        }
        return null;
    }

    private static Class<?> erasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return JNIConfig.arrayTypeFromComponentType(JNIConfig.erasure(genericArrayType.getGenericComponentType()));
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    private static Class<?> arrayTypeFromComponentType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    private static void verifyAnnotation(Class<? extends Annotation> annotationType) {
        if (annotationType.getAnnotation(MarshallerAnnotation.class) == null) {
            throw new IllegalArgumentException(String.format("The %s in not a valid marshaller annotation. The marshaller annotation must be annotated by the %s meta-annotation.", annotationType.getSimpleName(), MarshallerAnnotation.class.getSimpleName()));
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final LongUnaryOperator ATTACH_UNSUPPORTED = isolate -> {
            throw new UnsupportedOperationException("Attach is not supported.");
        };
        private static final LongUnaryOperator DETACH_UNSUPPORTED = isolateThread -> {
            throw new UnsupportedOperationException("Detach is not supported.");
        };
        private static final LongBinaryOperator SHUTDOWN_UNSUPPORTED = (isolate, isolateThread) -> {
            throw new UnsupportedOperationException("Isolate shutdown is not supported.");
        };
        private static final LongBinaryOperator RELEASE_UNSUPPORTED = (isolateThread, handle) -> {
            throw new UnsupportedOperationException("Native object clean up is not supported.");
        };
        private final Map<Type, BinaryMarshaller<?>> binaryMarshallers;
        private final Map<Class<? extends Annotation>, List<Pair<Class<?>, BinaryMarshaller<?>>>> annotationBinaryMarshallers;
        private LongUnaryOperator attachThreadAction = ATTACH_UNSUPPORTED;
        private LongUnaryOperator detachThreadAction = DETACH_UNSUPPORTED;
        private LongBinaryOperator shutDownIsolateAction = SHUTDOWN_UNSUPPORTED;
        private LongBinaryOperator releaseNativeObjectAction = RELEASE_UNSUPPORTED;
        private Function<Supplier<NativeIsolateThread>, ThreadLocal<NativeIsolateThread>> threadLocalFactory = ThreadLocal::withInitial;

        Builder() {
            this.binaryMarshallers = new HashMap();
            this.annotationBinaryMarshallers = new HashMap();
            this.binaryMarshallers.put((Type)((Object)String.class), BinaryMarshaller.nullable(new StringMarshaller()));
            this.binaryMarshallers.put((Type)((Object)Throwable.class), new DefaultThrowableMarshaller());
            this.binaryMarshallers.put((Type)((Object)StackTraceElement.class), StackTraceElementMarshaller.INSTANCE);
        }

        public <T> Builder registerMarshaller(Class<T> type, BinaryMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            this.binaryMarshallers.put(type, marshaller);
            return this;
        }

        public <T> Builder registerMarshaller(TypeLiteral<T> parameterizedType, BinaryMarshaller<T> marshaller) {
            Objects.requireNonNull(parameterizedType, "ParameterizedType must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            this.binaryMarshallers.put(parameterizedType.getType(), marshaller);
            return this;
        }

        public <T> Builder registerMarshaller(Class<T> type, Class<? extends Annotation> annotationType, BinaryMarshaller<T> marshaller) {
            Objects.requireNonNull(type, "Type must be non null.");
            Objects.requireNonNull(annotationType, "AnnotationType must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            Builder.insert(this.annotationBinaryMarshallers, type, annotationType, marshaller);
            return this;
        }

        public <T> Builder registerMarshaller(TypeLiteral<T> parameterizedType, Class<? extends Annotation> annotationType, BinaryMarshaller<T> marshaller) {
            Objects.requireNonNull(parameterizedType, "ParameterizedType must be non null.");
            Objects.requireNonNull(annotationType, "AnnotationType must be non null.");
            Objects.requireNonNull(marshaller, "Marshaller must be non null.");
            Builder.insert(this.annotationBinaryMarshallers, parameterizedType.getRawType(), annotationType, marshaller);
            return this;
        }

        private static <T> void insert(Map<Class<? extends Annotation>, List<Pair<Class<?>, T>>> into, Class<?> type, Class<? extends Annotation> annotationType, T marshaller) {
            JNIConfig.verifyAnnotation(annotationType);
            List types = into.computeIfAbsent(annotationType, k -> new LinkedList());
            Pair toInsert = Pair.create(type, marshaller);
            boolean inserted = false;
            ListIterator<Pair> it = types.listIterator();
            while (it.hasNext()) {
                Pair current = (Pair)it.next();
                if (!((Class)current.getLeft()).isAssignableFrom(type)) continue;
                it.set(toInsert);
                it.add(current);
                inserted = true;
                break;
            }
            if (!inserted) {
                types.add(toInsert);
            }
        }

        public Builder setAttachThreadAction(LongUnaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            this.attachThreadAction = action;
            return this;
        }

        public Builder setDetachThreadAction(LongUnaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            this.detachThreadAction = action;
            return this;
        }

        public Builder setShutDownIsolateAction(LongBinaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            this.shutDownIsolateAction = action;
            return this;
        }

        public Builder setReleaseNativeObjectAction(LongBinaryOperator action) {
            Objects.requireNonNull(action, "Action must be non null.");
            this.releaseNativeObjectAction = action;
            return this;
        }

        public Builder setNativeThreadLocalFactory(Function<Supplier<NativeIsolateThread>, ThreadLocal<NativeIsolateThread>> factory) {
            Objects.requireNonNull(factory, "Action must be non null.");
            this.threadLocalFactory = factory;
            return this;
        }

        public JNIConfig build() {
            return new JNIConfig(this.binaryMarshallers, this.annotationBinaryMarshallers, this.attachThreadAction, this.detachThreadAction, this.shutDownIsolateAction, this.releaseNativeObjectAction, this.threadLocalFactory);
        }

        public static BinaryMarshaller<StackTraceElement[]> defaultStackTraceMarshaller() {
            return DefaultStackTraceMarshaller.INSTANCE;
        }
    }
}

