/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.jniutils;

import com.oracle.svm.jdwp.bridge.jniutils.JNIEntryPoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class JNIExceptionWrapperEntryPoints {
    JNIExceptionWrapperEntryPoints() {
    }

    @JNIEntryPoint
    static Throwable updateStackTrace(Throwable target, byte[] serializedStackTrace) {
        Throwable throwable;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(serializedStackTrace));
        try {
            int len = in.readInt();
            StackTraceElement[] elements = new StackTraceElement[len];
            for (int i = 0; i < len; ++i) {
                String className = in.readUTF();
                String methodName = in.readUTF();
                String fileName = in.readUTF();
                int lineNumber = in.readInt();
                elements[i] = new StackTraceElement(className, methodName, fileName.isEmpty() ? null : fileName, lineNumber);
            }
            target.setStackTrace(elements);
            throwable = target;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        in.close();
        return throwable;
    }

    @JNIEntryPoint
    static Throwable createException(String message) {
        return new RuntimeException(message);
    }

    @JNIEntryPoint
    static byte[] getStackTrace(Throwable throwable) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bout);){
            StackTraceElement[] stackTraceElements = throwable.getStackTrace();
            out.writeInt(stackTraceElements.length);
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                out.writeUTF(stackTraceElement.getClassName());
                out.writeUTF(stackTraceElement.getMethodName());
                String fileName = stackTraceElement.getFileName();
                out.writeUTF(fileName == null ? "" : fileName);
                out.writeInt(stackTraceElement.getLineNumber());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bout.toByteArray();
    }

    @JNIEntryPoint
    static String getThrowableMessage(Throwable t) {
        return t.getMessage();
    }

    @JNIEntryPoint
    static String getClassName(Class<?> clz) {
        return clz.getName();
    }
}

