/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.PacketWriterBufferImpl;
import java.nio.charset.StandardCharsets;

public interface Packet {
    public static final int NO_FLAGS = 0;
    public static final int REPLY = 128;
    public static final int REPLY_NO_ERROR = 0;
    public static final int HEADER_SIZE = 11;

    default public int length(boolean includeHeader) {
        int packetLength = this.dataSize();
        if (includeHeader) {
            packetLength += 11;
        }
        return packetLength;
    }

    public int id();

    public byte flags();

    default public boolean isReply() {
        return (this.flags() & 0x80) != 0;
    }

    public short errorCode();

    public byte commandSet();

    public byte command();

    public int dataSize();

    public byte data(int var1);

    default public byte[] toByteArray() {
        int length = this.length(true);
        PacketWriterBufferImpl writer = new PacketWriterBufferImpl(length);
        writer.writeInt(length);
        writer.writeInt(this.id());
        writer.writeByte(this.flags());
        if (this.isReply()) {
            writer.writeShort(this.errorCode());
        } else {
            writer.writeByte(this.commandSet());
            writer.writeByte(this.command());
        }
        int dataSize = this.dataSize();
        for (int i = 0; i < dataSize; ++i) {
            writer.writeByte(this.data(i));
        }
        return writer.toByteArray();
    }

    default public Reader newDataReader() {
        return new Reader(){
            private int position;

            @Override
            public int readByte() {
                return Byte.toUnsignedInt(Packet.this.data(this.position++));
            }

            @Override
            public boolean isEndOfInput() {
                return this.position >= Packet.this.dataSize();
            }
        };
    }

    public static interface Writer {
        public void writeByte(int var1);

        default public void writeBoolean(boolean value) {
            this.writeByte(value ? 1 : 0);
        }

        default public void writeChar(char value) {
            this.writeShort((short)value);
        }

        default public void writeShort(short value) {
            this.writeByte(value >> 8);
            this.writeByte(value);
        }

        default public void writeInt(int value) {
            this.writeByte(value >> 24);
            this.writeByte(value >> 16);
            this.writeByte(value >> 8);
            this.writeByte(value);
        }

        default public void writeLong(long value) {
            this.writeByte((int)(value >> 56));
            this.writeByte((int)(value >> 48));
            this.writeByte((int)(value >> 40));
            this.writeByte((int)(value >> 32));
            this.writeByte((int)(value >> 24));
            this.writeByte((int)(value >> 16));
            this.writeByte((int)(value >> 8));
            this.writeByte((int)value);
        }

        default public void writeFloat(float value) {
            this.writeInt(Float.floatToRawIntBits(value));
        }

        default public void writeDouble(double value) {
            this.writeLong(Double.doubleToRawLongBits(value));
        }

        default public void writeBytes(byte[] bytes) {
            this.writeBytes(bytes, 0, bytes.length);
        }

        default public void writeBytes(byte[] bytes, int offset, int length) {
            if (offset < 0 || length < 0 || offset > bytes.length - length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < length; ++i) {
                this.writeByte(bytes[offset + i]);
            }
        }

        default public void writeString(String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            this.writeInt(bytes.length);
            this.writeBytes(bytes);
        }
    }

    public static interface Reader {
        public int readByte();

        default public boolean readBoolean() {
            return this.readByte() != 0;
        }

        default public char readChar() {
            return (char)this.readShort();
        }

        default public short readShort() {
            int b0 = this.readByte() & 0xFF;
            int b1 = this.readByte() & 0xFF;
            return (short)(b0 << 8 | b1);
        }

        default public int readInt() {
            int b0 = this.readByte() & 0xFF;
            int b1 = this.readByte() & 0xFF;
            int b2 = this.readByte() & 0xFF;
            int b3 = this.readByte() & 0xFF;
            return b0 << 24 | b1 << 16 | b2 << 8 | b3;
        }

        default public long readLong() {
            long b0 = this.readByte() & 0xFF;
            long b1 = this.readByte() & 0xFF;
            long b2 = this.readByte() & 0xFF;
            long b3 = this.readByte() & 0xFF;
            long b4 = this.readByte() & 0xFF;
            long b5 = this.readByte() & 0xFF;
            long b6 = this.readByte() & 0xFF;
            long b7 = this.readByte() & 0xFF;
            return b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
        }

        default public float readFloat() {
            return Float.intBitsToFloat(this.readInt());
        }

        default public double readDouble() {
            return Double.longBitsToDouble(this.readLong());
        }

        default public void readBytes(byte[] bytes) {
            this.readBytes(bytes, 0, bytes.length);
        }

        default public void readBytes(byte[] bytes, int offset, int length) {
            if (offset < 0 || length < 0 || offset > bytes.length - length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < length; ++i) {
                bytes[offset + i] = (byte)(this.readByte() & 0xFF);
            }
        }

        default public String readString() {
            int length = this.readInt();
            byte[] bytes = new byte[length];
            this.readBytes(bytes, 0, length);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        default public boolean isEndOfInput() {
            return false;
        }
    }
}

