/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.JDWPEventHandlerBridge;
import com.oracle.svm.jdwp.bridge.JDWPJNIConfig;
import com.oracle.svm.jdwp.bridge.NativeToHSJDWPEventHandlerBridge;
import com.oracle.svm.jdwp.bridge.jniutils.JNI;
import com.oracle.svm.jdwp.bridge.jniutils.JNICalls;
import com.oracle.svm.jdwp.bridge.jniutils.JNIEntryPoint;
import com.oracle.svm.jdwp.bridge.jniutils.JNIMethodScope;
import com.oracle.svm.jdwp.bridge.jniutils.JNIUtil;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.ForeignException;
import com.oracle.svm.jdwp.bridge.nativebridge.JNIClassCache;
import com.oracle.svm.jdwp.bridge.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;

final class NativeToHSJDWPEventHandlerBridgeGen {
    NativeToHSJDWPEventHandlerBridgeGen() {
    }

    static NativeToHSJDWPEventHandlerBridge createNativeToHS(JNI.JNIEnv env, JNI.JObject handle) {
        return new StartPoint(env, handle);
    }

    private static final class StartPoint
    extends NativeToHSJDWPEventHandlerBridge {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv env, JNI.JObject handle) {
            super(env, handle);
            JNIData localJNI = JNIData.cache_;
            if (localJNI == null) {
                localJNI = JNIData.cache_ = new JNIData(env);
            }
            this.jniMethods_ = localJNI;
        }

        @Override
        public void onEventAt(long threadId, long classId, byte typeTag, long methodId, int bci, byte resultTag, long resultPrimitiveOrId, int eventKindFlags) {
            try {
                JNI.JNIEnv jniEnv = JNIMethodScope.env();
                JNI.JValue jniArgs = (JNI.JValue)StackValue.get((int)9, JNI.JValue.class);
                jniArgs.addressOf(0).setJObject(this.getHandle());
                jniArgs.addressOf(1).setLong(threadId);
                jniArgs.addressOf(2).setLong(classId);
                jniArgs.addressOf(3).setByte(typeTag);
                jniArgs.addressOf(4).setLong(methodId);
                jniArgs.addressOf(5).setInt(bci);
                jniArgs.addressOf(6).setByte(resultTag);
                jniArgs.addressOf(7).setLong(resultPrimitiveOrId);
                jniArgs.addressOf(8).setInt(eventKindFlags);
                ForeignException.getJNICalls().callStaticVoid(jniEnv, this.jniMethods_.endPointClass, this.jniMethods_.onEventAtMethod, jniArgs);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void onThreadDeath(long threadId) {
            try {
                JNI.JNIEnv jniEnv = JNIMethodScope.env();
                JNI.JValue jniArgs = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jniArgs.addressOf(0).setJObject(this.getHandle());
                jniArgs.addressOf(1).setLong(threadId);
                ForeignException.getJNICalls().callStaticVoid(jniEnv, this.jniMethods_.endPointClass, this.jniMethods_.onThreadDeathMethod, jniArgs);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void onThreadStart(long threadId) {
            try {
                JNI.JNIEnv jniEnv = JNIMethodScope.env();
                JNI.JValue jniArgs = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jniArgs.addressOf(0).setJObject(this.getHandle());
                jniArgs.addressOf(1).setLong(threadId);
                ForeignException.getJNICalls().callStaticVoid(jniEnv, this.jniMethods_.endPointClass, this.jniMethods_.onThreadStartMethod, jniArgs);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void onVMDeath() {
            try {
                JNI.JNIEnv jniEnv = JNIMethodScope.env();
                JNI.JValue jniArgs = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jniArgs.addressOf(0).setJObject(this.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jniEnv, this.jniMethods_.endPointClass, this.jniMethods_.onVMDeathMethod, jniArgs);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void spawnServer(String jdwpOptions, String additionalOptions, long isolate, long initialThreadId, long jdwpBridgeHandle, String metadataHashString, String metadataPath, boolean tracing) {
            try {
                JNI.JNIEnv jniEnv = JNIMethodScope.env();
                JNI.JValue jniArgs = (JNI.JValue)StackValue.get((int)9, JNI.JValue.class);
                jniArgs.addressOf(0).setJObject(this.getHandle());
                jniArgs.addressOf(1).setJObject(JNIUtil.createHSString(jniEnv, jdwpOptions));
                jniArgs.addressOf(2).setJObject(JNIUtil.createHSString(jniEnv, additionalOptions));
                jniArgs.addressOf(3).setLong(isolate);
                jniArgs.addressOf(4).setLong(initialThreadId);
                jniArgs.addressOf(5).setLong(jdwpBridgeHandle);
                jniArgs.addressOf(6).setJObject(JNIUtil.createHSString(jniEnv, metadataHashString));
                jniArgs.addressOf(7).setJObject(JNIUtil.createHSString(jniEnv, metadataPath));
                jniArgs.addressOf(8).setBoolean(tracing);
                ForeignException.getJNICalls().callStaticVoid(jniEnv, this.jniMethods_.endPointClass, this.jniMethods_.spawnServerMethod, jniArgs);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig config = JDWPJNIConfig.getInstance();
            throwableMarshaller = config.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod onEventAtMethod;
            final JNICalls.JNIMethod onThreadDeathMethod;
            final JNICalls.JNIMethod onThreadStartMethod;
            final JNICalls.JNIMethod onVMDeathMethod;
            final JNICalls.JNIMethod spawnServerMethod;

            JNIData(JNI.JNIEnv jniEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jniEnv, EndPoint.class);
                this.onEventAtMethod = JNICalls.JNIMethod.findMethod(jniEnv, this.endPointClass, true, "onEventAt", "(Lcom/oracle/svm/jdwp/bridge/JDWPEventHandlerBridge;JJBJIBJI)V");
                this.onThreadDeathMethod = JNICalls.JNIMethod.findMethod(jniEnv, this.endPointClass, true, "onThreadDeath", "(Lcom/oracle/svm/jdwp/bridge/JDWPEventHandlerBridge;J)V");
                this.onThreadStartMethod = JNICalls.JNIMethod.findMethod(jniEnv, this.endPointClass, true, "onThreadStart", "(Lcom/oracle/svm/jdwp/bridge/JDWPEventHandlerBridge;J)V");
                this.onVMDeathMethod = JNICalls.JNIMethod.findMethod(jniEnv, this.endPointClass, true, "onVMDeath", "(Lcom/oracle/svm/jdwp/bridge/JDWPEventHandlerBridge;)V");
                this.spawnServerMethod = JNICalls.JNIMethod.findMethod(jniEnv, this.endPointClass, true, "spawnServer", "(Lcom/oracle/svm/jdwp/bridge/JDWPEventHandlerBridge;Ljava/lang/String;Ljava/lang/String;JJJLjava/lang/String;Ljava/lang/String;Z)V");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void onEventAt(JDWPEventHandlerBridge receiverObject, long threadId, long classId, byte typeTag, long methodId, int bci, byte resultTag, long resultPrimitiveOrId, int eventKindFlags) {
            try {
                receiverObject.onEventAt(threadId, classId, typeTag, methodId, bci, resultTag, resultPrimitiveOrId, eventKindFlags);
            }
            catch (Throwable e) {
                throw ForeignException.forThrowable(e, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void onThreadDeath(JDWPEventHandlerBridge receiverObject, long threadId) {
            try {
                receiverObject.onThreadDeath(threadId);
            }
            catch (Throwable e) {
                throw ForeignException.forThrowable(e, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void onThreadStart(JDWPEventHandlerBridge receiverObject, long threadId) {
            try {
                receiverObject.onThreadStart(threadId);
            }
            catch (Throwable e) {
                throw ForeignException.forThrowable(e, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void onVMDeath(JDWPEventHandlerBridge receiverObject) {
            try {
                receiverObject.onVMDeath();
            }
            catch (Throwable e) {
                throw ForeignException.forThrowable(e, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void spawnServer(JDWPEventHandlerBridge receiverObject, String jdwpOptions, String additionalOptions, long isolate, long initialThreadId, long jdwpBridgeHandle, String metadataHashString, String metadataPath, boolean tracing) {
            try {
                receiverObject.spawnServer(jdwpOptions, additionalOptions, isolate, initialThreadId, jdwpBridgeHandle, metadataHashString, metadataPath, tracing);
            }
            catch (Throwable e) {
                throw ForeignException.forThrowable(e, throwableMarshaller);
            }
        }

        static {
            JNIConfig config = JDWPJNIConfig.getInstance();
            throwableMarshaller = config.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

