/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.TagConstants;

public interface JDWP {
    public static final int VirtualMachine = 1;
    public static final int VirtualMachine_Version = 1;
    public static final int VirtualMachine_ClassesBySignature = 2;
    public static final int VirtualMachine_AllClasses = 3;
    public static final int VirtualMachine_AllThreads = 4;
    public static final int VirtualMachine_TopLevelThreadGroups = 5;
    public static final int VirtualMachine_Dispose = 6;
    public static final int VirtualMachine_IDSizes = 7;
    public static final int VirtualMachine_Suspend = 8;
    public static final int VirtualMachine_Resume = 9;
    public static final int VirtualMachine_Exit = 10;
    public static final int VirtualMachine_CreateString = 11;
    public static final int VirtualMachine_Capabilities = 12;
    public static final int VirtualMachine_ClassPaths = 13;
    public static final int VirtualMachine_DisposeObjects = 14;
    public static final int VirtualMachine_HoldEvents = 15;
    public static final int VirtualMachine_ReleaseEvents = 16;
    public static final int VirtualMachine_CapabilitiesNew = 17;
    public static final int VirtualMachine_RedefineClasses = 18;
    public static final int VirtualMachine_SetDefaultStratum = 19;
    public static final int VirtualMachine_AllClassesWithGeneric = 20;
    public static final int VirtualMachine_InstanceCounts = 21;
    public static final int VirtualMachine_AllModules = 22;
    public static final int ReferenceType = 2;
    public static final int ReferenceType_Signature = 1;
    public static final int ReferenceType_ClassLoader = 2;
    public static final int ReferenceType_Modifiers = 3;
    public static final int ReferenceType_Fields = 4;
    public static final int ReferenceType_Methods = 5;
    public static final int ReferenceType_GetValues = 6;
    public static final int ReferenceType_SourceFile = 7;
    public static final int ReferenceType_NestedTypes = 8;
    public static final int ReferenceType_Status = 9;
    public static final int ReferenceType_Interfaces = 10;
    public static final int ReferenceType_ClassObject = 11;
    public static final int ReferenceType_SourceDebugExtension = 12;
    public static final int ReferenceType_SignatureWithGeneric = 13;
    public static final int ReferenceType_FieldsWithGeneric = 14;
    public static final int ReferenceType_MethodsWithGeneric = 15;
    public static final int ReferenceType_Instances = 16;
    public static final int ReferenceType_ClassFileVersion = 17;
    public static final int ReferenceType_ConstantPool = 18;
    public static final int ReferenceType_Module = 19;
    public static final int ClassType = 3;
    public static final int ClassType_Superclass = 1;
    public static final int ClassType_SetValues = 2;
    public static final int ClassType_InvokeMethod = 3;
    public static final int ClassType_NewInstance = 4;
    public static final int ArrayType = 4;
    public static final int ArrayType_NewInstance = 1;
    public static final int InterfaceType = 5;
    public static final int InterfaceType_InvokeMethod = 1;
    public static final int Method = 6;
    public static final int Method_LineTable = 1;
    public static final int Method_VariableTable = 2;
    public static final int Method_Bytecodes = 3;
    public static final int Method_IsObsolete = 4;
    public static final int Method_VariableTableWithGeneric = 5;
    public static final int Field = 8;
    public static final int ObjectReference = 9;
    public static final int ObjectReference_ReferenceType = 1;
    public static final int ObjectReference_GetValues = 2;
    public static final int ObjectReference_SetValues = 3;
    public static final int ObjectReference_MonitorInfo = 5;
    public static final int ObjectReference_InvokeMethod = 6;
    public static final int ObjectReference_DisableCollection = 7;
    public static final int ObjectReference_EnableCollection = 8;
    public static final int ObjectReference_IsCollected = 9;
    public static final int ObjectReference_ReferringObjects = 10;
    public static final int StringReference = 10;
    public static final int StringReference_Value = 1;
    public static final int ThreadReference = 11;
    public static final int ThreadReference_Name = 1;
    public static final int ThreadReference_Suspend = 2;
    public static final int ThreadReference_Resume = 3;
    public static final int ThreadReference_Status = 4;
    public static final int ThreadReference_ThreadGroup = 5;
    public static final int ThreadReference_Frames = 6;
    public static final int ThreadReference_FrameCount = 7;
    public static final int ThreadReference_OwnedMonitors = 8;
    public static final int ThreadReference_CurrentContendedMonitor = 9;
    public static final int ThreadReference_Stop = 10;
    public static final int ThreadReference_Interrupt = 11;
    public static final int ThreadReference_SuspendCount = 12;
    public static final int ThreadReference_OwnedMonitorsStackDepthInfo = 13;
    public static final int ThreadReference_ForceEarlyReturn = 14;
    public static final int ThreadReference_IsVirtual = 15;
    public static final int ThreadGroupReference = 12;
    public static final int ThreadGroupReference_Name = 1;
    public static final int ThreadGroupReference_Parent = 2;
    public static final int ThreadGroupReference_Children = 3;
    public static final int ArrayReference = 13;
    public static final int ArrayReference_Length = 1;
    public static final int ArrayReference_GetValues = 2;
    public static final int ArrayReference_SetValues = 3;
    public static final int ClassLoaderReference = 14;
    public static final int ClassLoaderReference_VisibleClasses = 1;
    public static final int EventRequest = 15;
    public static final int EventRequest_Set = 1;
    public static final int EventRequest_Clear = 2;
    public static final int EventRequest_ClearAllBreakpoints = 3;
    public static final int StackFrame = 16;
    public static final int StackFrame_GetValues = 1;
    public static final int StackFrame_SetValues = 2;
    public static final int StackFrame_ThisObject = 3;
    public static final int StackFrame_PopFrames = 4;
    public static final int ClassObjectReference = 17;
    public static final int ClassObjectReference_ReflectedType = 1;
    public static final int ModuleReference = 18;
    public static final int ModuleReference_Name = 1;
    public static final int ModuleReference_ClassLoader = 2;
    public static final int Event = 64;
    public static final int Event_Composite = 100;

    default public Packet VirtualMachine_Version(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.Version");
    }

    default public Packet VirtualMachine_ClassesBySignature(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.ClassesBySignature");
    }

    default public Packet VirtualMachine_AllClasses(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.AllClasses");
    }

    default public Packet VirtualMachine_AllThreads(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.AllThreads");
    }

    default public Packet VirtualMachine_TopLevelThreadGroups(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.TopLevelThreadGroups");
    }

    default public Packet VirtualMachine_Dispose(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.Dispose");
    }

    default public Packet VirtualMachine_IDSizes(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.IDSizes");
    }

    default public Packet VirtualMachine_Suspend(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.Suspend");
    }

    default public Packet VirtualMachine_Resume(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.Resume");
    }

    default public Packet VirtualMachine_Exit(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.Exit");
    }

    default public Packet VirtualMachine_CreateString(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.CreateString");
    }

    default public Packet VirtualMachine_Capabilities(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.Capabilities");
    }

    default public Packet VirtualMachine_ClassPaths(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.ClassPaths");
    }

    default public Packet VirtualMachine_DisposeObjects(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.DisposeObjects");
    }

    default public Packet VirtualMachine_HoldEvents(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.HoldEvents");
    }

    default public Packet VirtualMachine_ReleaseEvents(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.ReleaseEvents");
    }

    default public Packet VirtualMachine_CapabilitiesNew(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.CapabilitiesNew");
    }

    default public Packet VirtualMachine_RedefineClasses(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.RedefineClasses");
    }

    default public Packet VirtualMachine_SetDefaultStratum(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.SetDefaultStratum");
    }

    default public Packet VirtualMachine_AllClassesWithGeneric(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.AllClassesWithGeneric");
    }

    default public Packet VirtualMachine_InstanceCounts(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.InstanceCounts");
    }

    default public Packet VirtualMachine_AllModules(Packet packet) throws JDWPException {
        throw VMError.unimplemented("VirtualMachine.AllModules");
    }

    default public Packet ReferenceType_Signature(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Signature");
    }

    default public Packet ReferenceType_ClassLoader(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.ClassLoader");
    }

    default public Packet ReferenceType_Modifiers(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Modifiers");
    }

    default public Packet ReferenceType_Fields(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Fields");
    }

    default public Packet ReferenceType_Methods(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Methods");
    }

    default public Packet ReferenceType_GetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.GetValues");
    }

    default public Packet ReferenceType_SourceFile(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.SourceFile");
    }

    default public Packet ReferenceType_NestedTypes(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.NestedTypes");
    }

    default public Packet ReferenceType_Status(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Status");
    }

    default public Packet ReferenceType_Interfaces(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Interfaces");
    }

    default public Packet ReferenceType_ClassObject(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.ClassObject");
    }

    default public Packet ReferenceType_SourceDebugExtension(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.SourceDebugExtension");
    }

    default public Packet ReferenceType_SignatureWithGeneric(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.SignatureWithGeneric");
    }

    default public Packet ReferenceType_FieldsWithGeneric(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.FieldsWithGeneric");
    }

    default public Packet ReferenceType_Instances(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Instances");
    }

    default public Packet ReferenceType_MethodsWithGeneric(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.MethodsWithGeneric");
    }

    default public Packet ReferenceType_ClassFileVersion(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.ClassFileVersion");
    }

    default public Packet ReferenceType_ConstantPool(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.ConstantPool");
    }

    default public Packet ReferenceType_Module(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ReferenceType.Module");
    }

    default public Packet ClassType_Superclass(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ClassType.Superclass");
    }

    default public Packet ClassType_SetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ClassType.SetValues");
    }

    default public Packet ClassType_InvokeMethod(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ClassType.InvokeMethod");
    }

    default public Packet ClassType_NewInstance(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ClassType.NewInstance");
    }

    default public Packet ArrayType_NewInstance(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ArrayType.NewInstance");
    }

    default public Packet InterfaceType_InvokeMethod(Packet packet) throws JDWPException {
        throw VMError.unimplemented("InterfaceType.InvokeMethod");
    }

    default public Packet Method_LineTable(Packet packet) throws JDWPException {
        throw VMError.unimplemented("Method.LineTable");
    }

    default public Packet Method_VariableTable(Packet packet) throws JDWPException {
        throw VMError.unimplemented("Method.VariableTable");
    }

    default public Packet Method_Bytecodes(Packet packet) throws JDWPException {
        throw VMError.unimplemented("Method.Bytecodes");
    }

    default public Packet Method_IsObsolete(Packet packet) throws JDWPException {
        throw VMError.unimplemented("Method.IsObsolete");
    }

    default public Packet Method_VariableTableWithGeneric(Packet packet) throws JDWPException {
        throw VMError.unimplemented("Method.VariableTableWithGeneric");
    }

    default public Packet ObjectReference_ReferenceType(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.ReferenceType");
    }

    default public Packet ObjectReference_GetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.GetValues");
    }

    default public Packet ObjectReference_SetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.SetValues");
    }

    default public Packet ObjectReference_MonitorInfo(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.MonitorInfo");
    }

    default public Packet ObjectReference_InvokeMethod(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.InvokeMethod");
    }

    default public Packet ObjectReference_DisableCollection(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.DisableCollection");
    }

    default public Packet ObjectReference_EnableCollection(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.EnableCollection");
    }

    default public Packet ObjectReference_IsCollected(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.IsCollected");
    }

    default public Packet ObjectReference_ReferringObjects(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ObjectReference.ReferringObjects");
    }

    default public Packet StringReference_Value(Packet packet) throws JDWPException {
        throw VMError.unimplemented("StringReference.Value");
    }

    default public Packet ThreadReference_Name(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Name");
    }

    default public Packet ThreadReference_Suspend(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Suspend");
    }

    default public Packet ThreadReference_Resume(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Resume");
    }

    default public Packet ThreadReference_Status(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Status");
    }

    default public Packet ThreadReference_ThreadGroup(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.ThreadGroup");
    }

    default public Packet ThreadReference_Frames(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Frames");
    }

    default public Packet ThreadReference_FrameCount(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.FrameCount");
    }

    default public Packet ThreadReference_OwnedMonitors(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.OwnedMonitors");
    }

    default public Packet ThreadReference_CurrentContendedMonitor(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.CurrentContendedMonitor");
    }

    default public Packet ThreadReference_Stop(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Stop");
    }

    default public Packet ThreadReference_Interrupt(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.Interrupt");
    }

    default public Packet ThreadReference_SuspendCount(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.SuspendCount");
    }

    default public Packet ThreadReference_OwnedMonitorsStackDepthInfo(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.OwnedMonitorsStackDepthInfo");
    }

    default public Packet ThreadReference_ForceEarlyReturn(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.ForceEarlyReturn");
    }

    default public Packet ThreadReference_IsVirtual(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadReference.IsVirtual");
    }

    default public Packet ThreadGroupReference_Name(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadGroupReference.Name");
    }

    default public Packet ThreadGroupReference_Parent(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadGroupReference.Parent");
    }

    default public Packet ThreadGroupReference_Children(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ThreadGroupReference.Children");
    }

    default public Packet ArrayReference_Length(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ArrayReferenc.Length");
    }

    default public Packet ArrayReference_GetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ArrayReferenc.GetValues");
    }

    default public Packet ArrayReference_SetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ArrayReferenc.SetValues");
    }

    default public Packet ClassLoaderReference_VisibleClasses(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ClassLoaderReference.VisibleClasses");
    }

    default public Packet EventRequest_Set(Packet packet) throws JDWPException {
        throw VMError.unimplemented("EventRequest.Set");
    }

    default public Packet EventRequest_Clear(Packet packet) throws JDWPException {
        throw VMError.unimplemented("EventRequest.Clear");
    }

    default public Packet EventRequest_ClearAllBreakpoints(Packet packet) throws JDWPException {
        throw VMError.unimplemented("EventRequest.ClearAllBreakpoints");
    }

    default public Packet StackFrame_GetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("StackFrame.GetValues");
    }

    default public Packet StackFrame_SetValues(Packet packet) throws JDWPException {
        throw VMError.unimplemented("StackFrame.SetValues");
    }

    default public Packet StackFrame_ThisObject(Packet packet) throws JDWPException {
        throw VMError.unimplemented("StackFrame.ThisObject");
    }

    default public Packet StackFrame_PopFrames(Packet packet) throws JDWPException {
        throw VMError.unimplemented("StackFrame.PopFrames");
    }

    default public Packet ClassObjectReference_ReflectedType(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ClassObjectReference.ReflectedType");
    }

    default public Packet ModuleReference_Name(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ModuleReference.Name");
    }

    default public Packet ModuleReference_ClassLoader(Packet packet) throws JDWPException {
        throw VMError.unimplemented("ModuleReference.ClassLoader");
    }

    default public Packet Event_Composite(Packet packet) throws JDWPException {
        throw VMError.unimplemented("Event.Composite");
    }

    default public Packet dispatch(Packet packet) throws JDWPException {
        Packet response = switch (packet.commandSet()) {
            case 1 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.VirtualMachine_Version(packet);
                    }
                    case 2: {
                        yield this.VirtualMachine_ClassesBySignature(packet);
                    }
                    case 3: {
                        yield this.VirtualMachine_AllClasses(packet);
                    }
                    case 4: {
                        yield this.VirtualMachine_AllThreads(packet);
                    }
                    case 5: {
                        yield this.VirtualMachine_TopLevelThreadGroups(packet);
                    }
                    case 6: {
                        yield this.VirtualMachine_Dispose(packet);
                    }
                    case 7: {
                        yield this.VirtualMachine_IDSizes(packet);
                    }
                    case 8: {
                        yield this.VirtualMachine_Suspend(packet);
                    }
                    case 9: {
                        yield this.VirtualMachine_Resume(packet);
                    }
                    case 10: {
                        yield this.VirtualMachine_Exit(packet);
                    }
                    case 11: {
                        yield this.VirtualMachine_CreateString(packet);
                    }
                    case 12: {
                        yield this.VirtualMachine_Capabilities(packet);
                    }
                    case 13: {
                        yield this.VirtualMachine_ClassPaths(packet);
                    }
                    case 14: {
                        yield this.VirtualMachine_DisposeObjects(packet);
                    }
                    case 15: {
                        yield this.VirtualMachine_HoldEvents(packet);
                    }
                    case 16: {
                        yield this.VirtualMachine_ReleaseEvents(packet);
                    }
                    case 17: {
                        yield this.VirtualMachine_CapabilitiesNew(packet);
                    }
                    case 18: {
                        yield this.VirtualMachine_RedefineClasses(packet);
                    }
                    case 19: {
                        yield this.VirtualMachine_SetDefaultStratum(packet);
                    }
                    case 20: {
                        yield this.VirtualMachine_AllClassesWithGeneric(packet);
                    }
                    case 21: {
                        yield this.VirtualMachine_InstanceCounts(packet);
                    }
                    case 22: {
                        yield this.VirtualMachine_AllModules(packet);
                    }
                }
                throw VMError.unimplemented("VirtualMachine command " + packet.command());
            }
            case 2 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ReferenceType_Signature(packet);
                    }
                    case 2: {
                        yield this.ReferenceType_ClassLoader(packet);
                    }
                    case 3: {
                        yield this.ReferenceType_Modifiers(packet);
                    }
                    case 4: {
                        yield this.ReferenceType_Fields(packet);
                    }
                    case 5: {
                        yield this.ReferenceType_Methods(packet);
                    }
                    case 6: {
                        yield this.ReferenceType_GetValues(packet);
                    }
                    case 7: {
                        yield this.ReferenceType_SourceFile(packet);
                    }
                    case 8: {
                        yield this.ReferenceType_NestedTypes(packet);
                    }
                    case 9: {
                        yield this.ReferenceType_Status(packet);
                    }
                    case 10: {
                        yield this.ReferenceType_Interfaces(packet);
                    }
                    case 11: {
                        yield this.ReferenceType_ClassObject(packet);
                    }
                    case 12: {
                        yield this.ReferenceType_SourceDebugExtension(packet);
                    }
                    case 13: {
                        yield this.ReferenceType_SignatureWithGeneric(packet);
                    }
                    case 14: {
                        yield this.ReferenceType_FieldsWithGeneric(packet);
                    }
                    case 15: {
                        yield this.ReferenceType_MethodsWithGeneric(packet);
                    }
                    case 16: {
                        yield this.ReferenceType_Instances(packet);
                    }
                    case 17: {
                        yield this.ReferenceType_ClassFileVersion(packet);
                    }
                    case 18: {
                        yield this.ReferenceType_ConstantPool(packet);
                    }
                    case 19: {
                        yield this.ReferenceType_Module(packet);
                    }
                }
                throw VMError.unimplemented("ReferenceType command " + packet.command());
            }
            case 3 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ClassType_Superclass(packet);
                    }
                    case 2: {
                        yield this.ClassType_SetValues(packet);
                    }
                    case 3: {
                        yield this.ClassType_InvokeMethod(packet);
                    }
                    case 4: {
                        yield this.ClassType_NewInstance(packet);
                    }
                }
                throw VMError.unimplemented("ClassType command " + packet.command());
            }
            case 4 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ArrayType_NewInstance(packet);
                    }
                }
                throw VMError.unimplemented("ArrayType command " + packet.command());
            }
            case 5 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.InterfaceType_InvokeMethod(packet);
                    }
                }
                throw VMError.unimplemented("InterfaceType command " + packet.command());
            }
            case 6 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.Method_LineTable(packet);
                    }
                    case 2: {
                        yield this.Method_VariableTable(packet);
                    }
                    case 3: {
                        yield this.Method_Bytecodes(packet);
                    }
                    case 4: {
                        yield this.Method_IsObsolete(packet);
                    }
                    case 5: {
                        yield this.Method_VariableTableWithGeneric(packet);
                    }
                }
                throw VMError.unimplemented("Method command " + packet.command());
            }
            case 8 -> throw VMError.unimplemented("Field command " + packet.command());
            case 9 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ObjectReference_ReferenceType(packet);
                    }
                    case 2: {
                        yield this.ObjectReference_GetValues(packet);
                    }
                    case 3: {
                        yield this.ObjectReference_SetValues(packet);
                    }
                    case 5: {
                        yield this.ObjectReference_MonitorInfo(packet);
                    }
                    case 6: {
                        yield this.ObjectReference_InvokeMethod(packet);
                    }
                    case 7: {
                        yield this.ObjectReference_DisableCollection(packet);
                    }
                    case 8: {
                        yield this.ObjectReference_EnableCollection(packet);
                    }
                    case 9: {
                        yield this.ObjectReference_IsCollected(packet);
                    }
                    case 10: {
                        yield this.ObjectReference_ReferringObjects(packet);
                    }
                }
                throw VMError.unimplemented("ObjectReference command " + packet.command());
            }
            case 10 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.StringReference_Value(packet);
                    }
                }
                throw VMError.unimplemented("StringReference command " + packet.command());
            }
            case 11 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ThreadReference_Name(packet);
                    }
                    case 2: {
                        yield this.ThreadReference_Suspend(packet);
                    }
                    case 3: {
                        yield this.ThreadReference_Resume(packet);
                    }
                    case 4: {
                        yield this.ThreadReference_Status(packet);
                    }
                    case 5: {
                        yield this.ThreadReference_ThreadGroup(packet);
                    }
                    case 6: {
                        yield this.ThreadReference_Frames(packet);
                    }
                    case 7: {
                        yield this.ThreadReference_FrameCount(packet);
                    }
                    case 8: {
                        yield this.ThreadReference_OwnedMonitors(packet);
                    }
                    case 9: {
                        yield this.ThreadReference_CurrentContendedMonitor(packet);
                    }
                    case 10: {
                        yield this.ThreadReference_Stop(packet);
                    }
                    case 11: {
                        yield this.ThreadReference_Interrupt(packet);
                    }
                    case 12: {
                        yield this.ThreadReference_SuspendCount(packet);
                    }
                    case 13: {
                        yield this.ThreadReference_OwnedMonitorsStackDepthInfo(packet);
                    }
                    case 14: {
                        yield this.ThreadReference_ForceEarlyReturn(packet);
                    }
                    case 15: {
                        yield this.ThreadReference_IsVirtual(packet);
                    }
                }
                throw VMError.unimplemented("ThreadReference command " + packet.command());
            }
            case 12 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ThreadGroupReference_Name(packet);
                    }
                    case 2: {
                        yield this.ThreadGroupReference_Parent(packet);
                    }
                    case 3: {
                        yield this.ThreadGroupReference_Children(packet);
                    }
                }
                throw VMError.unimplemented("ThreadGroupReference command " + packet.command());
            }
            case 13 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ArrayReference_Length(packet);
                    }
                    case 2: {
                        yield this.ArrayReference_GetValues(packet);
                    }
                    case 3: {
                        yield this.ArrayReference_SetValues(packet);
                    }
                }
                throw VMError.unimplemented("ArrayReference command " + packet.command());
            }
            case 14 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ClassLoaderReference_VisibleClasses(packet);
                    }
                }
                throw VMError.unimplemented("ClassLoaderReference command " + packet.command());
            }
            case 15 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.EventRequest_Set(packet);
                    }
                    case 2: {
                        yield this.EventRequest_Clear(packet);
                    }
                    case 3: {
                        yield this.EventRequest_ClearAllBreakpoints(packet);
                    }
                }
                throw VMError.unimplemented("EventRequest command " + packet.command());
            }
            case 16 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.StackFrame_GetValues(packet);
                    }
                    case 2: {
                        yield this.StackFrame_SetValues(packet);
                    }
                    case 3: {
                        yield this.StackFrame_ThisObject(packet);
                    }
                    case 4: {
                        yield this.StackFrame_PopFrames(packet);
                    }
                }
                throw VMError.unimplemented("StackFrame command " + packet.command());
            }
            case 17 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ClassObjectReference_ReflectedType(packet);
                    }
                }
                throw VMError.unimplemented("ClassObjectReference command " + packet.command());
            }
            case 18 -> {
                switch (packet.command()) {
                    case 1: {
                        yield this.ModuleReference_Name(packet);
                    }
                    case 2: {
                        yield this.ModuleReference_ClassLoader(packet);
                    }
                }
                throw VMError.unimplemented("ModuleReference command " + packet.command());
            }
            case 64 -> {
                switch (packet.command()) {
                    case 100: {
                        yield this.Event_Composite(packet);
                    }
                }
                throw VMError.unimplemented("Event command " + packet.command());
            }
            default -> throw VMError.unimplemented("CommandSet " + packet.commandSet());
        };
        return response;
    }

    public static String toString(int commandSet) {
        return switch (commandSet) {
            case 1 -> "VirtualMachine";
            case 2 -> "ReferenceType";
            case 3 -> "ClassType";
            case 4 -> "ArrayType";
            case 5 -> "InterfaceType";
            case 6 -> "Method";
            case 8 -> "Field";
            case 9 -> "ObjectReference";
            case 10 -> "StringReference";
            case 11 -> "ThreadReference";
            case 12 -> "ThreadGroupReference";
            case 13 -> "ArrayReference";
            case 14 -> "ClassLoaderReference";
            case 15 -> "EventRequest";
            case 16 -> "StackFrame";
            case 17 -> "ClassObjectReference";
            case 18 -> "ModuleReference";
            case 64 -> "Event";
            default -> JDWP.unknown(commandSet);
        };
    }

    public static String toString(int commandSet, int command) {
        String string = JDWP.toString(commandSet);
        return string + "." + (switch (commandSet) {
            case 1 -> {
                switch (command) {
                    case 1: {
                        yield "Version";
                    }
                    case 2: {
                        yield "ClassesBySignature";
                    }
                    case 3: {
                        yield "AllClasses";
                    }
                    case 4: {
                        yield "AllThreads";
                    }
                    case 5: {
                        yield "TopLevelThreadGroups";
                    }
                    case 6: {
                        yield "Dispose";
                    }
                    case 7: {
                        yield "IDSizes";
                    }
                    case 8: {
                        yield "Suspend";
                    }
                    case 9: {
                        yield "Resume";
                    }
                    case 10: {
                        yield "Exit";
                    }
                    case 11: {
                        yield "CreateString";
                    }
                    case 12: {
                        yield "Capabilities";
                    }
                    case 13: {
                        yield "ClassPaths";
                    }
                    case 14: {
                        yield "DisposeObjects";
                    }
                    case 15: {
                        yield "HoldEvents";
                    }
                    case 16: {
                        yield "ReleaseEvents";
                    }
                    case 17: {
                        yield "CapabilitiesNew";
                    }
                    case 18: {
                        yield "RedefineClasses";
                    }
                    case 19: {
                        yield "SetDefaultStratum";
                    }
                    case 20: {
                        yield "AllClassesWithGeneric";
                    }
                    case 21: {
                        yield "InstanceCounts";
                    }
                    case 22: {
                        yield "AllModules";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 2 -> {
                switch (command) {
                    case 1: {
                        yield "Signature";
                    }
                    case 2: {
                        yield "ClassLoader";
                    }
                    case 3: {
                        yield "Modifiers";
                    }
                    case 4: {
                        yield "Fields";
                    }
                    case 5: {
                        yield "Methods";
                    }
                    case 6: {
                        yield "GetValues";
                    }
                    case 7: {
                        yield "SourceFile";
                    }
                    case 8: {
                        yield "NestedTypes";
                    }
                    case 9: {
                        yield "Status";
                    }
                    case 10: {
                        yield "Interfaces";
                    }
                    case 11: {
                        yield "ClassObject";
                    }
                    case 12: {
                        yield "SourceDebugExtension";
                    }
                    case 13: {
                        yield "SignatureWithGeneric";
                    }
                    case 14: {
                        yield "FieldsWithGeneric";
                    }
                    case 15: {
                        yield "MethodsWithGeneric";
                    }
                    case 16: {
                        yield "Instances";
                    }
                    case 17: {
                        yield "ClassFileVersion";
                    }
                    case 18: {
                        yield "ConstantPool";
                    }
                    case 19: {
                        yield "Module";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 3 -> {
                switch (command) {
                    case 1: {
                        yield "Superclass";
                    }
                    case 2: {
                        yield "SetValues";
                    }
                    case 3: {
                        yield "InvokeMethod";
                    }
                    case 4: {
                        yield "NewInstance";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 4 -> {
                switch (command) {
                    case 1: {
                        yield "NewInstance";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 5 -> {
                switch (command) {
                    case 1: {
                        yield "InvokeMethod";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 6 -> {
                switch (command) {
                    case 1: {
                        yield "LineTable";
                    }
                    case 2: {
                        yield "VariableTable";
                    }
                    case 3: {
                        yield "Bytecodes";
                    }
                    case 4: {
                        yield "IsObsolete";
                    }
                    case 5: {
                        yield "VariableTableWithGeneric";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 8 -> JDWP.unknown(command);
            case 9 -> {
                switch (command) {
                    case 1: {
                        yield "ReferenceType";
                    }
                    case 2: {
                        yield "GetValues";
                    }
                    case 3: {
                        yield "SetValues";
                    }
                    case 5: {
                        yield "MonitorInfo";
                    }
                    case 6: {
                        yield "InvokeMethod";
                    }
                    case 7: {
                        yield "DisableCollection";
                    }
                    case 8: {
                        yield "EnableCollection";
                    }
                    case 9: {
                        yield "IsCollected";
                    }
                    case 10: {
                        yield "ReferringObjects";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 10 -> {
                switch (command) {
                    case 1: {
                        yield "Value";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 11 -> {
                switch (command) {
                    case 1: {
                        yield "Name";
                    }
                    case 2: {
                        yield "Suspend";
                    }
                    case 3: {
                        yield "Resume";
                    }
                    case 4: {
                        yield "Status";
                    }
                    case 5: {
                        yield "ThreadGroup";
                    }
                    case 6: {
                        yield "Frames";
                    }
                    case 7: {
                        yield "FrameCount";
                    }
                    case 8: {
                        yield "OwnedMonitors";
                    }
                    case 9: {
                        yield "CurrentContendedMonitor";
                    }
                    case 10: {
                        yield "Stop";
                    }
                    case 11: {
                        yield "Interrupt";
                    }
                    case 12: {
                        yield "SuspendCount";
                    }
                    case 13: {
                        yield "OwnedMonitorsStackDepthInfo";
                    }
                    case 14: {
                        yield "ForceEarlyReturn";
                    }
                    case 15: {
                        yield "IsVirtual";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 12 -> {
                switch (command) {
                    case 1: {
                        yield "Name";
                    }
                    case 2: {
                        yield "Parent";
                    }
                    case 3: {
                        yield "Children";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 13 -> {
                switch (command) {
                    case 1: {
                        yield "Length";
                    }
                    case 2: {
                        yield "GetValues";
                    }
                    case 3: {
                        yield "SetValues";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 14 -> {
                switch (command) {
                    case 1: {
                        yield "VisibleClasses";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 15 -> {
                switch (command) {
                    case 1: {
                        yield "Set";
                    }
                    case 2: {
                        yield "Clear";
                    }
                    case 3: {
                        yield "ClearAllBreakpoints";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 16 -> {
                switch (command) {
                    case 1: {
                        yield "GetValues";
                    }
                    case 2: {
                        yield "SetValues";
                    }
                    case 3: {
                        yield "ThisObject";
                    }
                    case 4: {
                        yield "PopFrames";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 17 -> {
                switch (command) {
                    case 1: {
                        yield "ReflectedType";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 18 -> {
                switch (command) {
                    case 1: {
                        yield "Name";
                    }
                    case 2: {
                        yield "ClassLoader";
                    }
                }
                yield JDWP.unknown(command);
            }
            case 64 -> {
                switch (command) {
                    case 100: {
                        yield "Composite";
                    }
                }
                yield JDWP.unknown(command);
            }
            default -> JDWP.unknown(command);
        });
    }

    private static String unknown(int id) {
        return "<UNKNOWN(" + id + ")>";
    }

    public static byte readTag(Packet.Reader reader) throws JDWPException {
        byte tag = (byte)reader.readByte();
        if (TagConstants.isValidTag(tag)) {
            return tag;
        }
        throw JDWPException.raise(ErrorCode.INVALID_TAG);
    }
}

