/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

public final class EventKind
extends Enum<EventKind> {
    public static final /* enum */ EventKind SINGLE_STEP = new EventKind(1);
    public static final /* enum */ EventKind BREAKPOINT = new EventKind(2);
    public static final /* enum */ EventKind FRAME_POP = new EventKind(3);
    public static final /* enum */ EventKind EXCEPTION = new EventKind(4);
    public static final /* enum */ EventKind USER_DEFINED = new EventKind(5);
    public static final /* enum */ EventKind THREAD_START = new EventKind(6);
    public static final /* enum */ EventKind THREAD_DEATH = new EventKind(7);
    public static final /* enum */ EventKind CLASS_PREPARE = new EventKind(8);
    public static final /* enum */ EventKind CLASS_UNLOAD = new EventKind(9);
    public static final /* enum */ EventKind CLASS_LOAD = new EventKind(10);
    public static final /* enum */ EventKind FIELD_ACCESS = new EventKind(20);
    public static final /* enum */ EventKind FIELD_MODIFICATION = new EventKind(21);
    public static final /* enum */ EventKind EXCEPTION_CATCH = new EventKind(30);
    public static final /* enum */ EventKind METHOD_ENTRY = new EventKind(40);
    public static final /* enum */ EventKind METHOD_EXIT = new EventKind(41);
    public static final /* enum */ EventKind METHOD_EXIT_WITH_RETURN_VALUE = new EventKind(42);
    public static final /* enum */ EventKind MONITOR_CONTENDED_ENTER = new EventKind(43);
    public static final /* enum */ EventKind MONITOR_CONTENDED_ENTERED = new EventKind(44);
    public static final /* enum */ EventKind MONITOR_WAIT = new EventKind(45);
    public static final /* enum */ EventKind MONITOR_WAITED = new EventKind(46);
    public static final /* enum */ EventKind VM_START = new EventKind(90);
    public static final /* enum */ EventKind VM_DEATH = new EventKind(99);
    public static final /* enum */ EventKind VM_DISCONNECTED = new EventKind(100);
    private final byte eventId;
    private static final EventKind[] VALUES;
    private static final /* synthetic */ EventKind[] $VALUES;

    public static EventKind[] values() {
        return (EventKind[])$VALUES.clone();
    }

    public static EventKind valueOf(String name) {
        return Enum.valueOf(EventKind.class, name);
    }

    private EventKind(int id) {
        assert (0 < id && id < 127) : id;
        this.eventId = (byte)id;
    }

    public byte getEventId() {
        return this.eventId;
    }

    public static EventKind fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public static EventKind of(byte eventId) {
        int low = 0;
        int high = VALUES.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            EventKind midKind = VALUES[mid];
            if (midKind.eventId < eventId) {
                low = mid + 1;
                continue;
            }
            if (midKind.eventId > eventId) {
                high = mid - 1;
                continue;
            }
            return midKind;
        }
        return null;
    }

    public boolean matchesFlag(int flags) {
        assert (this.ordinal() < 32) : "Flag overflow, ordinal = " + this.ordinal();
        int myFlag = 1 << this.ordinal();
        return (flags & myFlag) != 0;
    }

    private static /* synthetic */ EventKind[] $values() {
        return new EventKind[]{SINGLE_STEP, BREAKPOINT, FRAME_POP, EXCEPTION, USER_DEFINED, THREAD_START, THREAD_DEATH, CLASS_PREPARE, CLASS_UNLOAD, CLASS_LOAD, FIELD_ACCESS, FIELD_MODIFICATION, EXCEPTION_CATCH, METHOD_ENTRY, METHOD_EXIT, METHOD_EXIT_WITH_RETURN_VALUE, MONITOR_CONTENDED_ENTER, MONITOR_CONTENDED_ENTERED, MONITOR_WAIT, MONITOR_WAITED, VM_START, VM_DEATH, VM_DISCONNECTED};
    }

    static {
        $VALUES = EventKind.$values();
        VALUES = EventKind.values();
    }
}

