/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterConstantPool;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;

public final class InterpreterResolvedObjectType
extends InterpreterResolvedJavaType {
    private final InterpreterResolvedJavaType componentType;
    private final int modifiers;
    private final InterpreterResolvedObjectType superclass;
    private final InterpreterResolvedObjectType[] interfaces;
    private InterpreterResolvedJavaMethod[] declaredMethods;
    private InterpreterConstantPool constantPool;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ResolvedJavaType originalType;
    private final String sourceFileName;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterAnalysis.class)
    private VTableHolder vtableHolder = null;

    private InterpreterResolvedObjectType(String name, int modifiers, InterpreterResolvedJavaType componentType, InterpreterResolvedObjectType superclass, InterpreterResolvedObjectType[] interfaces, InterpreterConstantPool constantPool, JavaConstant clazzConstant, boolean isWordType, String sourceFileName) {
        super(name, clazzConstant, isWordType);
        this.modifiers = modifiers;
        this.componentType = componentType;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.constantPool = constantPool;
        this.sourceFileName = sourceFileName;
    }

    private InterpreterResolvedObjectType(String name, int modifiers, InterpreterResolvedJavaType componentType, InterpreterResolvedObjectType superclass, InterpreterResolvedObjectType[] interfaces, InterpreterConstantPool constantPool, Class<?> javaClass, boolean isWordType) {
        super(name, javaClass, isWordType);
        assert (isWordType == WordBase.class.isAssignableFrom(javaClass));
        this.modifiers = modifiers;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.componentType = componentType;
        this.constantPool = constantPool;
        this.sourceFileName = DynamicHub.fromClass(javaClass).getSourceFileName();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private InterpreterResolvedObjectType(ResolvedJavaType originalType, String name, int modifiers, InterpreterResolvedJavaType componentType, InterpreterResolvedObjectType superclass, InterpreterResolvedObjectType[] interfaces, InterpreterConstantPool constantPool, Class<?> javaClass, String sourceFileName) {
        super(name, javaClass);
        this.originalType = originalType;
        this.modifiers = modifiers;
        this.componentType = componentType;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.constantPool = constantPool;
        this.sourceFileName = sourceFileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterResolvedObjectType createAtBuildTime(ResolvedJavaType originalType, String name, int modifiers, InterpreterResolvedJavaType componentType, InterpreterResolvedObjectType superclass, InterpreterResolvedObjectType[] interfaces, InterpreterConstantPool constantPool, Class<?> javaClass, String sourceFileName) {
        return new InterpreterResolvedObjectType(originalType, name, modifiers, componentType, superclass, interfaces, constantPool, javaClass, sourceFileName);
    }

    public static InterpreterResolvedObjectType createForInterpreter(String name, int modifiers, InterpreterResolvedJavaType componentType, InterpreterResolvedObjectType superclass, InterpreterResolvedObjectType[] interfaces, InterpreterConstantPool constantPool, Class<?> javaClass, boolean isWordType) {
        return new InterpreterResolvedObjectType(name, modifiers, componentType, superclass, interfaces, constantPool, javaClass, isWordType);
    }

    public static InterpreterResolvedObjectType createWithOpaqueClass(String name, int modifiers, InterpreterResolvedJavaType componentType, InterpreterResolvedObjectType superclass, InterpreterResolvedObjectType[] interfaces, InterpreterConstantPool constantPool, JavaConstant clazzConstant, boolean isWordType, String sourceFileName) {
        return new InterpreterResolvedObjectType(name, modifiers, componentType, superclass, interfaces, constantPool, clazzConstant, isWordType, sourceFileName);
    }

    public void setConstantPool(InterpreterConstantPool constantPool) {
        VMError.guarantee(this == constantPool.getHolder());
        this.constantPool = MetadataUtil.requireNonNull(constantPool);
    }

    public InterpreterConstantPool getConstantPool() {
        assert (!this.isArray());
        return this.constantPool;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ResolvedJavaType getOriginalType() {
        return this.originalType;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public InterpreterResolvedJavaType getComponentType() {
        return this.componentType;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public InterpreterResolvedObjectType getSuperclass() {
        return this.superclass;
    }

    public InterpreterResolvedObjectType[] getInterfaces() {
        return this.interfaces;
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        if (other instanceof InterpreterResolvedObjectType) {
            InterpreterResolvedObjectType o = (InterpreterResolvedObjectType)other;
            return InterpreterResolvedObjectType.isSubTypeOf(this, o);
        }
        return false;
    }

    private static boolean isSubTypeOf(InterpreterResolvedObjectType superType, InterpreterResolvedObjectType subType) {
        if (subType.equals(superType)) {
            return true;
        }
        if (subType.superclass != null && InterpreterResolvedObjectType.isSubTypeOf(superType, subType.superclass)) {
            return true;
        }
        for (InterpreterResolvedObjectType interf : subType.interfaces) {
            if (!InterpreterResolvedObjectType.isSubTypeOf(superType, interf)) continue;
            return true;
        }
        return false;
    }

    public InterpreterResolvedJavaMethod[] getVtable() {
        if (this.vtableHolder == null) {
            return null;
        }
        return this.vtableHolder.vtable;
    }

    public void setVtable(InterpreterResolvedJavaMethod[] vtable) {
        this.vtableHolder = new VTableHolder(this, vtable);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VTableHolder getVtableHolder() {
        assert (!this.isArray());
        return this.vtableHolder;
    }

    @Override
    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    public void setDeclaredMethods(InterpreterResolvedJavaMethod[] declaredMethods) {
        this.declaredMethods = declaredMethods;
    }

    public static class VTableHolder {
        @UnknownObjectField(availability=BuildPhaseProvider.AfterAnalysis.class)
        public InterpreterResolvedObjectType holder;
        @UnknownObjectField(availability=BuildPhaseProvider.AfterAnalysis.class)
        public InterpreterResolvedJavaMethod[] vtable;

        public VTableHolder(InterpreterResolvedObjectType holder, InterpreterResolvedJavaMethod[] vtable) {
            this.holder = holder;
            this.vtable = vtable;
        }
    }
}

