/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class InterpreterResolvedJavaField
implements ResolvedJavaField {
    private int offset;
    private final int modifiers;
    private final String name;
    private final InterpreterResolvedJavaType type;
    private final InterpreterResolvedObjectType declaringClass;
    private JavaConstant constantValue;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ResolvedJavaField originalField;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private boolean artificiallyReachable;
    public static final int FIELD_UNMATERIALIZED = -10;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private InterpreterResolvedJavaField(ResolvedJavaField originalField, String name, int modifiers, InterpreterResolvedJavaType type, InterpreterResolvedObjectType declaringClass, int offset, JavaConstant constant) {
        this.originalField = originalField;
        this.name = MetadataUtil.requireNonNull(name);
        this.modifiers = modifiers;
        this.type = MetadataUtil.requireNonNull(type);
        this.declaringClass = MetadataUtil.requireNonNull(declaringClass);
        this.offset = offset;
        this.constantValue = constant;
    }

    private InterpreterResolvedJavaField(String name, int modifiers, InterpreterResolvedJavaType type, InterpreterResolvedObjectType declaringClass, int offset, JavaConstant constant) {
        this.name = MetadataUtil.requireNonNull(name);
        this.modifiers = modifiers;
        this.type = MetadataUtil.requireNonNull(type);
        this.declaringClass = MetadataUtil.requireNonNull(declaringClass);
        this.offset = offset;
        this.constantValue = constant;
    }

    public static InterpreterResolvedJavaField create(String name, int modifiers, InterpreterResolvedJavaType type, InterpreterResolvedObjectType declaringClass, int offset, JavaConstant constant) {
        return new InterpreterResolvedJavaField(name, modifiers, type, declaringClass, offset, constant);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterResolvedJavaField create(ResolvedJavaField originalField, String name, int modifiers, InterpreterResolvedJavaType type, InterpreterResolvedObjectType declaringClass, int offset, JavaConstant constant) {
        return new InterpreterResolvedJavaField(originalField, name, modifiers, type, declaringClass, offset, constant);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ResolvedJavaField getOriginalField() {
        return this.originalField;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setUnmaterializedConstant(JavaConstant constant) {
        assert (JavaConstant.NULL_POINTER.equals((Object)constant) || constant instanceof PrimitiveConstant || constant instanceof ReferenceConstant);
        this.offset = -10;
        this.constantValue = constant;
    }

    public boolean isUnmaterializedConstant() {
        return this.offset == -10;
    }

    public boolean isUndefined() {
        return this.isUnmaterializedConstant() && this.getUnmaterializedConstant().getJavaKind() == JavaKind.Illegal;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public InterpreterResolvedJavaType getType() {
        return this.type;
    }

    public InterpreterResolvedObjectType getDeclaringClass() {
        return this.declaringClass;
    }

    public JavaConstant getUnmaterializedConstant() {
        assert (this.offset == -10);
        assert (this.getType().isWordType() || this.constantValue == JavaConstant.ILLEGAL || this.getJavaKind() == this.constantValue.getJavaKind());
        return this.constantValue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isArtificiallyReachable() {
        return this.artificiallyReachable;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void markAsArtificiallyReachable() {
        this.artificiallyReachable = true;
    }

    public String toString() {
        return "InterpreterResolvedJavaField<holder=" + this.getDeclaringClass().getName() + " name=" + this.getName() + " descriptor=" + this.getType().getName() + " offset=" + this.getOffset() + ">";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InterpreterResolvedJavaField)) {
            return false;
        }
        InterpreterResolvedJavaField that = (InterpreterResolvedJavaField)other;
        return this.name.equals(that.name) && this.declaringClass.equals(that.declaringClass) && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = MetadataUtil.hashCode(this.name);
        result = 31 * result + MetadataUtil.hashCode(this.declaringClass);
        result = 31 * result + MetadataUtil.hashCode(this.type);
        return result;
    }

    public boolean isInternal() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isSynthetic() {
        throw VMError.intentionallyUnimplemented();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw VMError.intentionallyUnimplemented();
    }

    public Annotation[] getAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public Annotation[] getDeclaredAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }
}

